/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.common.core.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.common.core.files.IFilter;
import org.eclipse.modisco.common.core.internal.Activator;
import org.osgi.framework.Bundle;

public class FileUtils {
    private static final int COPY_BUFFER_SIZE = 524288;
    private static final IFilter checkstyleFilter = new IFilter(){

        @Override
        public boolean filter(Object object) {
            boolean result = true;
            if (object instanceof File) {
                File file = (File)object;
                result = !file.getName().equals(".checkstyle");
            } else if (object instanceof String) {
                String str = (String)object;
                result = !str.equals(".checkstyle");
            }
            return result;
        }
    };

    public static final void copyDirectory(File srcDir, File destDir, IFilter filter) throws IOException {
        HashMap<File, File> src2dest = new HashMap<File, File>();
        FileUtils.copyDirectory2(srcDir, destDir, filter, src2dest);
        for (File srcDir2 : src2dest.keySet()) {
            File destDir2 = (File)src2dest.get(srcDir2);
            if (!destDir2.exists()) {
                destDir2.mkdirs();
            }
            File[] fileArray = srcDir2.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dest;
                File src = fileArray[n2];
                if (!src.isDirectory() && filter.filter(dest = new File(String.valueOf(destDir2.getPath()) + File.separator + src.getName()))) {
                    FileUtils.copyFile(src, dest);
                }
                ++n2;
            }
        }
    }

    private static final void copyDirectory2(File srcDir, File destDir, IFilter filter, Map<File, File> src2dest) throws IOException {
        src2dest.put(srcDir, destDir);
        File[] fileArray = srcDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dest;
            File src = fileArray[n2];
            if (src.isDirectory() && filter.filter(dest = new File(String.valueOf(destDir.getPath()) + File.separator + src.getName()))) {
                FileUtils.copyDirectory2(src, dest, filter, src2dest);
            }
            ++n2;
        }
    }

    public static final boolean copyFile(File source, File destination) {
        boolean result = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            try {
                int nbRead;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbRead = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbRead);
                }
                result = true;
            }
            catch (FileNotFoundException f) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e) {
                    result = false;
                }
            }
            catch (IOException e) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e2) {
                    result = false;
                }
            }
        }
        finally {
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
                if (destinationFile != null) {
                    destinationFile.close();
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public static IFile copyFileFromBundle(Bundle sourceBundle, String sourcePath, IProject targetProject, String targetPath) throws Exception {
        IFile javaFile;
        InputStream source;
        block8: {
            URL url = sourceBundle.getResource(sourcePath);
            if (url == null) {
                throw new IOException(sourceBundle + " has no " + sourcePath + " entry");
            }
            source = url.openStream();
            javaFile = targetProject.getFile(targetPath);
            if (javaFile.exists()) {
                try {
                    javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    if (!targetProject.isOpen()) break block8;
                    try {
                        targetProject.close((IProgressMonitor)new NullProgressMonitor());
                        javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    finally {
                        targetProject.open((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        }
        if (!javaFile.getParent().exists()) {
            FileUtils.createFolder((IFolder)javaFile.getParent());
        }
        javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
        return javaFile;
    }

    public static void copyFolderFromBundle(Bundle sourceBundle, String sourcePath, IProject targetProject, String targetPath) throws IOException, CoreException {
        Enumeration e = sourceBundle.getEntryPaths(sourcePath);
        if (e == null) {
            URL entry = sourceBundle.getResource(sourcePath);
            if (entry == null) {
                throw new IOException(sourceBundle + " has no " + sourcePath + " entry");
            }
            InputStream source = entry.openStream();
            IFile javaFile = targetProject.getFile(targetPath);
            if (javaFile.exists()) {
                javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            String subDestinationPath = "/";
            if (!targetPath.equals("/")) {
                IFolder folder = targetProject.getFolder(targetPath);
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e1) {
                        Logger.logError(e1, (Plugin)Activator.getDefault());
                    }
                }
                subDestinationPath = folder.getProjectRelativePath().toString();
            }
            while (e.hasMoreElements()) {
                Object object = e.nextElement();
                if (object instanceof String) {
                    String subpath = (String)object;
                    if (subpath.matches(".*/\\.svn/")) continue;
                    String dest = String.valueOf(subDestinationPath) + subpath.substring(sourcePath.length() - 1);
                    FileUtils.copyFolderFromBundle(sourceBundle, subpath, targetProject, dest);
                    continue;
                }
                throw new RuntimeException("Unexpected element type");
            }
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.getParent().exists()) {
            FileUtils.createFolder((IFolder)folder.getParent());
        }
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IFilter getCheckstylefilter() {
        return checkstyleFilter;
    }

    public static final String getFileContent(File source) {
        StringBuilder result;
        block18: {
            result = new StringBuilder();
            BufferedReader sourceReader = null;
            try {
                sourceReader = new BufferedReader(new FileReader(source));
                String sourceLine = sourceReader.readLine();
                while (sourceLine != null) {
                    result.append(sourceLine);
                    result.append("\n");
                    sourceLine = sourceReader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                Logger.logError(e, (Plugin)Activator.getDefault());
                if (sourceReader != null) {
                    try {
                        sourceReader.close();
                    }
                    catch (IOException e2) {
                        Logger.logError(e2, (Plugin)Activator.getDefault());
                    }
                }
                break block18;
            }
            catch (IOException e) {
                try {
                    Logger.logError(e, (Plugin)Activator.getDefault());
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (sourceReader != null) {
                        try {
                            sourceReader.close();
                        }
                        catch (IOException e3) {
                            Logger.logError(e3, (Plugin)Activator.getDefault());
                        }
                    }
                }
            }
            if (sourceReader == null) break block18;
            try {
                sourceReader.close();
            }
            catch (IOException e) {
                Logger.logError(e, (Plugin)Activator.getDefault());
            }
        }
        return result.toString();
    }

    public static String getFileContents(Bundle bundle, String path) throws IOException {
        URL url = bundle.getResource(path);
        if (url == null) {
            return null;
        }
        InputStream source = url.openStream();
        return FileUtils.readInputStream(source);
    }

    public static IFile getWorkspaceFile(Resource resource) {
        URI uri = resource.getURI();
        if (uri != null && uri.isPlatformResource() && uri.segmentCount() >= 2) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(uri.segment(1));
            Path path = new Path("/");
            int i = 2;
            while (i < uri.segmentCount()) {
                path = path.append(uri.segment(i));
                ++i;
            }
            IFile file = project.getFile((IPath)path);
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInOutputLocation(IFile file) {
        try {
            IClasspathEntry[] rawClasspath;
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            if (javaProject == null) return false;
            if (javaProject.getOutputLocation().isPrefixOf(file.getFullPath())) {
                return true;
            }
            IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
            int n = rawClasspath.length;
            int n2 = 0;
            while (true) {
                IPath outputLocation;
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getContentKind() == 1 && (outputLocation = classpathEntry.getOutputLocation()) != null && outputLocation.isPrefixOf(file.getFullPath())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logger.logError(e, (Plugin)Activator.getDefault());
        }
        return false;
    }

    public static String readInputStream(InputStream stream) throws IOException {
        return FileUtils.readInputStream(stream, "UTF-8");
    }

    public static String readInputStream(InputStream stream, String charset) throws IOException {
        int read;
        int bufferSize = 65536;
        char[] buffer = new char[65536];
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(stream, charset);
        do {
            if ((read = ((Reader)reader).read(buffer, 0, buffer.length)) <= 0) continue;
            builder.append(buffer, 0, read);
        } while (read >= 0);
        ((Reader)reader).close();
        return builder.toString();
    }

    protected FileUtils() {
        throw new IllegalStateException();
    }
}

