/*******************************************************************************
 * Copyright (c) 2010, 2026 Mia-Software and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *    Fabien Giquel (Mia-Software) - initial API and implementation
 *    Nicolas Bros (Mia-Software)
 *    Nicolas Bros (Mia-Software) - Bug 339657 - Move Logger to org.eclipse.modisco.facet.util.core
 *    Nicolas Bros (Mia-Software) - Bug 340031 - NPE in org.eclipse.modisco.facet.util.core.Logger#log
 *    Grégoire Dupé (Mia-Software) - Bug 483451 - Logger and DebugUtils : Add "String.format" API
 *******************************************************************************/
package org.eclipse.modisco.facet.util.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.modisco.facet.util.core.internal.Activator;

/**
 * Helper for logging using Eclipse API
 * 
 * @author fgiquel
 * 
 */
@Deprecated /* @deprecated use org.eclipse.modisco.common.core.Logger */
public final class Logger {

	private Logger() {
		// Nothing
	}

	@Deprecated
	public static void logError(final Throwable e, final Plugin plugin) {
		Logger.log(e, IStatus.ERROR, e.getMessage(), plugin);
	}

	@Deprecated
	public static void logError(final String message, final Plugin plugin) {
		Logger.log(null, IStatus.ERROR, message, plugin);
	}

	@Deprecated
	public static void logError(final Throwable e, final String message, final Plugin plugin) {
		Logger.log(e, IStatus.ERROR, message, plugin);
	}

	@Deprecated
	public static void logWarning(final Throwable e, final Plugin plugin) {
		Logger.log(e, IStatus.WARNING, e.getMessage(), plugin);
	}

	@Deprecated
	public static void logWarning(final String message, final Plugin plugin) {
		Logger.log(null, IStatus.WARNING, message, plugin);
	}

	@Deprecated
	public static void logWarning(final Throwable e, final String message, final Plugin plugin) {
		Logger.log(e, IStatus.WARNING, message, plugin);
	}

	@Deprecated
	public static void logInfo(final Throwable e, final Plugin plugin) {
		Logger.log(e, IStatus.INFO, e.getMessage(), plugin);
	}

	@Deprecated
	public static void logInfo(final String message, final Plugin plugin) {
		Logger.log(null, IStatus.INFO, message, plugin);
	}

	/**
	 * @since 1.1
	 * @param messageTemplate
	 *            A format string (cf. java.util.Formatter)
	 * @param args
	 *            Arguments referenced by messageTemplates
	 */
	@Deprecated
	public static void logError(final Plugin plugin,
			final String messageTemplate, final Object... args) {
		Logger.log(null, IStatus.ERROR, plugin, messageTemplate, args);
	}

	/**
	 * @since 1.1
	 * @param messageTemplate
	 *            A format string (cf. java.util.Formatter)
	 * @param args
	 *            Arguments referenced by messageTemplates
	 */
	@Deprecated
	public static void logError(final Throwable e, final Plugin plugin,
			final String messageTemplate, final Object... args) {
		Logger.log(e, IStatus.ERROR, plugin, messageTemplate, args);
	}

	/**
	 * @since 1.1
	 * @param messageTemplate
	 *            A format string (cf. java.util.Formatter)
	 * @param args
	 *            Arguments referenced by messageTemplates
	 */
	@Deprecated
	public static void logWarning(final Plugin plugin,
			final String messageTemplace, final Object... args) {
		Logger.log(null, IStatus.WARNING, plugin, messageTemplace, args);
	}

	/**
	 * @since 1.1
	 */
	@Deprecated
	public static void logWarning(final Throwable e, final Plugin plugin,
			final String messageTemplace, final Object... args) {
		Logger.log(e, IStatus.WARNING, plugin, messageTemplace, args);
	}

	/**
	 * @since 1.1
	 * @param messageTemplate
	 *            A format string (cf. java.util.Formatter)
	 * @param args
	 *            Arguments referenced by messageTemplates
	 */
	@Deprecated
	public static void logInfo(final Plugin plugin,
			final String messageTemplace, final Object... args) {
		Logger.log(null, IStatus.INFO, plugin, messageTemplace, args);
	}

	/**
	 * An exception that is instantiated with the sole purpose of providing a
	 * stack trace when there wouldn't be one otherwise.
	 */
	@Deprecated
	protected static class LogStackTrace extends Exception {
		private static final long serialVersionUID = 309882934616507415L;
	}

	/**
	 * @since 1.1
	 * @param messageTemplate
	 *            A format string (cf. java.util.Formatter)
	 * @param args
	 *            Arguments referenced by messageTemplates
	 */
	@Deprecated
	public static void log(final Throwable e, final int level,
			final Plugin plugin, final String messageTemplate,
			final Object... args) {
		final String message = String.format(messageTemplate, args);
		log(e, level, message, plugin);
	}
	
	@Deprecated
	public static void log(final Throwable e, final int level,
			final String message, final Plugin plugin) {

		Throwable effectiveE = e;
		Plugin effectivePlugin = plugin;
		String effectiveMessage = message;
		IStatus status = null;

		if (effectiveE instanceof InvocationTargetException) {
			effectiveE = ((InvocationTargetException) effectiveE).getTargetException();
		}
		if (effectivePlugin == null) {
			effectivePlugin = Activator.getDefault();
		}

		if (effectiveE instanceof CoreException) {
			MultiStatus mstatus = new MultiStatus(plugin.getBundle().getSymbolicName(), level,
					new IStatus[] { ((CoreException) effectiveE).getStatus() }, message, effectiveE);
			status = mstatus;
		} else {
			if (effectiveMessage == null && effectiveE != null) {
				effectiveMessage = effectiveE.getMessage();
			}
			if (effectiveMessage == null && effectiveE != null) {
				effectiveMessage = effectiveE.toString();
			}
			if (effectiveMessage == null) {
				effectiveMessage = ""; //$NON-NLS-1$
			}
			try {
				effectiveMessage = effectiveMessage + " (" //$NON-NLS-1$
						+ effectivePlugin.getBundle().getSymbolicName() + "_" //$NON-NLS-1$
						+ effectivePlugin.getBundle().getVersion() + ")"; //$NON-NLS-1$
			} catch (NullPointerException e2) {
				effectiveMessage += " (activator class = " //$NON-NLS-1$
						+ effectivePlugin.getClass().getName() + ")"; //$NON-NLS-1$
			}
			if ((effectiveE == null) && (level > IStatus.INFO)) {
				// record a stacktrace
				effectiveE = new LogStackTrace();
			}
			status = new Status(level, effectivePlugin.getBundle().getSymbolicName(),
					effectiveMessage, effectiveE);
		}
		if (expectedStatusesStack != null) {
			Set<IStatus> expectedStatuses = expectedStatusesStack.peek();
			for (IStatus expectedStatus : expectedStatuses) {
				if (isEqual(status, expectedStatus)) {
					expectedStatuses.remove(expectedStatus);
					if (expectedStatuses.isEmpty()) {
						expectedStatusesStack.pop();
						if (expectedStatusesStack.isEmpty()) {
							expectedStatusesStack = null;
						}
					}
					return;		// Suppress expected status logging
				}
			}
			IStatus extraStatus = new Status(IStatus.ERROR, effectivePlugin.getBundle().getSymbolicName(),
					"Expected messages were not logged", null);
			effectivePlugin.getLog().log(extraStatus);
		}
		effectivePlugin.getLog().log(status);
	}

	// private static String getPosition() {
	// try {
	// // get the stack element corresponding to the caller of the log
	// // method
	// StackTraceElement element = new Exception().getStackTrace()[2];
	//			return " \n[" + element.getClassName() + "#" + element.getMethodName() + " : " //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	//					+ element.getLineNumber() + "]"; //$NON-NLS-1$
	// } catch (Throwable e) {
	//			return ""; //$NON-NLS-1$
	// }
	// }
	
	/**
	 * @since 1.6
	 */
	private static boolean isEqual(IStatus status, IStatus expectedStatus) {
		if (status.getSeverity() != expectedStatus.getSeverity()) {
			return false;
		}
		if (expectedStatus.getException() == null) {
			if (!(status.getException() instanceof LogStackTrace)) {
				return false;
			}
		}
		else if (!Objects.equals(status.getException(), expectedStatus.getException())) {
			return false;
		}
		if (!status.getMessage().startsWith(expectedStatus.getMessage())) {
			return false;
		}
		return true;
	}

	private static Stack<Set<IStatus>> expectedStatusesStack = null;
	
	/**
	 * @since 1.6
	 */
	@Deprecated
	public static void addExpectedStatuses(Set<IStatus> expectedStatuses) {
		if (expectedStatusesStack == null) {
			expectedStatusesStack = new Stack<>();
		}
		expectedStatusesStack.push(expectedStatuses);
	}
	
	/**
	 * @since 1.6
	 */
	@Deprecated
	public static Stack<Set<IStatus>> resetExpectedStatuses() {
		try {
			return expectedStatusesStack;
		}
		finally {
			expectedStatusesStack = null;
		}
	}
}
