/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.emf.core.internal.catalog.v2;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.facet.util.emf.core.internal.Activator;
import org.eclipse.modisco.facet.util.emf.core.internal.catalog.v2.CatalogListenerFactory;

class CatalogListener
implements Adapter {
    private final Resource resource;
    private static final Map<String, String> SAVE_OPTIONS = new HashMap<String, String>();
    private EObject target;

    static {
        String fileEncoding = System.getProperty("file.encoding");
        SAVE_OPTIONS.put("ENCODING", fileEncoding);
    }

    public CatalogListener(Resource resource) {
        this.resource = resource;
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        switch (eventType) {
            case 1: {
                this.notifyChangedForSet(notification);
                break;
            }
            case 3: {
                this.notifyChangedForAdd(notification);
                break;
            }
            case 5: {
                this.notifyChangedForAddMany(notification);
                break;
            }
            case 4: {
                CatalogListener.notifyChangedForRemove(notification);
                break;
            }
            case 6: {
                CatalogListener.notifyChangedForRemoveMany(notification);
                break;
            }
        }
        try {
            URI uri = this.resource.getURI();
            String uriStr = uri.toString();
            if (!uriStr.startsWith("tmp")) {
                this.resource.save(SAVE_OPTIONS);
            }
        }
        catch (IOException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private void notifyChangedForSet(Notification notification) {
        Object newValue = notification.getNewValue();
        CatalogListenerFactory.adapt(newValue, this.resource);
    }

    private static void notifyChangedForRemoveMany(Notification notification) {
        final Collection oldValues = (Collection)notification.getOldValue();
        CatalogListener.ifIsContainement(notification, new Runnable(){

            @Override
            public void run() {
                for (Object oldValuesItem : oldValues) {
                    CatalogListenerFactory.removeAdapter(oldValuesItem);
                }
            }
        });
    }

    private static void notifyChangedForRemove(Notification notification) {
        final Object oldValue = notification.getOldValue();
        CatalogListener.ifIsContainement(notification, new Runnable(){

            @Override
            public void run() {
                CatalogListenerFactory.removeAdapter(oldValue);
            }
        });
    }

    private void notifyChangedForAddMany(Notification notification) {
        final Collection newValues = (Collection)notification.getNewValue();
        CatalogListener.ifIsContainement(notification, new Runnable(){

            @Override
            public void run() {
                for (Object newValuesItem : newValues) {
                    CatalogListenerFactory.adapt(newValuesItem, CatalogListener.this.getResource());
                }
            }
        });
    }

    private void notifyChangedForAdd(Notification notification) {
        final Object newValue = notification.getNewValue();
        CatalogListener.ifIsContainement(notification, new Runnable(){

            @Override
            public void run() {
                CatalogListenerFactory.adapt(newValue, CatalogListener.this.getResource());
            }
        });
    }

    protected Resource getResource() {
        return this.resource;
    }

    private static void ifIsContainement(Notification notification, Runnable runnable) {
        Object feature = notification.getFeature();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            runnable.run();
        }
    }

    public Notifier getTarget() {
        return this.target;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget instanceof EObject) {
            this.target = (EObject)newTarget;
            this.propagate(newTarget);
        }
    }

    private void propagate(Notifier newTarget) {
        if (newTarget instanceof EObject) {
            EObject eObject = (EObject)newTarget;
            for (EObject subEObject : eObject.eContents()) {
                CatalogListenerFactory.adaptResource((Notifier)subEObject, this.resource);
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return EObject.class.isInstance(type);
    }
}

