/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.swt.internal.imageprovider;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.facet.util.core.DebugUtils;
import org.eclipse.modisco.facet.util.swt.imageprovider.IImageProvider;
import org.eclipse.modisco.facet.util.swt.internal.Activator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ImageProvider
implements IImageProvider {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private final Map<Object, Image> map = new HashMap<Object, Image>();
    private final Plugin activator;

    ImageProvider(Plugin activator) {
        if (activator == null) {
            throw new IllegalArgumentException("The parameter 'activator' must no be null");
        }
        this.activator = activator;
    }

    @Override
    public ImageDescriptor createImageDescriptor(String resourcePath) {
        ImageDescriptor result;
        Bundle bundle = this.activator.getBundle();
        URL url = bundle.getResource(resourcePath);
        if (url == null) {
            String message = NLS.bind((String)"Resource not found: {0}", (Object)resourcePath);
            Logger.logError((String)message, (Plugin)this.activator);
            result = ImageDescriptor.getMissingImageDescriptor();
        } else {
            result = ImageDescriptor.createFromURL((URL)url);
        }
        return result;
    }

    @Override
    public Image getImage(String path) {
        Image result = this.map.get(path);
        if (result == null) {
            result = this.createImageDescriptor(path).createImage();
            this.map.put(path, result);
            if (DEBUG) {
                Bundle bundle = this.activator.getBundle();
                String bundleId = bundle.getSymbolicName();
                String message = String.format("New image loaded: %s:%s", bundleId, path);
                DebugUtils.debug((String)message);
            }
        }
        return result;
    }

    @Override
    public Image getImage(ImageDescriptor imgDescriptor) {
        Image result = this.map.get(imgDescriptor);
        if (result == null) {
            result = imgDescriptor.createImage();
            this.map.put(imgDescriptor, result);
            if (DEBUG) {
                Bundle bundle = this.activator.getBundle();
                String bundleId = bundle.getSymbolicName();
                String message = String.format("New image loaded from an image descriptor (bundle=%s)", bundleId);
                DebugUtils.debug((String)message);
            }
        }
        return result;
    }
}

