/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.jsp.generation.files;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.jee.jsp.ComposedAttribute;
import org.eclipse.modisco.jee.jsp.JSPAction;
import org.eclipse.modisco.jee.jsp.JSPComment;
import org.eclipse.modisco.jee.jsp.JSPDeclaration;
import org.eclipse.modisco.jee.jsp.JSPDirective;
import org.eclipse.modisco.jee.jsp.JSPExpression;
import org.eclipse.modisco.jee.jsp.JSPScript;
import org.eclipse.modisco.jee.jsp.JSPScriptlet;
import org.eclipse.modisco.jee.jsp.JSPStdAction;
import org.eclipse.modisco.jee.jsp.JSPTagLib;
import org.eclipse.modisco.jee.jsp.JavaScript;
import org.eclipse.modisco.jee.jsp.Model;
import org.eclipse.modisco.jee.jsp.Page;
import org.eclipse.modisco.jee.jsp.generation.files.JspModel2JspTextUtils;
import org.eclipse.modisco.xml.Attribute;
import org.eclipse.modisco.xml.CDATA;
import org.eclipse.modisco.xml.Comment;
import org.eclipse.modisco.xml.DocumentTypeDeclaration;
import org.eclipse.modisco.xml.Element;
import org.eclipse.modisco.xml.Namespace;
import org.eclipse.modisco.xml.Node;
import org.eclipse.modisco.xml.ProcessingInstruction;
import org.eclipse.modisco.xml.Root;
import org.eclipse.modisco.xml.Text;

public class JspModel2JspTextSwitch
extends JspModel2JspTextUtils {
    protected final String absoluteOutputPath;

    public JspModel2JspTextSwitch(String absoluteOutputPath) {
        this.absoluteOutputPath = absoluteOutputPath;
    }

    protected void appendNameAndChildTexts(Element jspExpression) {
        StringBuilder sValue = new StringBuilder();
        sValue.append(jspExpression.getName());
        for (EObject eObject : jspExpression.getChildren()) {
            if (!(eObject instanceof Text)) continue;
            sValue.append(((Text)eObject).getName());
        }
        this.append(sValue.toString());
    }

    public Object caseComposedAttribute(ComposedAttribute jComposedAttribute) {
        this.append(jComposedAttribute.getName());
        this.append("=");
        this.appendNodes((List<? extends EObject>)jComposedAttribute.getChildren());
        return this;
    }

    public Object caseElement(Element object) {
        return super.caseElement(object);
    }

    public Object caseJSPAction(JSPAction jspAction) {
        String name = jspAction.getName();
        EList children = jspAction.getChildren();
        ArrayList<EObject> attributes = new ArrayList<EObject>();
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (EObject eObject : children) {
            if (eObject instanceof Attribute || eObject instanceof ComposedAttribute) {
                attributes.add(eObject);
                continue;
            }
            elements.add(eObject);
        }
        if (elements.size() > 0) {
            this.append("<");
            this.append(name);
            this.appendOptionalWrappedNodes(" ", attributes, " ", null);
            this.append(">\n");
            this.pushIndentation();
            this.appendNodes(elements);
            this.popIndentation();
            this.append("</");
            this.append(name);
            this.append(">\n");
        } else {
            this.append("<");
            this.append(name);
            this.appendOptionalWrappedNodes(" ", attributes, " ", null);
            this.append("/>\n");
        }
        this.append("\n");
        return this;
    }

    public Object caseJSPComment(JSPComment jspComment) {
        this.append(jspComment.getName());
        this.appendSoftNewLine();
        return this;
    }

    public Object caseJSPDeclaration(JSPDeclaration jspDeclaration) {
        this.append("<%! ");
        this.appendWrappedNodes(null, (List<? extends EObject>)jspDeclaration.getChildren(), " ", null);
        this.append(" %>");
        this.appendSoftNewLine();
        return this;
    }

    public Object caseJSPDirective(JSPDirective jspDirective) {
        this.append("<%@ ");
        this.append(jspDirective.getName());
        for (EObject eObject : jspDirective.getChildren()) {
            if (!(eObject instanceof ComposedAttribute) && !(eObject instanceof Attribute)) continue;
            this.appendWrappedNode(" ", eObject, null);
        }
        this.append("%>");
        this.appendSoftNewLine();
        return this;
    }

    public Object caseJSPExpression(JSPExpression jspExpression) {
        this.append("<%=");
        this.appendNameAndChildTexts((Element)jspExpression);
        this.append("%>");
        return this;
    }

    public Object caseJSPScript(JSPScript object) {
        return this.errorCase((EObject)object);
    }

    public Object caseJSPScriptlet(JSPScriptlet jspScriptlet) {
        this.append("<% ");
        this.appendNameAndChildTexts((Element)jspScriptlet);
        this.append(" %>");
        this.appendSoftNewLine();
        return this;
    }

    public Object caseJSPStdAction(JSPStdAction jspStdAction) {
        EList children = jspStdAction.getChildren();
        ArrayList<EObject> attributes = new ArrayList<EObject>();
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (EObject eObject : children) {
            if (eObject instanceof Attribute || eObject instanceof ComposedAttribute) {
                attributes.add(eObject);
                continue;
            }
            elements.add(eObject);
        }
        if (elements.size() > 0) {
            this.append("<");
            this.append(jspStdAction.getName());
            this.appendOptionalWrappedNodes(" ", attributes, " ", null);
            this.append(">\n");
            this.pushIndentation();
            this.appendNodes(elements);
            this.popIndentation();
            this.append("</");
            this.append(jspStdAction.getName());
            this.append(">\n");
        } else {
            this.append("<");
            this.append(jspStdAction.getName());
            this.appendOptionalWrappedNodes(" ", attributes, " ", null);
            this.append("/>\n");
        }
        this.append("\n");
        return this;
    }

    public Object caseJSPTagLib(JSPTagLib object) {
        return super.caseJSPTagLib(object);
    }

    public Object caseJavaScript(JavaScript jJavaScript) {
        String name = jJavaScript.getName();
        ArrayList<EObject> attributes = new ArrayList<EObject>();
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (EObject eObject : jJavaScript.getChildren()) {
            int attributesSize = attributes.size();
            if (eObject instanceof Attribute || eObject instanceof ComposedAttribute) {
                attributes.add(eObject);
            }
            if (attributes.size() > attributesSize) continue;
            elements.add(eObject);
        }
        this.append("<script");
        this.appendWrappedNodes(" ", attributes, " ", " ");
        this.append(jJavaScript.getName());
        this.append(">");
        for (EObject eObject : elements) {
            this.appendNode(eObject);
        }
        this.append("</script>\n");
        this.appendSoftNewLine();
        return this;
    }

    public Object caseModel(Model jModel) {
        this.appendNodes((List<? extends EObject>)jModel.getPages());
        return this;
    }

    public Object caseNode(Node jNode) {
        return this.errorCase((EObject)jNode);
    }

    public Object casePage(Page jPage) {
        String doctype;
        String name = jPage.getName();
        StringBuilder sFile = new StringBuilder();
        sFile.append(this.absoluteOutputPath);
        if (!name.startsWith("/") && !this.absoluteOutputPath.endsWith("/")) {
            sFile.append("/");
        }
        sFile.append(name);
        String fileKey = sFile.toString();
        this.pushFile();
        String xmlDeclaration = jPage.getXmlDeclaration();
        if (xmlDeclaration != null && xmlDeclaration.length() > 0) {
            this.append(xmlDeclaration);
            this.append("\n");
        }
        if ((doctype = jPage.getDoctype()) != null && doctype.length() > 0) {
            this.appendRaw(doctype);
            this.append("\n");
        }
        for (EObject eObject : jPage.getOwnedElements()) {
            this.appendNode(eObject);
            this.appendSoftNewLine();
        }
        this.popFile(fileKey);
        return this;
    }

    @Override
    public Object caseXmlAttribute(Attribute xmlAttribute) {
        this.append(xmlAttribute.getName());
        this.append("=\"");
        this.append(xmlAttribute.getValue());
        this.append("\"");
        return this;
    }

    @Override
    public Object caseXmlCDATA(CDATA object) {
        return super.caseXmlCDATA(object);
    }

    @Override
    public Object caseXmlComment(Comment xmlComment) {
        this.append(xmlComment.getName());
        return this;
    }

    @Override
    public Object caseXmlDocumentTypeDeclaration(DocumentTypeDeclaration object) {
        return super.caseXmlDocumentTypeDeclaration(object);
    }

    @Override
    public Object caseXmlElement(Element xmlElement) {
        String name = xmlElement.getName();
        ArrayList<EObject> attributes = new ArrayList<EObject>();
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (EObject eObject : xmlElement.getChildren()) {
            int attributesSize = attributes.size();
            if (eObject instanceof Attribute || eObject instanceof ComposedAttribute) {
                attributes.add(eObject);
            } else if (eObject instanceof JSPAction && ((JSPAction)eObject).isIsTagFragment()) {
                attributes.add(eObject);
            } else if (eObject instanceof JSPComment && ((JSPComment)eObject).isIsTagFragment()) {
                attributes.add(eObject);
            } else if (eObject instanceof JSPScript && ((JSPScript)eObject).isIsTagFragment()) {
                attributes.add(eObject);
            }
            if (attributes.size() > attributesSize) continue;
            elements.add(eObject);
        }
        this.append("<");
        this.append(name);
        this.appendOptionalWrappedNodes(" ", attributes, " ", null);
        if (elements.size() <= 0) {
            this.append("/");
        } else {
            this.append(">");
            this.appendSoftNewLine();
            this.pushIndentation();
            this.appendNodes(elements);
            this.popIndentation();
            this.appendSoftNewLine();
            this.append("</");
            this.append(name);
        }
        this.append(">");
        this.appendSoftNewLine();
        return this;
    }

    @Override
    public Object caseXmlNamespace(Namespace object) {
        return super.caseXmlNamespace(object);
    }

    @Override
    public Object caseXmlNode(Node object) {
        return super.caseXmlNode(object);
    }

    @Override
    public Object caseXmlProcessingInstruction(ProcessingInstruction object) {
        return super.caseXmlProcessingInstruction(object);
    }

    @Override
    public Object caseXmlRoot(Root object) {
        return super.caseXmlRoot(object);
    }

    @Override
    public Object caseXmlText(Text xmlText) {
        String name = xmlText.getName();
        if (!(name.equalsIgnoreCase("\n") || name.equalsIgnoreCase(" ") || name.equalsIgnoreCase("\t") || name.equalsIgnoreCase("\r"))) {
            this.appendRaw(name);
        }
        return this;
    }

    public Object defaultCase(EObject eObject) {
        System.err.println("Missing case" + eObject.eClass().getName());
        this.append("Missing case" + eObject.eClass().getName() + "\n");
        this.doChildren(eObject, true);
        return null;
    }

    public Object errorCase(EObject eObject) {
        System.err.println("Missing override case" + eObject.eClass().getName());
        this.append("Missing override case" + eObject.eClass().getName() + "\n");
        this.doChildren(eObject, true);
        return null;
    }
}

