/**
 *   Copyright (c) 2010, 2026 Mia-Software and others.
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v2.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v20.html
 *   
 *   Contributors:
 *   
 *       Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.modisco.jee.webapp.webapp25.impl;

import java.lang.String;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.modisco.jee.webapp.webapp25.DescriptionType;
import org.eclipse.modisco.jee.webapp.webapp25.InjectionTargetType;
import org.eclipse.modisco.jee.webapp.webapp25.JndiNameType;
import org.eclipse.modisco.jee.webapp.webapp25.PersistenceUnitRefType;
import org.eclipse.modisco.jee.webapp.webapp25.Webapp25Package;
import org.eclipse.modisco.jee.webapp.webapp25.XsdStringType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Persistence Unit Ref Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.modisco.jee.webapp.webapp25.impl.PersistenceUnitRefTypeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.webapp.webapp25.impl.PersistenceUnitRefTypeImpl#getPersistenceUnitRefName <em>Persistence Unit Ref Name</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.webapp.webapp25.impl.PersistenceUnitRefTypeImpl#getPersistenceUnitName <em>Persistence Unit Name</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.webapp.webapp25.impl.PersistenceUnitRefTypeImpl#getMappedName <em>Mapped Name</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.webapp.webapp25.impl.PersistenceUnitRefTypeImpl#getInjectionTarget <em>Injection Target</em>}</li>
 *   <li>{@link org.eclipse.modisco.jee.webapp.webapp25.impl.PersistenceUnitRefTypeImpl#getId <em>Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PersistenceUnitRefTypeImpl extends EObjectImpl implements PersistenceUnitRefType {
	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected EList<DescriptionType> description;

	/**
	 * The cached value of the '{@link #getPersistenceUnitRefName() <em>Persistence Unit Ref Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPersistenceUnitRefName()
	 * @generated
	 * @ordered
	 */
	protected JndiNameType persistenceUnitRefName;

	/**
	 * The cached value of the '{@link #getPersistenceUnitName() <em>Persistence Unit Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPersistenceUnitName()
	 * @generated
	 * @ordered
	 */
	protected org.eclipse.modisco.jee.webapp.webapp25.String persistenceUnitName;

	/**
	 * The cached value of the '{@link #getMappedName() <em>Mapped Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMappedName()
	 * @generated
	 * @ordered
	 */
	protected XsdStringType mappedName;

	/**
	 * The cached value of the '{@link #getInjectionTarget() <em>Injection Target</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInjectionTarget()
	 * @generated
	 * @ordered
	 */
	protected EList<InjectionTargetType> injectionTarget;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PersistenceUnitRefTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Webapp25Package.Literals.PERSISTENCE_UNIT_REF_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DescriptionType> getDescription() {
		if (description == null) {
			description = new EObjectContainmentEList<DescriptionType>(DescriptionType.class, this, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__DESCRIPTION);
		}
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JndiNameType getPersistenceUnitRefName() {
		return persistenceUnitRefName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPersistenceUnitRefName(JndiNameType newPersistenceUnitRefName, NotificationChain msgs) {
		JndiNameType oldPersistenceUnitRefName = persistenceUnitRefName;
		persistenceUnitRefName = newPersistenceUnitRefName;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME, oldPersistenceUnitRefName, newPersistenceUnitRefName);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPersistenceUnitRefName(JndiNameType newPersistenceUnitRefName) {
		if (newPersistenceUnitRefName != persistenceUnitRefName) {
			NotificationChain msgs = null;
			if (persistenceUnitRefName != null)
				msgs = ((InternalEObject)persistenceUnitRefName).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME, null, msgs);
			if (newPersistenceUnitRefName != null)
				msgs = ((InternalEObject)newPersistenceUnitRefName).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME, null, msgs);
			msgs = basicSetPersistenceUnitRefName(newPersistenceUnitRefName, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME, newPersistenceUnitRefName, newPersistenceUnitRefName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public org.eclipse.modisco.jee.webapp.webapp25.String getPersistenceUnitName() {
		return persistenceUnitName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPersistenceUnitName(org.eclipse.modisco.jee.webapp.webapp25.String newPersistenceUnitName, NotificationChain msgs) {
		org.eclipse.modisco.jee.webapp.webapp25.String oldPersistenceUnitName = persistenceUnitName;
		persistenceUnitName = newPersistenceUnitName;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME, oldPersistenceUnitName, newPersistenceUnitName);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPersistenceUnitName(org.eclipse.modisco.jee.webapp.webapp25.String newPersistenceUnitName) {
		if (newPersistenceUnitName != persistenceUnitName) {
			NotificationChain msgs = null;
			if (persistenceUnitName != null)
				msgs = ((InternalEObject)persistenceUnitName).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME, null, msgs);
			if (newPersistenceUnitName != null)
				msgs = ((InternalEObject)newPersistenceUnitName).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME, null, msgs);
			msgs = basicSetPersistenceUnitName(newPersistenceUnitName, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME, newPersistenceUnitName, newPersistenceUnitName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XsdStringType getMappedName() {
		return mappedName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMappedName(XsdStringType newMappedName, NotificationChain msgs) {
		XsdStringType oldMappedName = mappedName;
		mappedName = newMappedName;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME, oldMappedName, newMappedName);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMappedName(XsdStringType newMappedName) {
		if (newMappedName != mappedName) {
			NotificationChain msgs = null;
			if (mappedName != null)
				msgs = ((InternalEObject)mappedName).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME, null, msgs);
			if (newMappedName != null)
				msgs = ((InternalEObject)newMappedName).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME, null, msgs);
			msgs = basicSetMappedName(newMappedName, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME, newMappedName, newMappedName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<InjectionTargetType> getInjectionTarget() {
		if (injectionTarget == null) {
			injectionTarget = new EObjectContainmentEList<InjectionTargetType>(InjectionTargetType.class, this, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__INJECTION_TARGET);
		}
		return injectionTarget;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__DESCRIPTION:
				return ((InternalEList<?>)getDescription()).basicRemove(otherEnd, msgs);
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME:
				return basicSetPersistenceUnitRefName(null, msgs);
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME:
				return basicSetPersistenceUnitName(null, msgs);
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME:
				return basicSetMappedName(null, msgs);
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__INJECTION_TARGET:
				return ((InternalEList<?>)getInjectionTarget()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__DESCRIPTION:
				return getDescription();
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME:
				return getPersistenceUnitRefName();
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME:
				return getPersistenceUnitName();
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME:
				return getMappedName();
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__INJECTION_TARGET:
				return getInjectionTarget();
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__ID:
				return getId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__DESCRIPTION:
				getDescription().clear();
				getDescription().addAll((Collection<? extends DescriptionType>)newValue);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME:
				setPersistenceUnitRefName((JndiNameType)newValue);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME:
				setPersistenceUnitName((org.eclipse.modisco.jee.webapp.webapp25.String)newValue);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME:
				setMappedName((XsdStringType)newValue);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__INJECTION_TARGET:
				getInjectionTarget().clear();
				getInjectionTarget().addAll((Collection<? extends InjectionTargetType>)newValue);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__ID:
				setId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__DESCRIPTION:
				getDescription().clear();
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME:
				setPersistenceUnitRefName((JndiNameType)null);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME:
				setPersistenceUnitName((org.eclipse.modisco.jee.webapp.webapp25.String)null);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME:
				setMappedName((XsdStringType)null);
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__INJECTION_TARGET:
				getInjectionTarget().clear();
				return;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__ID:
				setId(ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__DESCRIPTION:
				return description != null && !description.isEmpty();
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_REF_NAME:
				return persistenceUnitRefName != null;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__PERSISTENCE_UNIT_NAME:
				return persistenceUnitName != null;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__MAPPED_NAME:
				return mappedName != null;
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__INJECTION_TARGET:
				return injectionTarget != null && !injectionTarget.isEmpty();
			case Webapp25Package.PERSISTENCE_UNIT_REF_TYPE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: "); //$NON-NLS-1$
		result.append(id);
		result.append(')');
		return result.toString();
	}

} //PersistenceUnitRefTypeImpl
