/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.debug.core.pathmapper.Messages;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

public class PathMapper
implements IXMLPreferencesStorable {
    private Map<VirtualPath, VirtualPath> remoteToLocalMap = new HashMap<VirtualPath, VirtualPath>();
    private Map<VirtualPath, VirtualPath> localToRemoteMap = new HashMap<VirtualPath, VirtualPath>();
    private Map<VirtualPath, PathEntry.Type> localToPathEntryType = new HashMap<VirtualPath, PathEntry.Type>();
    private Map<VirtualPath, Mapping.MappingSource> localToMappingSource = new HashMap<VirtualPath, Mapping.MappingSource>();

    /*
     * Unable to fully structure code
     */
    public synchronized void addEntry(String remoteFile, PathEntry entry, Mapping.MappingSource source) {
        remotePath = new VirtualPath(remoteFile);
        localPath = entry.getAbstractPath().clone();
        if (remotePath.getLastSegment().equalsIgnoreCase(localPath.getLastSegment())) ** GOTO lbl10
        return;
        while (remotePath.getLastSegment().equalsIgnoreCase(localPath.getLastSegment())) {
            remotePath.removeLastSegment();
            localPath.removeLastSegment();
lbl10:
            // 2 sources

            if (remotePath.getSegmentsCount() > 0 && localPath.getSegmentsCount() > 1) continue;
        }
        if (!remotePath.equals(localPath)) {
            this.remoteToLocalMap.put(remotePath, localPath);
            this.localToRemoteMap.put(localPath, remotePath);
            this.localToPathEntryType.put(localPath, entry.getType());
            this.localToMappingSource.put(localPath, source);
        }
    }

    public synchronized void addServerEntry(String remoteFile, PathEntry entry, Mapping.MappingSource source) {
        VirtualPath localPath = entry.getAbstractPath().clone();
        this.remoteToLocalMap.put(localPath, localPath);
        this.localToRemoteMap.put(localPath, localPath);
        this.localToPathEntryType.put(localPath, entry.getType());
        this.localToMappingSource.put(localPath, source);
    }

    public String getRemoteFile(String localFile) {
        VirtualPath path = this.getPath(this.localToRemoteMap, new VirtualPath(localFile));
        if (path != null) {
            return path.toString();
        }
        return null;
    }

    public VirtualPath getLocalPathMapping(VirtualPath remotePath) {
        return this.remoteToLocalMap.get(remotePath);
    }

    public PathEntry getLocalFile(String remoteFile) {
        VirtualPath path = this.getPath(this.remoteToLocalMap, new VirtualPath(remoteFile));
        if (path != null) {
            String localFile = path.toString();
            PathEntry.Type type = this.getPathType(path);
            if (type == PathEntry.Type.SERVER) {
                return null;
            }
            if (type == PathEntry.Type.WORKSPACE) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(localFile);
                if (resource != null) {
                    return new PathEntry(path, type, (Object)resource.getParent());
                }
            } else {
                File file = new File(localFile);
                if (file.exists()) {
                    if (type == PathEntry.Type.INCLUDE_FOLDER || type == PathEntry.Type.INCLUDE_VAR) {
                        return new PathEntry(path, type, null);
                    }
                    return new PathEntry(path, type, (Object)file.getParentFile());
                }
            }
        }
        return null;
    }

    public PathEntry getServerFile(String remoteFile) {
        VirtualPath tmp = new VirtualPath(remoteFile);
        for (VirtualPath path : this.remoteToLocalMap.keySet()) {
            if (this.localToPathEntryType.get(path) != PathEntry.Type.SERVER || !path.isPrefixOf(tmp)) continue;
            return new PathEntry(path, PathEntry.Type.SERVER, null);
        }
        return null;
    }

    protected VirtualPath getPath(Map<VirtualPath, VirtualPath> map, VirtualPath path) {
        path = path.clone();
        VirtualPath mapPath = null;
        LinkedList<String> strippedSegments = new LinkedList<String>();
        while (path.getSegmentsCount() > 0) {
            mapPath = map.get(path);
            if (mapPath != null) {
                mapPath = mapPath.clone();
                break;
            }
            strippedSegments.add(path.removeLastSegment());
        }
        if (mapPath == null && (mapPath = map.get(path)) != null) {
            mapPath = mapPath.clone();
        }
        if (mapPath != null) {
            ListIterator i = strippedSegments.listIterator(strippedSegments.size());
            while (i.hasPrevious()) {
                mapPath.addLastSegment((String)i.previous());
            }
        }
        return mapPath;
    }

    protected PathEntry.Type getPathType(VirtualPath path) {
        path = path.clone();
        while (path.getSegmentsCount() > 0) {
            PathEntry.Type type = this.localToPathEntryType.get(path);
            if (type != null) {
                return type;
            }
            path.removeLastSegment();
        }
        return this.localToPathEntryType.get(path);
    }

    public synchronized Mapping[] getMapping() {
        ArrayList<Mapping> l = new ArrayList<Mapping>(this.localToRemoteMap.size());
        for (VirtualPath localPath : this.localToRemoteMap.keySet()) {
            VirtualPath remotePath = this.localToRemoteMap.get(localPath);
            PathEntry.Type type = this.localToPathEntryType.get(localPath);
            Mapping.MappingSource source = this.localToMappingSource.get(localPath);
            l.add(new Mapping(localPath, remotePath, type, source));
        }
        return l.toArray(new Mapping[l.size()]);
    }

    public synchronized void setMapping(Mapping[] mappings) {
        this.remoteToLocalMap.clear();
        this.localToRemoteMap.clear();
        this.localToPathEntryType.clear();
        this.localToMappingSource.clear();
        Mapping[] mappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            this.localToRemoteMap.put(mapping.localPath, mapping.remotePath);
            this.remoteToLocalMap.put(mapping.remotePath, mapping.localPath);
            this.localToPathEntryType.put(mapping.localPath, mapping.type);
            this.localToMappingSource.put(mapping.localPath, mapping.source);
            ++n2;
        }
    }

    public synchronized void addMapping(Mapping mapping) {
        this.localToRemoteMap.put(mapping.localPath, mapping.remotePath);
        this.remoteToLocalMap.put(mapping.remotePath, mapping.localPath);
        this.localToPathEntryType.put(mapping.localPath, mapping.type);
        this.localToMappingSource.put(mapping.localPath, mapping.source);
    }

    public synchronized void removeMapping(Mapping mapping) {
        this.localToRemoteMap.remove(mapping.localPath);
        this.remoteToLocalMap.remove(mapping.remotePath);
        this.localToPathEntryType.remove(mapping.localPath);
        this.localToMappingSource.remove(mapping.localPath);
    }

    public synchronized void restoreFromMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        this.remoteToLocalMap.clear();
        this.localToRemoteMap.clear();
        this.localToPathEntryType.clear();
        this.localToMappingSource.clear();
        Iterator<String> i = map.keySet().iterator();
        while (i.hasNext()) {
            Map entryMap = (Map)map.get(i.next());
            String localStr = (String)entryMap.get("local");
            String remoteStr = (String)entryMap.get("remote");
            String typeStr = (String)entryMap.get("type");
            String sourceStr = (String)entryMap.get("source");
            if (localStr == null || remoteStr == null || typeStr == null) continue;
            PathEntry.Type type = PathEntry.Type.valueOf(typeStr);
            Mapping.MappingSource source = Mapping.MappingSource.UNKNOWN;
            if (sourceStr != null) {
                source = Mapping.MappingSource.valueOf(sourceStr);
            }
            VirtualPath local = new VirtualPath(localStr);
            VirtualPath remote = new VirtualPath(remoteStr);
            this.remoteToLocalMap.put(remote, local);
            this.localToRemoteMap.put(local, remote);
            this.localToPathEntryType.put(local, type);
            this.localToMappingSource.put(local, source);
        }
    }

    public synchronized Map<String, Object> storeToMap() {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        Iterator<VirtualPath> i = this.localToRemoteMap.keySet().iterator();
        int c = 1;
        while (i.hasNext()) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            VirtualPath local = i.next();
            VirtualPath remote = this.localToRemoteMap.get(local);
            PathEntry.Type type = this.localToPathEntryType.get(local);
            Mapping.MappingSource source = this.localToMappingSource.get(local);
            entry.put("local", local);
            entry.put("remote", remote);
            if (type != null) {
                entry.put("type", type.name());
            }
            if (source != null) {
                entry.put("source", source.name());
            }
            entries.put("item" + c++, entry);
        }
        return entries;
    }

    public static class Mapping
    implements Cloneable {
        public VirtualPath localPath;
        public VirtualPath remotePath;
        public PathEntry.Type type;
        public MappingSource source;

        public Mapping() {
        }

        public Mapping(VirtualPath localPath, VirtualPath remotePath, PathEntry.Type type, MappingSource source) {
            this.localPath = localPath;
            this.remotePath = remotePath;
            this.type = type;
            this.source = source;
        }

        public Mapping clone() {
            return new Mapping(this.localPath, this.remotePath, this.type, this.source);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mapping other = (Mapping)obj;
            if (this.localPath == null ? other.localPath != null : !this.localPath.equals(other.localPath)) {
                return false;
            }
            if (this.remotePath == null ? other.remotePath != null : !this.remotePath.equals(other.remotePath)) {
                return false;
            }
            if (this.source != other.source) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.localPath == null ? 0 : this.localPath.hashCode());
            result = 31 * result + (this.remotePath == null ? 0 : this.remotePath.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Mapping { ");
            buf.append(this.localPath).append(", ").append(this.remotePath).append(", ").append((Object)this.type).append(", ").append(this.source.name()).append(" }");
            return buf.toString();
        }

        public static enum MappingSource {
            UNKNOWN(Messages.PathMapper_MappingSource_Unknown_Name),
            ENVIRONMENT(Messages.PathMapper_MappingSource_Environment_Name),
            USER(Messages.PathMapper_MappingSource_User_Name);

            private String name;

            private MappingSource(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

