/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.qvtd.runtime.evaluation.AbstractConnection;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationInternal;

public abstract class AbstractIntervalInternal
implements Interval {
    protected final boolean debugBlocks = AbstractTransformer.BLOCKS.isActive();
    protected final boolean debugInvocations = AbstractTransformer.INVOCATIONS.isActive();
    protected final @NonNull InvocationManager invocationManager;
    protected final int intervalIndex;
    private @Nullable AbstractConnection headConnection = null;
    private @Nullable AbstractConnection tailConnection = null;
    private @NonNull List<@NonNull Connection> connections = new ArrayList<Connection>();
    private @Nullable AbstractInvocationInternal speculatableInvocations = null;
    private @Nullable AbstractInvocationInternal blockedInvocations = null;
    private @Nullable AbstractInvocationInternal waitingInvocations = null;

    public AbstractIntervalInternal(@NonNull InvocationManager invocationManager, int intervalIndex) {
        this.invocationManager = invocationManager;
        this.intervalIndex = intervalIndex;
        invocationManager.setInterval(this);
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitInterval(this);
    }

    @Override
    public @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
        Connection connection = modeFactory.createConnection(this, name, typeId, isStrict);
        this.connections.add(connection);
        return connection;
    }

    @Override
    @Deprecated
    public @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
        return this.createConnection(name, typeId, isStrict, ModeFactory.NON_INCREMENTAL);
    }

    @Override
    @Deprecated
    public @NonNull Connection.Incremental createIncrementalConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
        return (Connection.Incremental)this.createConnection(name, typeId, isStrict, ModeFactory.INCREMENTAL);
    }

    public synchronized void destroy(@NonNull Invocation invocation) {
        AbstractInvocationInternal prevInvocation;
        assert (invocation.getInterval() == this);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("destroy " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (this.speculatableInvocations != castInvocation);
        assert (this.blockedInvocations != castInvocation);
        if (this.waitingInvocations == castInvocation) {
            this.waitingInvocations = castInvocation.next;
            if (this.waitingInvocations == castInvocation) {
                this.waitingInvocations = null;
            }
        }
        if ((prevInvocation = castInvocation.prev) != castInvocation) {
            AbstractInvocationInternal nextInvocation;
            prevInvocation.next = nextInvocation = castInvocation.next;
            nextInvocation.prev = prevInvocation;
            castInvocation.next = castInvocation;
            castInvocation.prev = castInvocation;
        }
    }

    @Override
    public void diagnoseWorkLists(@NonNull StringBuilder s) {
        SlotState blockedBy;
        AbstractInvocationInternal blocked = this.blockedInvocations;
        while (blocked != null) {
            blockedBy = blocked.blockedBy;
            s.append("\n" + this.intervalIndex + ": " + blocked + "\n\tblocked by " + blockedBy);
            if (blockedBy != null) {
                blockedBy.debugUnblock();
            }
            if ((blocked = blocked.next) == this.blockedInvocations) break;
        }
        AbstractInvocationInternal speculatable = this.speculatableInvocations;
        while (speculatable != null) {
            blockedBy = speculatable.blockedBy;
            s.append("\n" + this.intervalIndex + ": " + speculatable + "\n\tspeculating " + blockedBy);
            speculatable = speculatable.next;
            if (speculatable == this.speculatableInvocations) break;
        }
        AbstractInvocationInternal waiting = this.waitingInvocations;
        while (waiting != null) {
            blockedBy = waiting.blockedBy;
            s.append("\n" + this.intervalIndex + ": " + waiting + "\n\twaiting for " + blockedBy);
            if (blockedBy != null) {
                blockedBy.debugUnblock();
            }
            if ((waiting = waiting.next) == this.waitingInvocations) break;
        }
        AbstractConnection connection = this.headConnection;
        while (connection != null) {
            s.append("\n" + this.intervalIndex + ": connection: " + connection);
            connection = connection.getNextConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() {
        while (true) {
            if (this.headConnection != null) {
                AbstractConnection nextConnection2;
                AbstractIntervalInternal abstractIntervalInternal = this;
                synchronized (abstractIntervalInternal) {
                    nextConnection2 = this.headConnection;
                    if (nextConnection2 != null) {
                        this.headConnection = nextConnection2.getNextConnection();
                        if (this.headConnection == null) {
                            this.tailConnection = null;
                        }
                        nextConnection2.resetQueued();
                    }
                }
                if (nextConnection2 == null) continue;
                nextConnection2.propagate();
                continue;
            }
            while (this.waitingInvocations != null) {
                AbstractInvocationInternal invocation = null;
                AbstractIntervalInternal abstractIntervalInternal = this;
                synchronized (abstractIntervalInternal) {
                    AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
                    if (waitingInvocations2 != null) {
                        invocation = waitingInvocations2;
                        this.waitingInvocations = waitingInvocations2.next;
                        if (this.waitingInvocations == invocation) {
                            this.waitingInvocations = null;
                        }
                        invocation.remove();
                    }
                }
                if (invocation == null) continue;
                if (this.debugInvocations) {
                    AbstractTransformer.INVOCATIONS.println("invoke " + invocation);
                }
                try {
                    boolean success = invocation.execute();
                    if (!this.debugInvocations) continue;
                    AbstractTransformer.INVOCATIONS.println(String.valueOf(success ? "done " : "fail-clean ") + invocation);
                }
                catch (InvocationFailedException e) {
                    this.queueAsBlockedOrSpeculatable(invocation, e);
                }
                catch (Exception e) {
                    if (this.debugInvocations) {
                        AbstractTransformer.INVOCATIONS.println("fail-dirty " + invocation);
                    }
                    throw e;
                }
            }
            if (this.headConnection == null && this.speculatableInvocations != null) {
                AbstractInvocationInternal speculatableInvocation = null;
                AbstractIntervalInternal e = this;
                synchronized (e) {
                    AbstractInvocationInternal speculatableInvocations2 = this.speculatableInvocations;
                    if (speculatableInvocations2 != null) {
                        speculatableInvocation = speculatableInvocations2;
                        this.speculatableInvocations = speculatableInvocations2.next;
                        if (this.speculatableInvocations == speculatableInvocation) {
                            this.speculatableInvocations = null;
                        }
                        speculatableInvocation.remove();
                    }
                }
                if (speculatableInvocation != null) {
                    if (this.debugInvocations) {
                        AbstractTransformer.INVOCATIONS.println("speculate " + speculatableInvocation);
                    }
                    SlotState.Speculating blockedBy = (SlotState.Speculating)speculatableInvocation.blockedBy;
                    assert (blockedBy != null);
                    if (this.speculate(blockedBy)) assert (this.waitingInvocations != null);
                }
            }
            if (this.headConnection == null && this.waitingInvocations == null && this.speculatableInvocations == null) break;
        }
        AbstractInvocationInternal blockedInvocation = this.blockedInvocations;
        if (blockedInvocation == null) {
            return true;
        }
        do {
            if (!this.debugBlocks) continue;
            AbstractTransformer.BLOCKS.println("still blocked " + blockedInvocation + " by " + blockedInvocation.blockedBy);
        } while ((blockedInvocation = blockedInvocation.next) != this.blockedInvocations && blockedInvocation != this.speculatableInvocations);
        return false;
    }

    @Override
    public @NonNull Iterable<@NonNull Connection> getConnections() {
        return this.connections;
    }

    @Override
    public int getIndex() {
        return this.intervalIndex;
    }

    @Override
    public @NonNull InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    @Override
    public @NonNull String getName() {
        return String.valueOf(this.intervalIndex);
    }

    @Override
    public boolean isFlushed() {
        if (this.tailConnection != null) {
            return false;
        }
        if (this.blockedInvocations != null) {
            return false;
        }
        if (this.speculatableInvocations != null) {
            return false;
        }
        return this.waitingInvocations == null;
    }

    public void queue() {
        this.invocationManager.setWorkToDoAt(this.intervalIndex);
    }

    @Override
    public synchronized void queue(@NonNull Connection connection) {
        AbstractConnection connection2 = (AbstractConnection)connection;
        AbstractConnection tailConnection2 = this.tailConnection;
        if (tailConnection2 == null) {
            assert (this.headConnection == null);
            assert (connection2.getNextConnection() == null);
            this.headConnection = connection2;
        } else {
            assert (this.headConnection != null);
            if (connection2.getNextConnection() != null) {
                return;
            }
            tailConnection2.setNextConnection(connection2);
        }
        this.tailConnection = connection2;
        this.queue();
    }

    @Override
    public synchronized void queue(@NonNull Invocation invocation) {
        assert (invocation.getInterval() == this);
        if (this.debugBlocks) {
            AbstractTransformer.BLOCKS.println("queue " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.blockedBy == null);
        assert (this.speculatableInvocations != castInvocation);
        assert (this.blockedInvocations != castInvocation);
        AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
        if (waitingInvocations2 == null) {
            this.waitingInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(waitingInvocations2.prev);
        }
        this.queue();
    }

    private synchronized void queueAsBlockedOrSpeculatable(@NonNull Invocation invocation, @NonNull InvocationFailedException e) {
        SlotState slotState = e.slotState;
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.blockedBy == null);
        assert (castInvocation.next == castInvocation);
        assert (castInvocation.prev == castInvocation);
        assert (this.speculatableInvocations != castInvocation);
        assert (this.blockedInvocations != castInvocation);
        assert (this.waitingInvocations != castInvocation);
        castInvocation.blockedBy = slotState;
        if (e.isSpeculation) {
            AbstractInvocationInternal speculatableInvocations2 = this.speculatableInvocations;
            if (speculatableInvocations2 == null) {
                this.speculatableInvocations = castInvocation;
            } else {
                castInvocation.insertAfter(speculatableInvocations2.prev);
            }
            slotState.block(invocation);
            if (this.debugInvocations) {
                AbstractTransformer.BLOCKS.println("block-speculate " + invocation + " for " + slotState);
            }
        } else {
            AbstractInvocationInternal blockedInvocations2 = this.blockedInvocations;
            if (blockedInvocations2 == null) {
                this.blockedInvocations = castInvocation;
            } else {
                castInvocation.insertAfter(blockedInvocations2.prev);
            }
            slotState.block(invocation);
            if (this.debugInvocations) {
                AbstractTransformer.BLOCKS.println("block-not-ready " + invocation + " for " + slotState);
            }
        }
    }

    public boolean speculate(@NonNull SlotState.Speculating aSpeculatable) {
        HashSet<@NonNull SlotState.Speculating> inputSpeculatablesClosure = new HashSet<SlotState.Speculating>();
        Boolean status = this.speculate(aSpeculatable, inputSpeculatablesClosure);
        if (status != null) {
            if (status == Boolean.FALSE) {
                aSpeculatable.setSpeculated(false);
            } else {
                aSpeculatable.setSpeculated(true);
            }
            return status;
        }
        for (SlotState.Speculating speculatable : inputSpeculatablesClosure) {
            speculatable.setSpeculated(true);
        }
        return true;
    }

    private @Nullable Boolean speculate(@NonNull SlotState.Speculating aSpeculatable, @NonNull Set<@NonNull SlotState.Speculating> inputSpeculatablesClosure) {
        Boolean status = aSpeculatable.getSpeculationStatus();
        if (status != null) {
            return status;
        }
        if (!inputSpeculatablesClosure.add(aSpeculatable)) {
            return null;
        }
        Iterable<@NonNull SlotState.Speculating> inputs = aSpeculatable.getInputs();
        if (Iterables.isEmpty(inputs)) {
            return null;
        }
        boolean alreadySuccessful = true;
        for (SlotState.Speculating inputSpeculatable : inputs) {
            Boolean inputStatus = this.speculate(inputSpeculatable, inputSpeculatablesClosure);
            if (inputStatus == Boolean.TRUE) continue;
            if (inputStatus == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            alreadySuccessful = false;
        }
        return alreadySuccessful ? Boolean.TRUE : null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("<");
        s.append(this.intervalIndex);
        s.append("> ");
        int i = 0;
        AbstractConnection aConnection = this.headConnection;
        while (aConnection != null) {
            ++i;
            if (++i >= 100) {
                s.append(">=");
                break;
            }
            aConnection = aConnection.getNextConnection();
        }
        s.append(i);
        s.append(" connections, ");
        int k = 0;
        AbstractInvocationInternal waitingInvocation = this.waitingInvocations;
        if (waitingInvocation != null) {
            ++k;
            while ((waitingInvocation = waitingInvocation.next) != this.waitingInvocations) {
                if (++k < 100) continue;
                s.append(">=");
                break;
            }
        }
        s.append(k);
        s.append(" waiting, ");
        int m = 0;
        AbstractInvocationInternal unspeculatedInvocation = this.speculatableInvocations;
        if (unspeculatedInvocation != null) {
            ++m;
            while ((unspeculatedInvocation = unspeculatedInvocation.next) != this.speculatableInvocations) {
                if (++m < 100) continue;
                s.append(">=");
                break;
            }
        }
        s.append(m);
        s.append(" speculatable, ");
        int j = 0;
        AbstractInvocationInternal blockedInvocation = this.blockedInvocations;
        if (blockedInvocation != null) {
            ++j;
            while ((blockedInvocation = blockedInvocation.next) != this.blockedInvocations) {
                if (++j < 100) continue;
                s.append(">=");
                break;
            }
        }
        s.append(j);
        s.append(" blocked");
        return s.toString();
    }

    @Override
    public synchronized void unblock(@NonNull Invocation invocation) {
        if (this.debugInvocations) {
            AbstractTransformer.BLOCKS.println("unblock " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.blockedBy != null);
        castInvocation.blockedBy = null;
        if (this.blockedInvocations == castInvocation) {
            this.blockedInvocations = castInvocation.next;
            if (this.blockedInvocations == castInvocation) {
                this.blockedInvocations = null;
            }
        } else if (this.speculatableInvocations == castInvocation) {
            this.speculatableInvocations = castInvocation.next;
            if (this.speculatableInvocations == castInvocation) {
                this.speculatableInvocations = null;
            }
        }
        castInvocation.remove();
        AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
        if (waitingInvocations2 == null) {
            this.waitingInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(waitingInvocations2.prev);
        }
        this.queue();
    }
}

