/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.migration.description;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.common.tools.api.interpreter.StandardServices;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemContainerDropTool;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.description.TreeItemDragTool;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.osgi.framework.Version;

public class InitializeCreationToolElementsToSelectExpressionParticipant
extends AbstractVSMMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("10.1.0.201507271600");
    public static final String ELEMENTS_TO_SELECT_EXPRESSION = "service:stdEmptyCollection";
    private static final String JAVA_EXTENSION_QUALIFIED_NAME = StandardServices.class.getName();

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(Group group, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            EList ownedViewpoints = group.getOwnedViewpoints();
            for (Viewpoint viewpoint : ownedViewpoints) {
                boolean atLeastOneChange = false;
                for (TreeDescription treeDescription : Iterables.filter((Iterable)viewpoint.getOwnedRepresentations(), TreeDescription.class)) {
                    UnmodifiableIterator creationTools = Iterators.filter((Iterator)treeDescription.eAllContents(), (Predicate)Predicates.or((Predicate)Predicates.or((Predicate)Predicates.instanceOf(TreeItemContainerDropTool.class), (Predicate)Predicates.instanceOf(TreeItemDragTool.class)), (Predicate)Predicates.instanceOf(TreeItemCreationTool.class)));
                    while (creationTools.hasNext()) {
                        AbstractToolDescription tool = (AbstractToolDescription)creationTools.next();
                        if (!StringUtil.isEmpty((String)tool.getElementsToSelect())) continue;
                        tool.setElementsToSelect(ELEMENTS_TO_SELECT_EXPRESSION);
                        atLeastOneChange = true;
                    }
                }
                if (!atLeastOneChange || Iterables.any((Iterable)viewpoint.getOwnedJavaExtensions(), (Predicate)new Predicate<JavaExtension>(){

                    public boolean apply(JavaExtension input) {
                        return JAVA_EXTENSION_QUALIFIED_NAME.equals(input.getQualifiedClassName());
                    }
                })) continue;
                JavaExtension javaExtension = DescriptionFactory.eINSTANCE.createJavaExtension();
                javaExtension.setQualifiedClassName(JAVA_EXTENSION_QUALIFIED_NAME);
                viewpoint.getOwnedJavaExtensions().add((Object)javaExtension);
            }
        }
    }
}

