/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.uml2.uml.ConnectionPointReference;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

public class VertexOperations
extends NamedElementOperations {
    protected VertexOperations() {
    }

    public static StateMachine containingStateMachine(Vertex vertex) {
        State state;
        Region container = vertex.getContainer();
        if (container != null) {
            return container.containingStateMachine();
        }
        if (vertex instanceof Pseudostate) {
            Pseudostate pseudostate = (Pseudostate)vertex;
            PseudostateKind kind = pseudostate.getKind();
            if (kind == PseudostateKind.ENTRY_POINT_LITERAL || kind == PseudostateKind.EXIT_POINT_LITERAL) {
                return pseudostate.getStateMachine();
            }
        } else if (vertex instanceof ConnectionPointReference && (state = ((ConnectionPointReference)vertex).getState()) != null) {
            return state.containingStateMachine();
        }
        return null;
    }

    public static EList<Transition> getIncomings(Vertex vertex) {
        UniqueEList.FastCompare incomings = new UniqueEList.FastCompare();
        for (EStructuralFeature.Setting setting : VertexOperations.getNonNavigableInverseReferences((EObject)vertex)) {
            if (setting.getEStructuralFeature() != UMLPackage.Literals.TRANSITION__TARGET) continue;
            incomings.add((Object)((Transition)setting.getEObject()));
        }
        return new IncomingEList((InternalEObject)vertex, (EStructuralFeature)UMLPackage.Literals.VERTEX__INCOMING, (EList<Transition>)incomings);
    }

    public static EList<Transition> getOutgoings(Vertex vertex) {
        UniqueEList.FastCompare outgoings = new UniqueEList.FastCompare();
        for (EStructuralFeature.Setting setting : VertexOperations.getNonNavigableInverseReferences((EObject)vertex)) {
            if (setting.getEStructuralFeature() != UMLPackage.Literals.TRANSITION__SOURCE) continue;
            outgoings.add((Object)((Transition)setting.getEObject()));
        }
        return new OutgoingEList((InternalEObject)vertex, (EStructuralFeature)UMLPackage.Literals.VERTEX__OUTGOING, (EList<Transition>)outgoings);
    }

    public static boolean isContainedInState(Vertex vertex, State s) {
        Region container = vertex.getContainer();
        if (!s.isComposite() || container == null) {
            return false;
        }
        State containerState = container.getState();
        return containerState == s || containerState != null && containerState.isContainedInState(s);
    }

    public static boolean isContainedInRegion(Vertex vertex, Region r) {
        Region container = vertex.getContainer();
        if (container == r) {
            return true;
        }
        if (r.getState() == null) {
            return false;
        }
        State containerState = container.getState();
        return containerState != null && containerState.isContainedInRegion(r);
    }

    protected static class IncomingEList
    extends DelegatingEcoreEList<Transition> {
        private static final long serialVersionUID = 1L;
        protected final EStructuralFeature eStructuralFeature;
        protected final EList<Transition> delegateList;

        protected IncomingEList(InternalEObject owner, EStructuralFeature eStructuralFeature, EList<Transition> delegateList) {
            super(owner);
            this.eStructuralFeature = eStructuralFeature;
            this.delegateList = delegateList;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public int getFeatureID() {
            return this.owner.eDerivedStructuralFeatureID(this.eStructuralFeature.getFeatureID(), Vertex.class);
        }

        protected List<Transition> delegateList() {
            return this.delegateList;
        }

        protected void delegateAdd(int index, Transition transition) {
            int delegateIndex = this.delegateList.indexOf((Object)transition);
            if (delegateIndex != -1) {
                if (index != delegateIndex) {
                    this.delegateList.move(index, (Object)transition);
                }
            } else if (index < this.delegateList.size()) {
                this.delegateList.add(index, (Object)transition);
            } else {
                this.delegateList.add((Object)transition);
            }
        }

        protected void didAdd(int index, Transition newTransition) {
            super.didAdd(index, (Object)newTransition);
            newTransition.setTarget((Vertex)this.owner);
        }

        protected void didRemove(int index, Transition oldTransition) {
            super.didRemove(index, (Object)oldTransition);
            oldTransition.setTarget(null);
        }

        protected void didSet(int index, Transition newTransition, Transition oldTransition) {
            super.didSet(index, (Object)newTransition, (Object)oldTransition);
            newTransition.setTarget((Vertex)this.owner);
            oldTransition.setTarget(null);
        }
    }

    protected static class OutgoingEList
    extends DelegatingEcoreEList<Transition> {
        private static final long serialVersionUID = 1L;
        protected final EStructuralFeature eStructuralFeature;
        protected final EList<Transition> delegateList;

        protected OutgoingEList(InternalEObject owner, EStructuralFeature eStructuralFeature, EList<Transition> delegateList) {
            super(owner);
            this.eStructuralFeature = eStructuralFeature;
            this.delegateList = delegateList;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public int getFeatureID() {
            return this.owner.eDerivedStructuralFeatureID(this.eStructuralFeature.getFeatureID(), Vertex.class);
        }

        protected List<Transition> delegateList() {
            return this.delegateList;
        }

        protected void delegateAdd(int index, Transition transition) {
            int delegateIndex = this.delegateList.indexOf((Object)transition);
            if (delegateIndex != -1) {
                if (index != delegateIndex) {
                    this.delegateList.move(index, (Object)transition);
                }
            } else if (index < this.delegateList.size()) {
                this.delegateList.add(index, (Object)transition);
            } else {
                this.delegateList.add((Object)transition);
            }
        }

        protected void didAdd(int index, Transition newTransition) {
            super.didAdd(index, (Object)newTransition);
            newTransition.setSource((Vertex)this.owner);
        }

        protected void didRemove(int index, Transition oldTransition) {
            super.didRemove(index, (Object)oldTransition);
            oldTransition.setSource(null);
        }

        protected void didSet(int index, Transition newTransition, Transition oldTransition) {
            super.didSet(index, (Object)newTransition, (Object)oldTransition);
            newTransition.setSource((Vertex)this.owner);
            oldTransition.setSource(null);
        }
    }
}

