/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.i18n.server.GwtLocaleFactoryImpl;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleUtils {
    private static final GwtLocaleFactoryImpl factory = new GwtLocaleFactoryImpl();
    private static final Object cacheLock = new Object[0];
    private static Map<CacheKey, LocaleUtils> cache;
    private static final String PROP_LOCALE = "locale";
    private static final String PROP_RUNTIME_LOCALES = "runtime.locales";
    private final Set<GwtLocale> allCompileLocales;
    private final Set<GwtLocale> allLocales;
    private final GwtLocale compileLocale;
    private final Set<GwtLocale> runtimeLocales;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clear() {
        factory.clear();
        Object object = cacheLock;
        synchronized (object) {
            cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleUtils getInstance(TreeLogger logger, PropertyOracle propertyOracle) {
        try {
            SelectionProperty localeProp = propertyOracle.getSelectionProperty(logger, PROP_LOCALE);
            ConfigurationProperty runtimeLocaleProp = propertyOracle.getConfigurationProperty(PROP_RUNTIME_LOCALES);
            CacheKey key = new CacheKey(localeProp, runtimeLocaleProp);
            Object object = cacheLock;
            synchronized (object) {
                LocaleUtils localeUtils;
                if (cache == null) {
                    cache = new HashMap<CacheKey, LocaleUtils>();
                }
                if ((localeUtils = cache.get(key)) == null) {
                    localeUtils = LocaleUtils.createInstance(logger, localeProp, runtimeLocaleProp);
                    cache.put(key, localeUtils);
                }
                return localeUtils;
            }
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.WARN, "Unable to get locale properties, using defaults", (Throwable)e);
            GwtLocale defaultLocale = factory.fromString("default");
            HashSet<GwtLocale> allLocales = new HashSet<GwtLocale>();
            allLocales.add(defaultLocale);
            return new LocaleUtils(defaultLocale, allLocales, allLocales, Collections.<GwtLocale>emptySet());
        }
    }

    public static synchronized GwtLocaleFactory getLocaleFactory() {
        return factory;
    }

    private static LocaleUtils createInstance(TreeLogger logger, SelectionProperty localeProp, ConfigurationProperty prop) {
        GwtLocale newCompileLocale;
        GwtLocale compileLocale = null;
        HashSet<GwtLocale> allLocales = new HashSet<GwtLocale>();
        HashSet<GwtLocale> allCompileLocales = new HashSet<GwtLocale>();
        HashSet<GwtLocale> runtimeLocales = new HashSet<GwtLocale>();
        String localeName = localeProp.getCurrentValue();
        SortedSet localeValues = localeProp.getPossibleValues();
        GwtLocaleFactory factoryInstance = LocaleUtils.getLocaleFactory();
        compileLocale = newCompileLocale = factoryInstance.fromString(localeName);
        for (String localeValue : localeValues) {
            allCompileLocales.add(factoryInstance.fromString(localeValue));
        }
        allLocales.addAll(allCompileLocales);
        List rtLocaleNames = prop.getValues();
        if (rtLocaleNames != null) {
            for (String rtLocale : rtLocaleNames) {
                GwtLocale locale = factoryInstance.fromString(rtLocale);
                block2: for (GwtLocale existing : allCompileLocales) {
                    for (GwtLocale alias : existing.getAliases()) {
                        if (alias.isDefault() || !locale.inheritsFrom(alias) || !locale.usesSameScript(alias)) continue;
                        allLocales.add(locale);
                        break block2;
                    }
                }
                if (compileLocale.isDefault() || !locale.inheritsFrom(compileLocale) || !locale.usesSameScript(compileLocale)) continue;
                runtimeLocales.add(locale);
            }
        }
        return new LocaleUtils(compileLocale, allLocales, allCompileLocales, runtimeLocales);
    }

    private LocaleUtils(GwtLocale compileLocale, Set<GwtLocale> allLocales, Set<GwtLocale> allCompileLocales, Set<GwtLocale> runtimeLocales) {
        this.compileLocale = compileLocale;
        this.allLocales = Collections.unmodifiableSet(allLocales);
        this.allCompileLocales = Collections.unmodifiableSet(allCompileLocales);
        this.runtimeLocales = Collections.unmodifiableSet(runtimeLocales);
    }

    public Set<GwtLocale> getAllCompileLocales() {
        return this.allCompileLocales;
    }

    public Set<GwtLocale> getAllLocales() {
        return this.allLocales;
    }

    public GwtLocale getCompileLocale() {
        return this.compileLocale;
    }

    public Set<GwtLocale> getRuntimeLocales() {
        return this.runtimeLocales;
    }

    private static class CacheKey {
        private final SelectionProperty localeProperty;
        private final ConfigurationProperty runtimeLocaleProperty;

        public CacheKey(SelectionProperty localeProperty, ConfigurationProperty runtimeLocaleProperty) {
            this.localeProperty = localeProperty;
            this.runtimeLocaleProperty = runtimeLocaleProperty;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.localeProperty.equals(other.localeProperty) && this.runtimeLocaleProperty.equals(other.runtimeLocaleProperty);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.localeProperty.hashCode();
            result = 31 * result + this.runtimeLocaleProperty.hashCode();
            return result;
        }
    }
}

