/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.rebind.AbstractLocalizableInterfaceCreator;
import com.google.gwt.i18n.rebind.MessageFormatParser;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesInterfaceCreator
extends AbstractLocalizableInterfaceCreator {
    private static Set<Integer> numberOfMessageArgs(String template) throws ParseException {
        HashSet<Integer> seenArgs = new HashSet<Integer>();
        for (MessageFormatParser.TemplateChunk chunk : MessageFormatParser.parse(template)) {
            if (!(chunk instanceof MessageFormatParser.ArgumentChunk)) continue;
            seenArgs.add(((MessageFormatParser.ArgumentChunk)chunk).getArgumentNumber());
        }
        return seenArgs;
    }

    public MessagesInterfaceCreator(String className, String packageName, File resourceBundle, File targetLocation) throws IOException {
        super(className, packageName, resourceBundle, targetLocation, Messages.class);
    }

    @Override
    protected void genMethodArgs(String defaultValue) {
        try {
            Set<Integer> seenArgs = MessagesInterfaceCreator.numberOfMessageArgs(defaultValue);
            int maxArgSeen = -1;
            for (int arg : seenArgs) {
                if (arg <= maxArgSeen) continue;
                maxArgSeen = arg;
            }
            for (int i = 0; i <= maxArgSeen; ++i) {
                if (i > 0) {
                    this.composer.print(",  ");
                }
                if (!seenArgs.contains(i)) {
                    this.composer.print("@Optional ");
                }
                this.composer.print("String arg" + i);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(defaultValue + " could not be parsed as a MessageFormat string.", e);
        }
    }

    @Override
    protected void genValueAnnotation(String defaultValue) {
        this.composer.println("@DefaultMessage(" + this.makeJavaString(defaultValue) + ")");
    }

    @Override
    protected String javaDocComment(String path) {
        return "Interface to represent the messages contained in resource bundle:\n\t" + path + "'.";
    }
}

