/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.RunStyle;

class RunStyleManual
extends RunStyle {
    private int numClients;

    public RunStyleManual(JUnitShell shell) {
        super(shell);
    }

    public int initialize(String args) {
        this.numClients = 1;
        if (args != null) {
            try {
                this.numClients = Integer.parseInt(args);
            }
            catch (NumberFormatException e) {
                this.getLogger().log(TreeLogger.ERROR, "Error parsing argument \"" + args + "\"", (Throwable)e);
                return -1;
            }
        }
        return this.numClients;
    }

    public void launchModule(String moduleName) throws UnableToCompleteException {
        if (this.numClients == 1) {
            System.out.println("Please navigate your browser to this URL:");
        } else {
            System.out.println("Please navigate " + this.numClients + " browsers to this URL:");
        }
        System.out.println(this.shell.getModuleUrl(moduleName));
    }
}

