/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.remote;

import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

class BrowserManagerProcess {
    private static final Logger logger = Logger.getLogger(BrowserManagerProcess.class.getName());
    private boolean deadOrDying = false;
    private KillTask killTask;
    private final Process process;
    private final Timer timer;
    private final int token;

    private static String getElapsed(long intervalMs) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        return nf.format((double)intervalMs / 1000.0);
    }

    public BrowserManagerProcess(final ProcessExitCb cb, Timer timer, final int token, final Process process, long initKeepAliveMs) {
        this.process = process;
        this.timer = timer;
        this.token = token;
        final long startTime = System.currentTimeMillis();
        Thread cleanupThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        int exitValue = process.waitFor();
                        BrowserManagerProcess.this.doCleanup(cb, exitValue, token, System.currentTimeMillis() - startTime);
                        return;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Interrupted waiting for process exit of: " + token, e);
                        continue;
                    }
                    break;
                }
            }
        };
        cleanupThread.setDaemon(true);
        cleanupThread.setName("Browser-" + token + "-Wait");
        cleanupThread.start();
        this.keepAlive(initKeepAliveMs);
    }

    public synchronized boolean keepAlive(long keepAliveMs) {
        assert (keepAliveMs > 0L);
        if (!this.deadOrDying) {
            this.killTask = new KillTask();
            this.timer.schedule((TimerTask)this.killTask, keepAliveMs);
            return true;
        }
        return false;
    }

    public synchronized void killBrowser() {
        if (!this.deadOrDying) {
            this.process.destroy();
            this.deadOrDying = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup(ProcessExitCb cb, int exitValue, int token, long intervalMs) {
        BrowserManagerProcess browserManagerProcess = this;
        synchronized (browserManagerProcess) {
            this.deadOrDying = true;
        }
        if (exitValue != 0) {
            logger.warning("Browser: " + token + " exited with bad status: " + exitValue);
        } else {
            logger.info("Browser: " + token + " process exited normally after " + BrowserManagerProcess.getElapsed(intervalMs) + "s");
        }
        cb.childExited(token, exitValue);
    }

    private final class KillTask
    extends TimerTask {
        private KillTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BrowserManagerProcess browserManagerProcess = BrowserManagerProcess.this;
            synchronized (browserManagerProcess) {
                if (BrowserManagerProcess.this.killTask == this && !BrowserManagerProcess.this.deadOrDying) {
                    logger.info("Timeout expired for: " + BrowserManagerProcess.this.token);
                    BrowserManagerProcess.this.process.destroy();
                    BrowserManagerProcess.this.deadOrDying = true;
                }
            }
        }
    }

    public static interface ProcessExitCb {
        public void childExited(int var1, int var2);
    }
}

