/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.rebind;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.impl.ArtificialRescue;
import com.google.gwt.core.client.impl.Impl;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.javac.TypeOracleMediator;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.rpc.client.impl.CommandToStringWriter;
import com.google.gwt.rpc.client.impl.RpcServiceProxy;
import com.google.gwt.rpc.client.impl.TypeOverrides;
import com.google.gwt.rpc.linker.RpcDataArtifact;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.RemoteServiceProxy;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.rpc.CustomFieldSerializerValidator;
import com.google.gwt.user.rebind.rpc.ProxyCreator;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracle;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracleBuilder;
import com.google.gwt.user.rebind.rpc.SerializationUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcProxyCreator
extends ProxyCreator {
    private String typeOverrideName;

    public RpcProxyCreator(JClassType type) {
        super(type);
    }

    @Override
    protected String computeTypeNameExpression(JType paramType) {
        if (paramType.isClass() != null) {
            return "GWT.isScript() ? Impl.getNameOf(\"@" + paramType.getQualifiedSourceName() + "\") : \"" + TypeOracleMediator.computeBinaryClassName((JType)paramType) + "\"";
        }
        return "\" " + TypeOracleMediator.computeBinaryClassName((JType)paramType) + "\"";
    }

    @Override
    protected void generateProxyContructor(SourceWriter srcWriter) {
        srcWriter.println("public " + this.getProxySimpleName() + "() {");
        srcWriter.indent();
        srcWriter.println("super(GWT.getModuleBaseURL(),");
        srcWriter.indent();
        srcWriter.println(this.getRemoteServiceRelativePath() + ",");
        srcWriter.println("OVERRIDES);");
        srcWriter.outdent();
        srcWriter.outdent();
        srcWriter.println("}");
    }

    @Override
    protected void generateProxyFields(SourceWriter srcWriter, SerializableTypeOracle serializableTypeOracle, String serializationPolicyStrongName, String remoteServiceInterfaceName) {
        srcWriter.println("private static final String REMOTE_SERVICE_INTERFACE_NAME = \"" + remoteServiceInterfaceName + "\";");
        srcWriter.println("private static final " + TypeOverrides.class.getName() + " OVERRIDES = GWT.isScript() ? " + this.typeOverrideName + ".create() : null;");
        srcWriter.println();
    }

    @Override
    protected void generateStreamWriterOverride(SourceWriter srcWriter) {
    }

    @Override
    protected void generateTypeHandlers(TreeLogger logger, GeneratorContext ctx, SerializableTypeOracle serializationSto, SerializableTypeOracle deserializationSto) throws UnableToCompleteException {
        String simpleName = this.serviceIntf.getSimpleSourceName() + "_TypeOverridesFactory";
        PrintWriter out = ctx.tryCreate(logger, this.serviceIntf.getPackage().getName(), simpleName);
        if (out == null) {
            return;
        }
        TypeOracle typeOracle = ctx.getTypeOracle();
        JClassType objectType = typeOracle.getJavaLangObject();
        HashSet<JType> classLiterals = new HashSet<JType>();
        HashMap<JType, JMethod> serializerMethods = new HashMap<JType, JMethod>();
        HashMap fields = new HashMap();
        StringBuilder sb = this.writeArtificialRescues(typeOracle, serializationSto, deserializationSto);
        ClassSourceFileComposerFactory composerFactory = new ClassSourceFileComposerFactory(this.serviceIntf.getPackage().getName(), simpleName);
        composerFactory.addImport(ArtificialRescue.class.getCanonicalName());
        composerFactory.addImport(GWT.class.getCanonicalName());
        composerFactory.addImport(Impl.class.getCanonicalName());
        composerFactory.addImport(ArtificialRescue.Rescue.class.getCanonicalName());
        composerFactory.addImport(TypeOverrides.class.getCanonicalName());
        composerFactory.addImport(TypeOverrides.SerializeFunction.class.getCanonicalName());
        composerFactory.addAnnotationDeclaration(sb.toString());
        SourceWriter sw = composerFactory.createSourceWriter(ctx, out);
        sw.println("public static TypeOverrides create() {");
        sw.indent();
        sw.println("TypeOverrides toReturn = TypeOverrides.create();");
        for (JType type : serializationSto.getSerializableTypes()) {
            JClassType classType = type.isClass();
            if (classType == null) continue;
            boolean allFieldsAreSerializable = true;
            ArrayList<String> fieldRefs = new ArrayList<String>();
            JMethod serializerMethod = null;
            do {
                JClassType customSerializer;
                JMethod jMethod = serializerMethod = (customSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(typeOracle, (JType)classType)) == null ? null : CustomFieldSerializerValidator.getSerializationMethod(customSerializer, type.isClass());
                if (serializerMethod != null) break;
                JField[] serializableFields = SerializationUtils.getSerializableFields(typeOracle, classType);
                allFieldsAreSerializable &= serializableFields.length == classType.getFields().length;
                for (JField field : serializableFields) {
                    fieldRefs.add("@" + field.getEnclosingType().getQualifiedSourceName() + "::" + field.getName());
                }
            } while ((classType = classType.getSuperclass()) != objectType);
            if (allFieldsAreSerializable && serializerMethod == null || serializerMethod == null && fieldRefs.isEmpty()) continue;
            classLiterals.add(type);
            String mangledTypeName = type.getQualifiedSourceName().replace('.', '_');
            sw.println("toReturn.set(class_" + mangledTypeName + "().getName()");
            if (serializerMethod != null) {
                serializerMethods.put(type, serializerMethod);
                sw.indentln(",serializer_" + mangledTypeName + "()");
            }
            if (fieldRefs.isEmpty()) {
                sw.indentln(");");
                continue;
            }
            fields.put(type, fieldRefs);
            sw.indentln(",fields_" + mangledTypeName + "());");
        }
        sw.println("return toReturn;");
        sw.outdent();
        sw.println("}");
        for (JType jType : classLiterals) {
            sw.println("public static native Class class_" + jType.getQualifiedSourceName().replace('.', '_') + "() /*-{");
            sw.indentln("return @" + jType.getQualifiedSourceName() + "::class;");
            sw.println("}-*/;");
            sw.println();
        }
        for (Map.Entry entry : serializerMethods.entrySet()) {
            sw.println("public static native " + TypeOverrides.SerializeFunction.class.getSimpleName() + " serializer_" + ((JType)entry.getKey()).getQualifiedSourceName().replace('.', '_') + "() /*-{");
            sw.indentln("return " + ((JMethod)entry.getValue()).getJsniSignature() + ";");
            sw.println("}-*/;");
            sw.println();
        }
        for (Map.Entry entry : fields.entrySet()) {
            sw.println("public static String[] fields_" + ((JType)entry.getKey()).getQualifiedSourceName().replace('.', '_') + "() {");
            sw.print("return new String[] {");
            for (String fieldRef : (List)entry.getValue()) {
                sw.print("Impl.getNameOf(\"" + fieldRef + "\"),");
            }
            sw.println("};");
            sw.println("}");
            sw.println();
        }
        sw.commit(logger);
        this.typeOverrideName = composerFactory.getCreatedClassName();
    }

    @Override
    protected Class<? extends RemoteServiceProxy> getProxySupertype() {
        return RpcServiceProxy.class;
    }

    @Override
    protected Class<? extends SerializationStreamWriter> getStreamWriterClass() {
        return CommandToStringWriter.class;
    }

    @Override
    protected String writeSerializationPolicyFile(TreeLogger logger, GeneratorContext ctx, SerializableTypeOracle serializationSto, SerializableTypeOracle deserializationSto) throws UnableToCompleteException {
        RpcDataArtifact data = new RpcDataArtifact(this.serviceIntf.getQualifiedSourceName());
        for (JType type : deserializationSto.getSerializableTypes()) {
            if (!(type instanceof JClassType)) continue;
            JField[] serializableFields = SerializationUtils.getSerializableFields(ctx.getTypeOracle(), (JClassType)type);
            List names = Lists.create();
            int j = serializableFields.length;
            for (int i = 0; i < j; ++i) {
                names = Lists.add((List)names, (Object)serializableFields[i].getName());
            }
            data.setFields(TypeOracleMediator.computeBinaryClassName((JType)type), names);
        }
        ctx.commitArtifact(logger, (Artifact)data);
        return "unused";
    }

    private StringBuilder writeArtificialRescues(TypeOracle typeOracle, SerializableTypeOracle serializationSto, SerializableTypeOracle deserializationSto) {
        HashSet<JType> serializableTypes = new HashSet<JType>();
        Collections.addAll(serializableTypes, serializationSto.getSerializableTypes());
        Collections.addAll(serializableTypes, deserializationSto.getSerializableTypes());
        for (JMethod m : this.serviceIntf.getOverridableMethods()) {
            JPrimitiveType mustBox = m.getReturnType().isPrimitive();
            if (mustBox == null) continue;
            serializableTypes.add(m.getReturnType());
        }
        StringBuilder sb = new StringBuilder("@ArtificialRescue({");
        for (JType serializableType : serializableTypes) {
            JArrayType serializableArray = serializableType.isArray();
            JClassType serializableClass = serializableType.isClass();
            JPrimitiveType serializablePrimitive = serializableType.isPrimitive();
            if (serializableArray != null) {
                sb.append("\n@Rescue(className = \"");
                if (serializableArray.getLeafType() instanceof JPrimitiveType) {
                    sb.append(serializableArray.getLeafType().getJNISignature());
                    int j = serializableArray.getRank();
                    for (int i = 0; i < j; ++i) {
                        sb.append("[]");
                    }
                } else {
                    sb.append(serializableArray.getQualifiedSourceName());
                }
                sb.append("\",\n instantiable = true),");
                continue;
            }
            if (serializableClass != null) {
                this.writeSingleRescue(typeOracle, deserializationSto, sb, serializableClass);
                continue;
            }
            if (serializablePrimitive == null) continue;
            JClassType boxedClass = typeOracle.findType(serializablePrimitive.getQualifiedBoxedSourceName());
            assert (boxedClass != null) : "No boxed version of " + serializablePrimitive.getQualifiedSourceName();
            this.writeSingleRescue(typeOracle, deserializationSto, sb, boxedClass);
        }
        sb.append("})");
        return sb;
    }

    private void writeSingleRescue(TypeOracle typeOracle, SerializableTypeOracle deserializationOracle, StringBuilder sb, JClassType serializableClass) {
        boolean rescueConstructor;
        JClassType customSerializer;
        boolean shouldDeserialize = deserializationOracle.isSerializable((JType)serializableClass);
        JMethod deserialize = null;
        JMethod instantiate = null;
        boolean hybridSerialization = false;
        JClassType search = serializableClass;
        do {
            if ((customSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(typeOracle, (JType)search)) == null) continue;
            instantiate = CustomFieldSerializerValidator.getInstantiationMethod(customSerializer, search);
            deserialize = CustomFieldSerializerValidator.getDeserializationMethod(customSerializer, search);
            hybridSerialization = search != serializableClass;
            break;
        } while ((search = search.getSuperclass()) != null);
        JEnumType enumType = serializableClass.isEnum();
        JField[] serializableFields = enumType != null ? enumType.getFields() : SerializationUtils.getSerializableFields(typeOracle, serializableClass);
        boolean bl = rescueConstructor = instantiate == null && deserialize != null;
        if (shouldDeserialize || rescueConstructor || customSerializer == null && serializableFields.length > 0) {
            sb.append("\n@Rescue(className = \"").append(serializableClass.getQualifiedSourceName()).append("\"");
            sb.append(",\n instantiable = ").append(shouldDeserialize);
            sb.append(",\n fields = {");
            if (customSerializer == null || hybridSerialization) {
                for (JField field : serializableFields) {
                    sb.append("\"").append(field.getName()).append("\",");
                }
            }
            sb.append("},\n methods = {");
            if (rescueConstructor) {
                sb.append("\"").append(serializableClass.getName().replace('.', '$')).append("()\"");
            }
            sb.append("}),");
        }
        if (customSerializer != null) {
            String jsniSignature;
            sb.append("\n@Rescue(className = \"").append(customSerializer.getQualifiedSourceName()).append("\",\n methods = {");
            if (instantiate != null) {
                jsniSignature = instantiate.getJsniSignature();
                sb.append("\"").append(jsniSignature.substring(jsniSignature.lastIndexOf(58) + 1)).append("\",");
            }
            if (deserialize != null) {
                jsniSignature = deserialize.getJsniSignature();
                sb.append("\"").append(jsniSignature.substring(jsniSignature.lastIndexOf(58) + 1)).append("\",");
            }
            sb.append("}),");
        }
    }
}

