/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.FieldReferenceConverter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;

class StringAttributeParser
implements AttributeParser {
    private final FieldReferenceConverter converter;
    private final JType type;

    StringAttributeParser(FieldReferenceConverter converter, JType stringType) {
        this.converter = converter;
        this.type = stringType;
    }

    public String parse(String value) {
        return this.converter.convert(value, new FieldReferenceDelegate(this.type));
    }

    static class FieldReferenceDelegate
    implements FieldReferenceConverter.Delegate {
        private final JType type;

        FieldReferenceDelegate(JType type) {
            this.type = type;
        }

        public JType getType() {
            return this.type;
        }

        public String handleFragment(String literal) {
            return "\"" + UiBinderWriter.escapeTextForJavaStringLiteral(literal) + "\"";
        }

        public String handleReference(String reference) {
            return String.format(" + %s + ", reference);
        }
    }
}

