/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.rebind.CssResourceWriter;
import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.PrintWriterManager;
import com.google.gwt.uibinder.rebind.model.ImplicitClientBundle;
import com.google.gwt.uibinder.rebind.model.ImplicitCssResource;
import com.google.gwt.uibinder.rebind.model.ImplicitDataResource;
import com.google.gwt.uibinder.rebind.model.ImplicitImageResource;
import java.util.Collection;
import java.util.Set;

public class BundleWriter {
    private final ImplicitClientBundle bundleClass;
    private final IndentedWriter writer;
    private final PrintWriterManager writerManager;
    private final TypeOracle types;
    private final MortalLogger logger;
    private final JClassType clientBundleType;
    private final JClassType dataResourceType;
    private final JClassType imageOptionType;
    private final JClassType imageResourceType;
    private final JClassType repeatStyleType;
    private final JClassType importAnnotationType;

    public BundleWriter(ImplicitClientBundle bundleClass, PrintWriterManager writerManager, TypeOracle types, MortalLogger logger) {
        this.bundleClass = bundleClass;
        this.writer = new IndentedWriter(writerManager.makePrintWriterFor(bundleClass.getClassName()));
        this.writerManager = writerManager;
        this.types = types;
        this.logger = logger;
        this.clientBundleType = types.findType(ClientBundle.class.getName());
        this.dataResourceType = types.findType(DataResource.class.getCanonicalName());
        this.imageOptionType = types.findType(ImageResource.ImageOptions.class.getCanonicalName());
        this.imageResourceType = types.findType(ImageResource.class.getCanonicalName());
        this.repeatStyleType = types.findType(ImageResource.RepeatStyle.class.getCanonicalName());
        this.importAnnotationType = types.findType(CssResource.Import.class.getCanonicalName());
    }

    public void write() throws UnableToCompleteException {
        this.writeBundleClass();
        for (ImplicitCssResource css : this.bundleClass.getCssMethods()) {
            new CssResourceWriter(css, this.types, this.writerManager.makePrintWriterFor(css.getClassName()), this.logger).write();
        }
    }

    private void writeBundleClass() {
        String packageName = this.bundleClass.getPackageName();
        if (packageName.length() > 0) {
            this.writer.write("package %1$s;", packageName);
            this.writer.newline();
        }
        this.writer.write("import %s;", this.clientBundleType.getQualifiedSourceName());
        this.writer.write("import %s;", this.dataResourceType.getQualifiedSourceName());
        this.writer.write("import %s;", this.imageResourceType.getQualifiedSourceName());
        this.writer.write("import %s;", this.imageOptionType.getQualifiedSourceName());
        this.writer.write("import %s;", this.importAnnotationType.getQualifiedSourceName());
        this.writer.newline();
        this.writer.write("public interface %s extends ClientBundle {", this.bundleClass.getClassName());
        this.writer.indent();
        for (ImplicitCssResource css : this.bundleClass.getCssMethods()) {
            this.writeCssSource(css);
            this.writeCssImports(css);
            this.writer.write("%s %s();", css.getClassName(), css.getName());
            this.writer.newline();
        }
        for (ImplicitDataResource data : this.bundleClass.getDataMethods()) {
            this.writer.write("@Source(\"%s\")", data.getSource());
            this.writer.write("%s %s();", this.dataResourceType.getName(), data.getName());
            this.writer.newline();
        }
        this.writeImageMethods();
        this.writer.outdent();
        this.writer.write("}");
    }

    private void writeCssImports(ImplicitCssResource css) {
        Set<JClassType> importTypes = css.getImports();
        int numImports = importTypes.size();
        if (numImports > 0) {
            if (numImports == 1) {
                this.writer.write("@Import(%s.class)", importTypes.iterator().next().getQualifiedSourceName());
            } else {
                StringBuffer b = new StringBuffer();
                for (JClassType importType : importTypes) {
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(importType.getQualifiedSourceName()).append(".class");
                }
                this.writer.write("@Import({%s})", b);
            }
        }
    }

    private void writeCssSource(ImplicitCssResource css) {
        Collection<String> sources = css.getSource();
        if (sources.size() == 1) {
            this.writer.write("@Source(\"%s\")", sources.iterator().next());
        } else {
            StringBuffer b = new StringBuffer();
            for (String s : sources) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append('\"').append(s).append('\"');
            }
            this.writer.write("@Source({%s})", b);
        }
    }

    private void writeImageMethods() {
        for (ImplicitImageResource image : this.bundleClass.getImageMethods()) {
            if (null != image.getSource()) {
                this.writer.write("@Source(\"%s\")", image.getSource());
            }
            this.writeImageOptionsAnnotation(image.getFlipRtl(), image.getRepeatStyle());
            this.writer.write("%s %s();", this.imageResourceType.getName(), image.getName());
        }
    }

    private void writeImageOptionsAnnotation(Boolean flipRtl, ImageResource.RepeatStyle repeatStyle) {
        if (flipRtl != null || repeatStyle != null) {
            StringBuilder b = new StringBuilder("@ImageOptions(");
            if (null != flipRtl) {
                b.append("flipRtl=").append(flipRtl);
                if (repeatStyle != null) {
                    b.append(", ");
                }
            }
            if (repeatStyle != null) {
                b.append(String.format("repeatStyle=%s.%s", this.repeatStyleType.getName(), repeatStyle.toString()));
            }
            b.append(")");
            this.writer.write(b.toString());
        }
    }
}

