/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.uibinder.rebind.BundleWriter;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.PrintWriterManager;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.W3cDomHelper;
import com.google.gwt.uibinder.rebind.messages.MessagesWriter;
import com.google.gwt.uibinder.rebind.model.ImplicitClientBundle;
import java.io.PrintWriter;
import java.net.URL;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class UiBinderGenerator
extends Generator {
    private static final String TEMPLATE_SUFFIX = ".ui.xml";
    static final String BINDER_URI = "urn:ui:com.google.gwt.uibinder";

    private static String deduceTemplateFile(MortalLogger logger, JClassType interfaceType) throws UnableToCompleteException {
        String unsuffixed;
        String templateName = null;
        UiTemplate annotation = (UiTemplate)interfaceType.getAnnotation(UiTemplate.class);
        if (annotation == null) {
            if (interfaceType.getEnclosingType() != null) {
                interfaceType = interfaceType.getEnclosingType();
            }
            return UiBinderGenerator.slashify(interfaceType.getQualifiedSourceName()) + TEMPLATE_SUFFIX;
        }
        templateName = annotation.value();
        if (!templateName.endsWith(TEMPLATE_SUFFIX)) {
            logger.die("Template file name must end with .ui.xml", new Object[0]);
        }
        templateName = !(unsuffixed = templateName.substring(0, templateName.lastIndexOf(TEMPLATE_SUFFIX))).contains(".") ? UiBinderGenerator.slashify(interfaceType.getPackage().getName()) + "/" + templateName : UiBinderGenerator.slashify(unsuffixed) + TEMPLATE_SUFFIX;
        return templateName;
    }

    private static String slashify(String s) {
        return s.replace(".", "/");
    }

    public String generate(TreeLogger logger, GeneratorContext genCtx, String fqInterfaceName) throws UnableToCompleteException {
        JClassType interfaceType;
        TypeOracle oracle = genCtx.getTypeOracle();
        try {
            interfaceType = oracle.getType(fqInterfaceName);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        String implName = interfaceType.getName().replace('.', '_') + "Impl";
        String packageName = interfaceType.getPackage().getName();
        PrintWriterManager writers = new PrintWriterManager(genCtx, logger, packageName);
        PrintWriter printWriter = writers.tryToMakePrintWriterFor(implName);
        if (printWriter != null) {
            this.generateOnce(interfaceType, implName, printWriter, logger, oracle, writers);
        }
        return packageName + "." + implName;
    }

    private void generateOnce(JClassType interfaceType, String implName, PrintWriter binderPrintWriter, TreeLogger treeLogger, TypeOracle oracle, PrintWriterManager writerManager) throws UnableToCompleteException {
        MortalLogger logger = new MortalLogger(treeLogger);
        String templatePath = UiBinderGenerator.deduceTemplateFile(logger, interfaceType);
        MessagesWriter messages = new MessagesWriter(BINDER_URI, logger, templatePath, interfaceType.getPackage().getName(), implName);
        UiBinderWriter uiBinderWriter = new UiBinderWriter(interfaceType, implName, templatePath, oracle, logger, new FieldManager(oracle, logger), messages);
        Document doc = this.getW3cDoc(logger, templatePath);
        uiBinderWriter.parseDocument(doc, binderPrintWriter);
        if (messages.hasMessages()) {
            messages.write(writerManager.makePrintWriterFor(messages.getMessagesClassName()));
        }
        ImplicitClientBundle bundleClass = uiBinderWriter.getBundleClass();
        new BundleWriter(bundleClass, writerManager, oracle, logger).write();
        writerManager.commit();
    }

    private Document getW3cDoc(MortalLogger logger, String templatePath) throws UnableToCompleteException {
        URL url = UiBinderGenerator.class.getClassLoader().getResource(templatePath);
        if (null == url) {
            logger.die("Unable to find resource: " + templatePath, new Object[0]);
        }
        Document doc = null;
        try {
            doc = new W3cDomHelper(logger.getTreeLogger()).documentFor(url);
        }
        catch (SAXParseException e) {
            logger.die("Error parsing XML (line " + e.getLineNumber() + "): " + e.getMessage(), e);
        }
        return doc;
    }
}

