/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.HyperlinkImpl;

public class Hyperlink
extends Widget
implements HasHTML,
SourcesClickEvents,
HasClickHandlers {
    private static HyperlinkImpl impl = (HyperlinkImpl)GWT.create(HyperlinkImpl.class);
    private final Element anchorElem = DOM.createAnchor();
    private String targetHistoryToken;

    public Hyperlink() {
        this(DOM.createDiv());
    }

    public Hyperlink(String text, boolean asHTML, String targetHistoryToken) {
        this();
        if (asHTML) {
            this.setHTML(text);
        } else {
            this.setText(text);
        }
        this.setTargetHistoryToken(targetHistoryToken);
    }

    public Hyperlink(String text, String targetHistoryToken) {
        this();
        this.setText(text);
        this.setTargetHistoryToken(targetHistoryToken);
    }

    protected Hyperlink(Element elem) {
        if (elem == null) {
            this.setElement(this.anchorElem);
        } else {
            this.setElement(elem);
            DOM.appendChild(this.getElement(), this.anchorElem);
        }
        this.sinkEvents(1);
        this.setStyleName("gwt-Hyperlink");
    }

    @Deprecated
    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addHandler(handler, ClickEvent.getType());
    }

    @Deprecated
    public void addClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.add(this, listener);
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.anchorElem);
    }

    public String getTargetHistoryToken() {
        return this.targetHistoryToken;
    }

    public String getText() {
        return DOM.getInnerText(this.anchorElem);
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        if (DOM.eventGetType(event) == 1 && impl.handleAsClick(event)) {
            History.newItem(this.getTargetHistoryToken());
            DOM.eventPreventDefault(event);
        }
    }

    @Deprecated
    public void removeClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.remove(this, listener);
    }

    public void setHTML(String html) {
        DOM.setInnerHTML(this.anchorElem, html);
    }

    public void setTargetHistoryToken(String targetHistoryToken) {
        assert (targetHistoryToken != null) : "targetHistoryToken must not be null, consider using Anchor instead";
        this.targetHistoryToken = targetHistoryToken;
        DOM.setElementProperty(this.anchorElem, "href", "#" + targetHistoryToken);
    }

    public void setText(String text) {
        DOM.setInnerText(this.anchorElem, text);
    }

    protected void onEnsureDebugId(String baseID) {
        Hyperlink.ensureDebugId(this.anchorElem, "", baseID);
        Hyperlink.ensureDebugId(this.getElement(), baseID, "wrapper");
    }
}

