/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.client.UnsafeNativeLong;
import com.google.gwt.core.client.impl.WeakMapping;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.javac.TypeOracleMediator;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.core.java.lang.Object_Array_CustomFieldSerializer;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracle;
import com.google.gwt.user.rebind.rpc.SerializationUtils;
import com.google.gwt.user.rebind.rpc.Shared;
import java.io.PrintWriter;

public class FieldSerializerCreator {
    private static final String WEAK_MAPPING_CLASS_NAME = WeakMapping.class.getName();
    private final JClassType serializableClass;
    private final JField[] serializableFields;
    private SourceWriter sourceWriter;
    private final SerializableTypeOracle typesSentFromBrowser;
    private final SerializableTypeOracle typesSentToBrowser;
    private final TypeOracle typeOracle;

    public FieldSerializerCreator(TypeOracle typeOracle, SerializableTypeOracle typesSentFromBrowser, SerializableTypeOracle typesSentToBrowser, JClassType requestedClass) {
        assert (requestedClass != null);
        assert (requestedClass.isClass() != null || requestedClass.isArray() != null);
        this.typeOracle = typeOracle;
        this.typesSentFromBrowser = typesSentFromBrowser;
        this.typesSentToBrowser = typesSentToBrowser;
        this.serializableClass = requestedClass;
        this.serializableFields = SerializationUtils.getSerializableFields(typeOracle, requestedClass);
    }

    public String realize(TreeLogger logger, GeneratorContext ctx) {
        assert (ctx != null);
        assert (this.typesSentFromBrowser.isSerializable((JType)this.serializableClass) || this.typesSentToBrowser.isSerializable((JType)this.serializableClass));
        logger = logger.branch(TreeLogger.DEBUG, "Generating a field serializer for type '" + this.serializableClass.getQualifiedSourceName() + "'", null);
        String fieldSerializerName = SerializationUtils.getFieldSerializerName(this.typeOracle, (JType)this.serializableClass);
        this.sourceWriter = this.getSourceWriter(logger, ctx);
        if (this.sourceWriter == null) {
            return fieldSerializerName;
        }
        assert (this.sourceWriter != null);
        this.writeFieldAccessors();
        this.writeDeserializeMethod();
        this.maybeWriteInstatiateMethod();
        this.writeSerializeMethod();
        this.sourceWriter.commit(logger);
        return fieldSerializerName;
    }

    private String createArrayInstantiationExpression(JArrayType array) {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(array.getLeafType().getQualifiedSourceName());
        sb.append("[rank]");
        for (int i = 0; i < array.getRank() - 1; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private int getDepth(JClassType clazz) {
        int depth = 0;
        while ((clazz = clazz.getSuperclass()) != null) {
            ++depth;
        }
        return depth;
    }

    private SourceWriter getSourceWriter(TreeLogger logger, GeneratorContext ctx) {
        String packageName;
        String className;
        String qualifiedSerializerName = SerializationUtils.getFieldSerializerName(this.typeOracle, (JType)this.serializableClass);
        int packageNameEnd = qualifiedSerializerName.lastIndexOf(46);
        if (packageNameEnd != -1) {
            className = qualifiedSerializerName.substring(packageNameEnd + 1);
            packageName = qualifiedSerializerName.substring(0, packageNameEnd);
        } else {
            className = qualifiedSerializerName;
            packageName = "";
        }
        PrintWriter printWriter = ctx.tryCreate(logger, packageName, className);
        if (printWriter == null) {
            return null;
        }
        ClassSourceFileComposerFactory composerFactory = new ClassSourceFileComposerFactory(packageName, className);
        composerFactory.addAnnotationDeclaration("@SuppressWarnings(\"deprecation\")");
        return composerFactory.createSourceWriter(ctx, printWriter);
    }

    private void maybeSuppressLongWarnings(JType fieldType) {
        if (fieldType == JPrimitiveType.LONG) {
            this.sourceWriter.println("@" + UnsafeNativeLong.class.getName());
        }
    }

    private void maybeWriteInstatiateMethod() {
        if (this.serializableClass.isEnum() == null && (this.serializableClass.isAbstract() || !this.serializableClass.isDefaultInstantiable())) {
            return;
        }
        JArrayType isArray = this.serializableClass.isArray();
        JEnumType isEnum = this.serializableClass.isEnum();
        boolean isNative = isArray == null && isEnum == null;
        this.sourceWriter.print("public static" + (isNative ? " native " : " "));
        String qualifiedSourceName = this.serializableClass.getQualifiedSourceName();
        this.sourceWriter.print(qualifiedSourceName);
        this.sourceWriter.print(" instantiate(");
        this.sourceWriter.print(SerializationStreamReader.class.getName());
        this.sourceWriter.println(" streamReader) throws " + SerializationException.class.getName() + (isNative ? "/*-{" : "{"));
        this.sourceWriter.indent();
        if (isArray != null) {
            this.sourceWriter.println("int rank = streamReader.readInt();");
            this.sourceWriter.println("return " + this.createArrayInstantiationExpression(isArray) + ";");
        } else if (isEnum != null) {
            this.sourceWriter.println("int ordinal = streamReader.readInt();");
            this.sourceWriter.println(qualifiedSourceName + "[] values = " + qualifiedSourceName + ".values();");
            this.sourceWriter.println("assert (ordinal >= 0 && ordinal < values.length);");
            this.sourceWriter.println("return values[ordinal];");
        } else {
            this.sourceWriter.println("return @" + qualifiedSourceName + "::new()();");
        }
        this.sourceWriter.outdent();
        this.sourceWriter.println(isNative ? "}-*/;" : "}");
        this.sourceWriter.println();
    }

    private boolean needsAccessorMethods(JField field) {
        return field.isPrivate();
    }

    private void writeArrayDeserializationStatements(JArrayType isArray) {
        JType componentType = isArray.getComponentType();
        String readMethodName = Shared.getStreamReadMethodNameFor(componentType);
        if ("readObject".equals(readMethodName)) {
            this.sourceWriter.println(Object_Array_CustomFieldSerializer.class.getName() + ".deserialize(streamReader, instance);");
        } else {
            this.sourceWriter.println("for (int i = 0, n = instance.length; i < n; ++i) {");
            this.sourceWriter.indent();
            this.sourceWriter.print("instance[i] = streamReader.");
            this.sourceWriter.println(readMethodName + "();");
            this.sourceWriter.outdent();
            this.sourceWriter.println("}");
        }
    }

    private void writeArraySerializationStatements(JArrayType isArray) {
        JType componentType = isArray.getComponentType();
        String writeMethodName = Shared.getStreamWriteMethodNameFor(componentType);
        if ("writeObject".equals(writeMethodName)) {
            this.sourceWriter.println(Object_Array_CustomFieldSerializer.class.getName() + ".serialize(streamWriter, instance);");
        } else {
            this.sourceWriter.println("streamWriter.writeInt(instance.length);");
            this.sourceWriter.println();
            this.sourceWriter.println("for (int i = 0, n = instance.length; i < n; ++i) {");
            this.sourceWriter.indent();
            this.sourceWriter.print("streamWriter.");
            this.sourceWriter.print(writeMethodName);
            this.sourceWriter.println("(instance[i]);");
            this.sourceWriter.outdent();
            this.sourceWriter.println("}");
        }
    }

    private void writeClassDeserializationStatements() {
        if (this.serializableClass.isEnhanced()) {
            this.sourceWriter.println(WEAK_MAPPING_CLASS_NAME + ".set(instance, " + "\"server-enhanced-data-" + this.getDepth(this.serializableClass) + "\", streamReader.readString());");
        }
        for (JField serializableField : this.serializableFields) {
            JType fieldType = serializableField.getType();
            String readMethodName = Shared.getStreamReadMethodNameFor(fieldType);
            String streamReadExpression = "streamReader." + readMethodName + "()";
            if (Shared.typeNeedsCast(fieldType)) {
                streamReadExpression = "(" + fieldType.getQualifiedSourceName() + ") " + streamReadExpression;
            }
            if (this.needsAccessorMethods(serializableField)) {
                this.sourceWriter.print("set");
                this.sourceWriter.print(Shared.capitalize(serializableField.getName()));
                this.sourceWriter.print("(instance, ");
                this.sourceWriter.print(streamReadExpression);
                this.sourceWriter.println(");");
                continue;
            }
            this.sourceWriter.print("instance.");
            this.sourceWriter.print(serializableField.getName());
            this.sourceWriter.print(" = ");
            this.sourceWriter.print(streamReadExpression);
            this.sourceWriter.println(";");
        }
        this.sourceWriter.println();
        JClassType superClass = this.serializableClass.getSuperclass();
        if (superClass != null && (this.typesSentFromBrowser.isSerializable((JType)superClass) || this.typesSentToBrowser.isSerializable((JType)superClass))) {
            String fieldSerializerName = SerializationUtils.getFieldSerializerName(this.typeOracle, (JType)superClass);
            this.sourceWriter.print(fieldSerializerName);
            this.sourceWriter.println(".deserialize(streamReader, instance);");
        }
    }

    private void writeClassSerializationStatements() {
        if (this.serializableClass.isEnhanced()) {
            this.sourceWriter.println("streamWriter.writeString((String) " + WEAK_MAPPING_CLASS_NAME + ".get(instance, \"server-enhanced-data-" + this.getDepth(this.serializableClass) + "\"));");
        }
        for (JField serializableField : this.serializableFields) {
            JType fieldType = serializableField.getType();
            String writeMethodName = Shared.getStreamWriteMethodNameFor(fieldType);
            this.sourceWriter.print("streamWriter.");
            this.sourceWriter.print(writeMethodName);
            this.sourceWriter.print("(");
            if (this.needsAccessorMethods(serializableField)) {
                this.sourceWriter.print("get");
                this.sourceWriter.print(Shared.capitalize(serializableField.getName()));
                this.sourceWriter.println("(instance));");
                continue;
            }
            this.sourceWriter.print("instance.");
            this.sourceWriter.print(serializableField.getName());
            this.sourceWriter.println(");");
        }
        this.sourceWriter.println();
        JClassType superClass = this.serializableClass.getSuperclass();
        if (superClass != null && (this.typesSentFromBrowser.isSerializable((JType)superClass) || this.typesSentToBrowser.isSerializable((JType)superClass))) {
            String fieldSerializerName = SerializationUtils.getFieldSerializerName(this.typeOracle, (JType)superClass);
            this.sourceWriter.print(fieldSerializerName);
            this.sourceWriter.println(".serialize(streamWriter, instance);");
        }
    }

    private void writeDeserializeMethod() {
        this.sourceWriter.print("public static void deserialize(");
        this.sourceWriter.print(SerializationStreamReader.class.getName());
        this.sourceWriter.print(" streamReader, ");
        this.sourceWriter.print(this.serializableClass.getQualifiedSourceName());
        this.sourceWriter.println(" instance) throws " + SerializationException.class.getName() + "{");
        this.sourceWriter.indent();
        JArrayType isArray = this.serializableClass.isArray();
        if (isArray != null) {
            this.writeArrayDeserializationStatements(isArray);
        } else if (this.serializableClass.isEnum() != null) {
            this.writeEnumDeserializationStatements();
        } else {
            this.writeClassDeserializationStatements();
        }
        this.sourceWriter.outdent();
        this.sourceWriter.println("}");
        this.sourceWriter.println();
    }

    private void writeEnumDeserializationStatements() {
        this.sourceWriter.println("// Enum deserialization is handled via the instantiate method");
    }

    private void writeEnumSerializationStatements() {
        this.sourceWriter.println("assert (instance != null);");
        this.sourceWriter.println("streamWriter.writeInt(instance.ordinal());");
    }

    private void writeFieldAccessors() {
        for (JField serializableField : this.serializableFields) {
            if (!this.needsAccessorMethods(serializableField)) continue;
            this.writeFieldGet(serializableField);
            this.writeFieldSet(serializableField);
        }
    }

    private void writeFieldGet(JField serializableField) {
        JType fieldType = serializableField.getType();
        String fieldTypeQualifiedSourceName = fieldType.getQualifiedSourceName();
        String fieldName = serializableField.getName();
        this.maybeSuppressLongWarnings(fieldType);
        this.sourceWriter.print("private static native ");
        this.sourceWriter.print(fieldTypeQualifiedSourceName);
        this.sourceWriter.print(" get");
        this.sourceWriter.print(Shared.capitalize(fieldName));
        this.sourceWriter.print("(");
        this.sourceWriter.print(this.serializableClass.getQualifiedSourceName());
        this.sourceWriter.println(" instance) /*-{");
        this.sourceWriter.indent();
        this.sourceWriter.print("return instance.@");
        this.sourceWriter.print(TypeOracleMediator.computeBinaryClassName((JType)this.serializableClass));
        this.sourceWriter.print("::");
        this.sourceWriter.print(fieldName);
        this.sourceWriter.println(";");
        this.sourceWriter.outdent();
        this.sourceWriter.println("}-*/;");
        this.sourceWriter.println();
    }

    private void writeFieldSet(JField serializableField) {
        JType fieldType = serializableField.getType();
        String fieldTypeQualifiedSourceName = fieldType.getQualifiedSourceName();
        String serializableClassQualifedName = this.serializableClass.getQualifiedSourceName();
        String fieldName = serializableField.getName();
        this.maybeSuppressLongWarnings(fieldType);
        this.sourceWriter.print("private static native void ");
        this.sourceWriter.print(" set");
        this.sourceWriter.print(Shared.capitalize(fieldName));
        this.sourceWriter.print("(");
        this.sourceWriter.print(serializableClassQualifedName);
        this.sourceWriter.print(" instance, ");
        this.sourceWriter.print(fieldTypeQualifiedSourceName);
        this.sourceWriter.println(" value) /*-{");
        this.sourceWriter.indent();
        this.sourceWriter.print("instance.@");
        this.sourceWriter.print(TypeOracleMediator.computeBinaryClassName((JType)this.serializableClass));
        this.sourceWriter.print("::");
        this.sourceWriter.print(fieldName);
        this.sourceWriter.println(" = value;");
        this.sourceWriter.outdent();
        this.sourceWriter.println("}-*/;");
        this.sourceWriter.println();
    }

    private void writeSerializeMethod() {
        this.sourceWriter.print("public static void serialize(");
        this.sourceWriter.print(SerializationStreamWriter.class.getName());
        this.sourceWriter.print(" streamWriter, ");
        this.sourceWriter.print(this.serializableClass.getQualifiedSourceName());
        this.sourceWriter.println(" instance) throws " + SerializationException.class.getName() + " {");
        this.sourceWriter.indent();
        JArrayType isArray = this.serializableClass.isArray();
        if (isArray != null) {
            this.writeArraySerializationStatements(isArray);
        } else if (this.serializableClass.isEnum() != null) {
            this.writeEnumSerializationStatements();
        } else {
            this.writeClassSerializationStatements();
        }
        this.sourceWriter.outdent();
        this.sourceWriter.println("}");
        this.sourceWriter.println();
    }
}

