/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteServiceAsyncValidator {
    private final JClassType asyncCallbackClass;
    private final JClassType requestBuilderType;
    private final JClassType requestType;

    static void logValidAsyncInterfaceDeclaration(TreeLogger logger, JClassType remoteService) {
        TreeLogger branch = logger.branch(TreeLogger.INFO, "A valid definition for the asynchronous version of interface '" + remoteService.getQualifiedSourceName() + "' would be:\n", null);
        branch.log(TreeLogger.ERROR, RemoteServiceAsyncValidator.synthesizeAsynchronousInterfaceDefinition(remoteService), null);
    }

    private static String computeAsyncMethodSignature(JMethod syncMethod, JClassType asyncCallbackClass) {
        return RemoteServiceAsyncValidator.computeInternalSignature(syncMethod) + "/" + asyncCallbackClass.getQualifiedSourceName();
    }

    private static String computeInternalSignature(JMethod method) {
        JParameter[] params;
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        sb.append(method.getName());
        for (JParameter param : params = method.getParameters()) {
            sb.append("/");
            JType paramType = param.getType();
            sb.append(paramType.getErasedType().getQualifiedSourceName());
        }
        return sb.toString();
    }

    private static Map<String, JMethod> initializeAsyncMethodMap(JMethod[] asyncMethods) {
        TreeMap<String, JMethod> sigs = new TreeMap<String, JMethod>();
        for (JMethod asyncMethod : asyncMethods) {
            sigs.put(RemoteServiceAsyncValidator.computeInternalSignature(asyncMethod), asyncMethod);
        }
        return sigs;
    }

    private static String synthesizeAsynchronousInterfaceDefinition(JClassType serviceIntf) {
        JMethod[] methods;
        StringBuffer sb = new StringBuffer();
        JPackage pkg = serviceIntf.getPackage();
        if (pkg != null) {
            sb.append("\npackage ");
            sb.append(pkg.getName());
            sb.append(";\n");
        }
        sb.append("\npublic interface ");
        sb.append(serviceIntf.getSimpleSourceName());
        sb.append("Async {\n");
        for (JMethod method : methods = serviceIntf.getOverridableMethods()) {
            assert (method != null);
            sb.append("\tvoid ");
            sb.append(method.getName());
            sb.append("(");
            JParameter[] params = method.getParameters();
            for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
                JParameter param = params[paramIndex];
                if (paramIndex > 0) {
                    sb.append(", ");
                }
                sb.append(param.toString());
            }
            if (params.length > 0) {
                sb.append(", ");
            }
            JType returnType = method.getReturnType();
            sb.append(AsyncCallback.class.getName());
            sb.append("<");
            if (returnType instanceof JPrimitiveType) {
                sb.append(((JPrimitiveType)returnType).getQualifiedBoxedSourceName());
            } else {
                sb.append(returnType.getParameterizedQualifiedSourceName());
            }
            sb.append("> arg");
            sb.append(Integer.toString(params.length + 1));
            sb.append(");\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static void validationFailed(TreeLogger branch, JClassType remoteService) throws UnableToCompleteException {
        RemoteServiceAsyncValidator.logValidAsyncInterfaceDeclaration(branch, remoteService);
        throw new UnableToCompleteException();
    }

    RemoteServiceAsyncValidator(TreeLogger logger, TypeOracle typeOracle) throws UnableToCompleteException {
        try {
            this.asyncCallbackClass = typeOracle.getType(AsyncCallback.class.getName());
            this.requestType = typeOracle.getType(Request.class.getCanonicalName());
            this.requestBuilderType = typeOracle.getType(RequestBuilder.class.getCanonicalName());
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, null, (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    public Map<JMethod, JMethod> validate(TreeLogger logger, JClassType remoteService, JClassType remoteServiceAsync) throws UnableToCompleteException {
        JMethod[] syncMethods;
        TreeLogger branch = logger.branch(TreeLogger.DEBUG, "Checking the synchronous interface '" + remoteService.getQualifiedSourceName() + "' against its asynchronous version '" + remoteServiceAsync.getQualifiedSourceName() + "'", null);
        JMethod[] asyncMethods = remoteServiceAsync.getOverridableMethods();
        if (asyncMethods.length != (syncMethods = remoteService.getOverridableMethods()).length) {
            branch.branch(TreeLogger.ERROR, "The asynchronous version of " + remoteService.getQualifiedSourceName() + " has " + (asyncMethods.length > syncMethods.length ? "more" : "less") + " methods than the synchronous version", null);
            RemoteServiceAsyncValidator.validationFailed(branch, remoteService);
        }
        boolean failed = false;
        Map<String, JMethod> asyncMethodMap = RemoteServiceAsyncValidator.initializeAsyncMethodMap(asyncMethods);
        HashMap<JMethod, JMethod> syncMethodToAsyncMethodMap = new HashMap<JMethod, JMethod>();
        for (JMethod syncMethod : syncMethods) {
            String asyncSig = RemoteServiceAsyncValidator.computeAsyncMethodSignature(syncMethod, this.asyncCallbackClass);
            JMethod asyncMethod = asyncMethodMap.get(asyncSig);
            if (asyncMethod == null) {
                branch.branch(TreeLogger.ERROR, "Missing asynchronous version of the synchronous method '" + syncMethod.getReadableDeclaration() + "'", null);
                failed = true;
                continue;
            }
            JType returnType = asyncMethod.getReturnType();
            if (returnType != JPrimitiveType.VOID && returnType != this.requestType && returnType != this.requestBuilderType) {
                branch.branch(TreeLogger.ERROR, "The asynchronous version of the synchronous method '" + syncMethod.getReadableDeclaration() + "' must have a return type of 'void' or '" + Request.class.getCanonicalName() + "' or '" + RequestBuilder.class.getCanonicalName() + "'", null);
                failed = true;
                continue;
            }
            syncMethodToAsyncMethodMap.put(syncMethod, asyncMethod);
        }
        if (failed) {
            RemoteServiceAsyncValidator.validationFailed(branch, remoteService);
        }
        branch.log(TreeLogger.DEBUG, "Interfaces are in sync");
        return syncMethodToAsyncMethodMap;
    }
}

