/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JRawType;
import com.google.gwt.core.ext.typeinfo.JRealClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JTypeParameter;
import com.google.gwt.core.ext.typeinfo.JWildcardType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.rpc.JModTypeVisitor;
import com.google.gwt.user.rebind.rpc.JTypeVisitor;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracleBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConstrainer {
    private int freshTypeVariableCounter;
    private final TypeOracle typeOracle;

    private static boolean baseTypesOverlap(JClassType type1, JClassType type2) {
        assert (type1 == TypeConstrainer.getBaseType(type1));
        assert (type2 == TypeConstrainer.getBaseType(type2));
        if (type1 == type2) {
            return true;
        }
        HashSet<JClassType> subtypes1 = new HashSet<JClassType>();
        subtypes1.add(type1);
        for (JClassType sub1 : type1.getSubtypes()) {
            subtypes1.add(TypeConstrainer.getBaseType(sub1));
        }
        ArrayList<JClassType> subtypes2 = new ArrayList<JClassType>();
        subtypes2.add(type2);
        for (JClassType sub2 : type2.getSubtypes()) {
            subtypes2.add(TypeConstrainer.getBaseType(sub2));
        }
        for (JClassType sub2 : subtypes2) {
            if (!subtypes1.contains(sub2)) continue;
            return true;
        }
        return false;
    }

    private static JClassType getBaseType(JClassType type) {
        return SerializableTypeOracleBuilder.getBaseType(type);
    }

    private static boolean isRealOrParameterized(JClassType type) {
        if (type.isParameterized() != null) {
            return true;
        }
        return type instanceof JRealClassType;
    }

    private static JClassType[] makeArray(JClassType ... classTypes) {
        return classTypes;
    }

    private static boolean occurs(JTypeParameter param, JClassType type) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class OccursVisitor
        extends JTypeVisitor {
            boolean foundIt = false;
            final /* synthetic */ JTypeParameter val$param;

            OccursVisitor(JTypeParameter jTypeParameter) {
                this.val$param = jTypeParameter;
            }

            @Override
            public void endVisit(JTypeParameter seenParam) {
                if (seenParam == this.val$param) {
                    this.foundIt = true;
                }
            }
        }
        OccursVisitor visitor = new OccursVisitor(param);
        visitor.accept((JType)type);
        return visitor.foundIt;
    }

    public TypeConstrainer(TypeOracle typeOracle) {
        this.typeOracle = typeOracle;
    }

    public JClassType constrainTypeBy(JClassType subType, JClassType superType) {
        JParameterizedType superAsParameterized = superType.isParameterized();
        if (superAsParameterized == null) {
            return subType;
        }
        HashMap<JTypeParameter, JClassType> constraints = new HashMap<JTypeParameter, JClassType>();
        JClassType subWithWildcardsReplaced = this.replaceWildcardsWithFreshTypeVariables(subType, constraints);
        JParameterizedType subAsParameterized = subWithWildcardsReplaced.asParameterizationOf(superAsParameterized.getBaseType());
        if (subAsParameterized == null) {
            return subType;
        }
        if (!this.typesMatch((JClassType)subAsParameterized, (JClassType)superAsParameterized, constraints)) {
            return null;
        }
        return this.substitute(subWithWildcardsReplaced, constraints);
    }

    boolean typesMatch(JClassType type1, JClassType type2, Map<JTypeParameter, JClassType> constraints) {
        JGenericType type1Generic = type1.isGenericType();
        if (type1Generic != null) {
            return this.typesMatch((JClassType)type1Generic.asParameterizedByWildcards(), type2, constraints);
        }
        JGenericType type2Generic = type2.isGenericType();
        if (type2Generic != null) {
            return this.typesMatch(type1, (JClassType)type2Generic.asParameterizedByWildcards(), constraints);
        }
        JWildcardType type1Wild = type1.isWildcard();
        if (type1Wild != null) {
            return this.typesMatch(type1Wild.getUpperBound(), type2, constraints);
        }
        JWildcardType type2Wild = type2.isWildcard();
        if (type2Wild != null) {
            return this.typesMatch(type1, type2Wild.getUpperBound(), constraints);
        }
        JRawType type1Raw = type1.isRawType();
        if (type1Raw != null) {
            return this.typesMatch((JClassType)type1Raw.asParameterizedByWildcards(), type2, constraints);
        }
        JRawType type2Raw = type2.isRawType();
        if (type2Raw != null) {
            return this.typesMatch(type1, (JClassType)type2Raw.asParameterizedByWildcards(), constraints);
        }
        if (type1 == type2) {
            return true;
        }
        if (constraints.containsKey(type1)) {
            JTypeParameter type1Parameter = (JTypeParameter)type1;
            JClassType type2Class = type2;
            JClassType type1Bound = constraints.get(type1Parameter);
            assert (!TypeConstrainer.occurs(type1Parameter, type1Bound));
            if (!this.typesMatch(type1Bound, type2, constraints)) {
                return false;
            }
            if (type1Bound.isAssignableFrom(type2Class)) {
                constraints.put(type1Parameter, type2Class);
            }
        }
        if (type1 == this.typeOracle.getJavaLangObject()) {
            return true;
        }
        if (type2 == this.typeOracle.getJavaLangObject()) {
            return true;
        }
        JTypeParameter type1Param = type1.isTypeParameter();
        if (type1Param != null) {
            return true;
        }
        JTypeParameter type2Param = type2.isTypeParameter();
        if (type2Param != null) {
            return true;
        }
        JArrayType type1Array = type1.isArray();
        JArrayType type2Array = type2.isArray();
        if (type1Array != null && type2Array != null && this.typesMatch(type1Array.getComponentType(), type2Array.getComponentType(), constraints)) {
            return true;
        }
        if (TypeConstrainer.isRealOrParameterized(type1) && TypeConstrainer.isRealOrParameterized(type2)) {
            JClassType baseType1 = TypeConstrainer.getBaseType(type1);
            JClassType baseType2 = TypeConstrainer.getBaseType(type2);
            JParameterizedType type1Parameterized = type1.isParameterized();
            JParameterizedType type2Parameterized = type2.isParameterized();
            if (baseType1 == baseType2 && type1Parameterized != null && type2Parameterized != null) {
                JClassType[] args1 = type1Parameterized.getTypeArgs();
                JClassType[] args2 = type2Parameterized.getTypeArgs();
                boolean allMatch = true;
                for (int i = 0; i < args1.length; ++i) {
                    if (this.typesMatch(args1[i], args2[i], constraints)) continue;
                    allMatch = false;
                }
                if (allMatch) {
                    return true;
                }
            } else if (TypeConstrainer.baseTypesOverlap(baseType1, baseType2)) {
                return true;
            }
        }
        return false;
    }

    boolean typesMatch(JType type1, JType type2, Map<JTypeParameter, JClassType> constraints) {
        if (type1 == type2) {
            return true;
        }
        JClassType type1Class = type1.isClassOrInterface();
        JClassType type2Class = type2.isClassOrInterface();
        return type1Class != null && type2Class != null && this.typesMatch(type1Class, type2Class, constraints);
    }

    private JClassType replaceWildcardsWithFreshTypeVariables(JClassType type, final Map<JTypeParameter, JClassType> constraints) {
        JModTypeVisitor replacer = new JModTypeVisitor(){

            public void endVisit(JWildcardType wildcardType) {
                JTypeParameter newParam = new JTypeParameter("TP$" + TypeConstrainer.this.freshTypeVariableCounter++, -1);
                newParam.setBounds(TypeConstrainer.makeArray(new JClassType[]{TypeConstrainer.this.typeOracle.getJavaLangObject()}));
                constraints.put(newParam, wildcardType.getUpperBound());
                this.replacement = newParam;
            }
        };
        return replacer.transform(type);
    }

    private JClassType substitute(JClassType type, final Map<JTypeParameter, JClassType> constraints) {
        JModTypeVisitor substituter = new JModTypeVisitor(){

            public void endVisit(JTypeParameter param) {
                JClassType constr = (JClassType)constraints.get(param);
                if (constr != null) {
                    this.replacement = constr;
                }
            }
        };
        return substituter.transform(type);
    }
}

