/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import javax.xml.stream.XMLStreamReader;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class XMLStreamReaderReader
extends XMLReaderAdapter {
    private int depth = 0;
    private UnmarshalNamespaceContext unmarshalNamespaceContext = new UnmarshalNamespaceContext();
    private XMLStreamReaderAttributes indexedAttributeList = new XMLStreamReaderAttributes();
    private boolean qNameAware;
    private XMLStreamReader xmlStreamReader;

    public XMLStreamReaderReader() {
    }

    public XMLStreamReaderReader(Unmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    @Override
    public Locator getLocator() {
        if (this.locator == null) {
            this.locator = new StreamReaderLocator(this.xmlStreamReader);
        }
        return this.locator;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        if (handler instanceof UnmarshalRecord) {
            ((UnmarshalRecord)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = false;
            if (null == this.validatingContentHandler) {
                this.contentHandler = (UnmarshalRecord)handler;
            } else {
                this.validatingContentHandler.setContentHandler(handler);
            }
        } else if (handler instanceof SAXUnmarshallerHandler) {
            ((SAXUnmarshallerHandler)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = true;
            if (null == this.validatingContentHandler) {
                this.contentHandler = (SAXUnmarshallerHandler)handler;
            } else {
                this.validatingContentHandler.setContentHandler(handler);
            }
        } else {
            super.setContentHandler(handler);
            this.qNameAware = true;
        }
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        if (null == this.contentHandler) {
            return;
        }
        if (input instanceof XMLStreamReaderInputSource) {
            XMLStreamReader xmlStreamReader = ((XMLStreamReaderInputSource)input).getXmlStreamReader();
            this.parse(xmlStreamReader);
        }
    }

    public void parse(XMLStreamReader xmlStreamReader) throws SAXException {
        this.xmlStreamReader = xmlStreamReader;
        this.unmarshalNamespaceContext.setXmlStreamReader(xmlStreamReader);
        this.indexedAttributeList.setXmlStreamReader(xmlStreamReader);
        try {
            this.contentHandler.startDocument();
            this.parseEvent(xmlStreamReader, xmlStreamReader.getEventType());
            while (this.depth > 0) {
                int eventType = xmlStreamReader.next();
                this.parseEvent(xmlStreamReader, eventType);
            }
            if (xmlStreamReader.hasNext()) {
                xmlStreamReader.next();
            }
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void parseEvent(XMLStreamReader xmlStreamReader, int eventType) throws SAXException {
        switch (eventType) {
            case 1: {
                ++this.depth;
                int namespaceCount = xmlStreamReader.getNamespaceCount();
                if (namespaceCount > 0) {
                    for (int x = 0; x < namespaceCount; ++x) {
                        this.contentHandler.startPrefixMapping(xmlStreamReader.getNamespacePrefix(x), xmlStreamReader.getNamespaceURI(x));
                    }
                }
                String localName = xmlStreamReader.getLocalName();
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (null == prefix || prefix.length() == 0) {
                        this.contentHandler.startElement(namespaceURI, localName, localName, this.indexedAttributeList.reset());
                        break;
                    }
                    this.contentHandler.startElement(namespaceURI, localName, prefix + ":" + localName, this.indexedAttributeList.reset());
                    break;
                }
                this.contentHandler.startElement(namespaceURI, localName, localName, this.indexedAttributeList.reset());
                break;
            }
            case 2: {
                --this.depth;
                String localName = xmlStreamReader.getLocalName();
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (null == prefix || prefix.length() == 0) {
                        this.contentHandler.endElement(namespaceURI, localName, localName);
                    } else {
                        this.contentHandler.endElement(namespaceURI, localName, prefix + ":" + localName);
                    }
                } else {
                    this.contentHandler.endElement(namespaceURI, localName, localName);
                }
                int namespaceCount = xmlStreamReader.getNamespaceCount();
                if (namespaceCount <= 0) break;
                for (int x = 0; x < namespaceCount; ++x) {
                    this.contentHandler.endPrefixMapping(xmlStreamReader.getNamespacePrefix(x));
                }
                break;
            }
            case 3: {
                this.contentHandler.processingInstruction(xmlStreamReader.getPITarget(), xmlStreamReader.getPIData());
                break;
            }
            case 4: {
                this.parseCharactersEvent(xmlStreamReader);
                break;
            }
            case 5: {
                if (null == this.lexicalHandler) break;
                this.lexicalHandler.comment(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 6: {
                this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                if (null == this.lexicalHandler) {
                    this.parseCharactersEvent(xmlStreamReader);
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.parseCharactersEvent(xmlStreamReader);
                this.lexicalHandler.endCDATA();
            }
        }
    }

    protected void parseCharactersEvent(XMLStreamReader xmlStreamReader) throws SAXException {
        this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
    }

    private static class XMLStreamReaderAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private XMLStreamReader xmlStreamReader;

        private XMLStreamReaderAttributes() {
        }

        public void setXmlStreamReader(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        @Override
        protected XMLReaderAdapter.Attribute[] attributes() {
            if (null == this.attributes) {
                int attributeCount;
                int namespaceCount = this.xmlStreamReader.getNamespaceCount();
                if (namespaceCount + (attributeCount = this.xmlStreamReader.getAttributeCount()) == 0) {
                    this.attributes = NO_ATTRIBUTES;
                } else {
                    String localName;
                    String uri;
                    int x;
                    this.attributes = new XMLReaderAdapter.Attribute[attributeCount + namespaceCount];
                    for (x = 0; x < attributeCount; ++x) {
                        uri = this.xmlStreamReader.getAttributeNamespace(x);
                        localName = this.xmlStreamReader.getAttributeLocalName(x);
                        String prefix = this.xmlStreamReader.getAttributePrefix(x);
                        Object qName = null == prefix || prefix.length() == 0 ? localName : prefix + ":" + localName;
                        String value = this.xmlStreamReader.getAttributeValue(x);
                        this.attributes[x] = new XMLReaderAdapter.Attribute(uri, localName, (String)qName, value);
                    }
                    for (x = 0; x < namespaceCount; ++x) {
                        Object qName;
                        uri = "http://www.w3.org/2000/xmlns/";
                        localName = this.xmlStreamReader.getNamespacePrefix(x);
                        if (null == localName || localName.length() == 0) {
                            localName = "xmlns";
                            qName = "xmlns";
                        } else {
                            qName = "xmlns:" + localName;
                        }
                        String value = this.xmlStreamReader.getNamespaceURI(x);
                        this.attributes[x + attributeCount] = new XMLReaderAdapter.Attribute(uri, localName, (String)qName, value);
                    }
                }
            }
            return this.attributes;
        }

        @Override
        public String getValue(String uri, String localName) {
            if ("".equals(uri)) {
                uri = null;
            }
            return this.xmlStreamReader.getAttributeValue(uri, localName);
        }
    }

    private static class StreamReaderLocator
    implements Locator2 {
        private XMLStreamReader reader;

        public StreamReaderLocator(XMLStreamReader r) {
            this.reader = r;
        }

        @Override
        public String getPublicId() {
            return this.reader.getLocation().getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.reader.getLocation().getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.reader.getLocation().getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.reader.getLocation().getColumnNumber();
        }

        @Override
        public String getXMLVersion() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }
    }
}

