/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme.css;

import org.eclipse.rap.rwt.internal.theme.StyleSheetBuilder;
import org.eclipse.rap.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rap.rwt.internal.theme.css.PropertyResolver;
import org.eclipse.rap.rwt.internal.theme.css.StyleRule;
import org.eclipse.rap.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class DocumentHandlerImpl
implements DocumentHandler {
    private String uri;
    private final CssFileReader reader;
    private final ResourceLoader loader;
    private final StyleSheetBuilder styleSheetBuilder;
    private PropertyResolver propertyResolver;

    public DocumentHandlerImpl(CssFileReader reader, ResourceLoader loader) {
        this.reader = reader;
        this.loader = loader;
        this.styleSheetBuilder = new StyleSheetBuilder();
    }

    @Override
    public void startDocument(InputSource source) throws CSSException {
        this.uri = source.getURI();
        this.log("=== startDocument " + this.uri + "===");
    }

    @Override
    public void endDocument(InputSource source) throws CSSException {
        this.log("___ endDocument ___");
    }

    @Override
    public void startSelector(SelectorList selectors) throws CSSException {
        this.log("startSelector " + DocumentHandlerImpl.toString(selectors));
        this.propertyResolver = new PropertyResolver();
    }

    @Override
    public void endSelector(SelectorList selectors) throws CSSException {
        this.log("endSelector " + DocumentHandlerImpl.toString(selectors));
        StyleRule styleRule = new StyleRule(selectors, this.propertyResolver.getResolvedProperties());
        this.styleSheetBuilder.addStyleRule(styleRule);
        this.propertyResolver = null;
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        this.log("  property " + name + " := " + PropertyResolver.toString(value) + (important ? " !" : ""));
        if (important) {
            this.reader.addProblem(new CSSException("Important rules not supported - ignored"));
        }
        if (this.propertyResolver != null) {
            try {
                this.propertyResolver.resolveProperty(name, value, this.loader);
            }
            catch (IllegalArgumentException exception) {
                this.reader.addProblem(new CSSException("Failed to read property " + name + ": " + exception.getMessage()));
            }
        }
    }

    @Override
    public void comment(String text) throws CSSException {
        this.log("    /*" + text + "*/");
    }

    @Override
    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        this.log("importStyle " + uri + ", " + media + ", " + defaultNamespaceURI);
        this.reader.addProblem(new CSSException("import rules not supported - ignored"));
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        this.log("namespaceDeclaration " + prefix + ", " + uri);
        this.reader.addProblem(new CSSException("unsupported namespace declaration '" + prefix + ":" + uri + "' - ignored"));
    }

    @Override
    public void ignorableAtRule(String atRule) throws CSSException {
        this.log("ignorableAtRule " + atRule);
        this.reader.addProblem(new CSSException("unsupported at rule '" + atRule + "' - ignored"));
    }

    @Override
    public void startPage(String name, String pseudo_page) throws CSSException {
        this.log("startPage " + name + ", " + pseudo_page);
        this.reader.addProblem(new CSSException("page rules not supported - ignored"));
    }

    @Override
    public void endPage(String name, String pseudo_page) throws CSSException {
        this.log("endPage " + name + ", " + pseudo_page);
    }

    @Override
    public void startMedia(SACMediaList media) throws CSSException {
        this.log("startMedia " + media);
        this.reader.addProblem(new CSSException("media rules not supported - ignored"));
    }

    @Override
    public void endMedia(SACMediaList media) throws CSSException {
        this.log("endMedia " + media);
    }

    @Override
    public void startFontFace() throws CSSException {
        this.log("startFontFace");
        this.reader.addProblem(new CSSException("font face rules not supported - ignored"));
    }

    @Override
    public void endFontFace() throws CSSException {
        this.log("end FontFace");
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheetBuilder.getStyleSheet();
    }

    private void log(String message) {
    }

    private static String toString(SelectorList patterns) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        int length = patterns.getLength();
        int i = 0;
        while (i < length) {
            buffer.append(" ");
            Selector selector = patterns.item(i);
            buffer.append(selector.toString());
            ++i;
        }
        buffer.append(" ]");
        return buffer.toString();
    }
}

