/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 
 *******************************************************************************/

package org.eclipse.rap.service.servlet.internal.runtime.dto;

import org.osgi.dto.DTO;

/**
 * Represents a resource definition currently being used by a servlet context.
 * 
 * @NotThreadSafe
 * @author $Id: 6c99e33f1664cb933f0a3333deb05f4e1ee37d9c $
 */
public class ResourceDTO extends DTO {
	/**
	 * The request mappings for the resource.
	 * 
	 * <p>
	 * The specified patterns are used to determine whether a request is mapped
	 * to the resource. This value is never {@code null}.
	 */
	public String[]				patterns;

	/**
	 * The prefix of the resource.
	 */
	public String				prefix;

	/**
	 * Service property identifying the resource. In the case of a resource
	 * registered in the service registry and picked up by a Servlet Whiteboard
	 * Implementation, this value is not negative and corresponds to the service
	 * id in the registry. If the resource has not been registered in the
	 * service registry, the value is negative and a unique negative value is
	 * generated by the Http Service Runtime in this case.
	 */
	public long					serviceId;

	/**
	 * The service id of the servlet context for the resource represented by
	 * this DTO.
	 */
	public long		servletContextId;
}
