/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.servletbridge;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.rap.servletbridge.CloseableURLClassLoader;

public class FrameworkLauncher {
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String CONFIG_INI = "config.ini";
    private static final String DOT_JAR = ".jar";
    private static final String WS_DELIM = " \t\n\r\f";
    protected static final String FILE_SCHEME = "file:";
    protected static final String FRAMEWORK_BUNDLE_NAME = "org.eclipse.osgi";
    protected static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    protected static final String NULL_IDENTIFIER = "@null";
    protected static final String OSGI_FRAMEWORK = "osgi.framework";
    protected static final String OSGI_FRAMEWORK_EXTENSIONS = "osgi.framework.extensions";
    protected static final String OSGI_INSTANCE_AREA = "osgi.instance.area";
    protected static final String OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    protected static final String OSGI_INSTALL_AREA = "osgi.install.area";
    protected static final String OSGI_FORCED_RESTART = "osgi.forcedRestart";
    protected static final String RESOURCE_BASE = "/WEB-INF/";
    protected static final String ECLIPSE = "eclipse/";
    protected static final String LAUNCH_INI = "launch.ini";
    private static final String EXTENSIONBUNDLE_DEFAULT_BSN = "org.eclipse.rap.servletbridge.extensionbundle";
    private static final String EXTENSIONBUNDLE_DEFAULT_VERSION = "4.4.0";
    private static final String MANIFEST_VERSION = "Manifest-Version";
    private static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String FRAGMENT_HOST = "Fragment-Host";
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String CONFIG_COMMANDLINE = "commandline";
    private static final String CONFIG_EXTENDED_FRAMEWORK_EXPORTS = "extendedFrameworkExports";
    private static final String CONFIG_OVERRIDE_AND_REPLACE_EXTENSION_BUNDLE = "overrideAndReplaceExtensionBundle";
    static final PermissionCollection allPermissions = new PermissionCollection(){
        private static final long serialVersionUID = 482874725021998286L;
        Permission allPermission = new AllPermission();

        @Override
        public void add(Permission permission) {
        }

        @Override
        public boolean implies(Permission permission) {
            return true;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(Collections.singleton(this.allPermission));
        }
    };
    protected ServletConfig config;
    protected ServletContext context;
    protected String resourceBase;
    private File platformDirectory;
    private ClassLoader frameworkContextClassLoader;
    private CloseableURLClassLoader frameworkClassLoader;

    static {
        if (allPermissions.elements() == null) {
            throw new IllegalStateException();
        }
    }

    void init(ServletConfig servletConfig) {
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
        this.initResourceBase();
        this.init();
    }

    protected void initResourceBase() {
        try {
            if (this.context.getResource("/WEB-INF/launch.ini") != null) {
                this.resourceBase = RESOURCE_BASE;
                return;
            }
            if (this.context.getResource("/WEB-INF/eclipse/launch.ini") != null) {
                this.resourceBase = "/WEB-INF/eclipse/";
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        this.resourceBase = RESOURCE_BASE;
    }

    public void init() {
    }

    public void destroy() {
    }

    public synchronized void deploy() {
        if (this.platformDirectory != null) {
            this.context.log("Framework is already deployed");
            return;
        }
        File servletTemp = (File)this.context.getAttribute("jakarta.servlet.context.tempdir");
        this.platformDirectory = new File(servletTemp, "eclipse");
        if (!this.platformDirectory.exists()) {
            this.platformDirectory.mkdirs();
        }
        this.copyResource(String.valueOf(this.resourceBase) + "configuration/", new File(this.platformDirectory, "configuration"));
        this.copyResource(String.valueOf(this.resourceBase) + "features/", new File(this.platformDirectory, "features"));
        File plugins = new File(this.platformDirectory, "plugins");
        this.copyResource(String.valueOf(this.resourceBase) + "plugins/", plugins);
        this.copyResource(String.valueOf(this.resourceBase) + "p2/", new File(this.platformDirectory, "p2"));
        this.deployExtensionBundle(plugins);
        this.copyResource(String.valueOf(this.resourceBase) + ".eclipseproduct", new File(this.platformDirectory, ".eclipseproduct"));
    }

    private void deployExtensionBundle(File plugins) {
        File extensionBundleFile = this.findExtensionBundleFile(plugins, EXTENSIONBUNDLE_DEFAULT_BSN);
        if (extensionBundleFile == null) {
            this.generateExtensionBundle(plugins, EXTENSIONBUNDLE_DEFAULT_BSN, EXTENSIONBUNDLE_DEFAULT_VERSION);
        } else if (Boolean.valueOf(this.config.getInitParameter(CONFIG_OVERRIDE_AND_REPLACE_EXTENSION_BUNDLE)).booleanValue()) {
            String extensionBundleVersion = this.findExtensionBundleVersion(extensionBundleFile, EXTENSIONBUNDLE_DEFAULT_BSN);
            if (extensionBundleFile.isDirectory()) {
                FrameworkLauncher.deleteDirectory(extensionBundleFile);
            } else {
                extensionBundleFile.delete();
            }
            this.generateExtensionBundle(plugins, EXTENSIONBUNDLE_DEFAULT_BSN, extensionBundleVersion);
        } else {
            this.processExtensionBundle(extensionBundleFile);
        }
    }

    private File findExtensionBundleFile(File plugins, final String extensionBundleBSN) {
        FileFilter extensionBundleFilter = new FileFilter(){

            @Override
            public boolean accept(File candidate) {
                return candidate.getName().startsWith(String.valueOf(extensionBundleBSN) + "_");
            }
        };
        File[] extensionBundles = plugins.listFiles(extensionBundleFilter);
        if (extensionBundles.length == 0) {
            return null;
        }
        if (extensionBundles.length > 1) {
            int i = 1;
            while (i < extensionBundles.length) {
                if (extensionBundles[i].isDirectory()) {
                    FrameworkLauncher.deleteDirectory(extensionBundles[i]);
                } else {
                    extensionBundles[i].delete();
                }
                ++i;
            }
        }
        return extensionBundles[0];
    }

    private String findExtensionBundleVersion(File extensionBundleFile, String extensionBundleBSN) {
        String fileName = extensionBundleFile.getName();
        if (fileName.endsWith(DOT_JAR)) {
            return fileName.substring(extensionBundleBSN.length() + 1, fileName.length() - DOT_JAR.length());
        }
        return fileName.substring(extensionBundleBSN.length() + 1);
    }

    private void generateExtensionBundle(File plugins, String extensionBundleBSN, String extensionBundleVersion) {
        Manifest mf = new Manifest();
        Attributes attribs = mf.getMainAttributes();
        attribs.putValue(MANIFEST_VERSION, "1.0");
        attribs.putValue(BUNDLE_MANIFEST_VERSION, "2");
        attribs.putValue(BUNDLE_NAME, "Servletbridge Extension Bundle");
        attribs.putValue(BUNDLE_SYMBOLIC_NAME, extensionBundleBSN);
        attribs.putValue(BUNDLE_VERSION, extensionBundleVersion);
        attribs.putValue(FRAGMENT_HOST, "system.bundle; extension:=framework");
        String packageExports = null;
        String servletVersion = String.valueOf(this.context.getMajorVersion()) + "." + this.context.getMinorVersion();
        if (this.context.getMajorVersion() < 6) {
            throw new IllegalArgumentException("Unsupported Jakarta Servlet version: " + servletVersion);
        }
        packageExports = "org.eclipse.rap.servletbridge; version=4.4, jakarta.servlet; version=" + servletVersion + ", jakarta.servlet.annotation; version=" + servletVersion + ", jakarta.servlet.descriptor; version=" + servletVersion + ", jakarta.servlet.http; version=" + servletVersion + ", jakarta.servlet.resources; version=" + servletVersion;
        String extendedExports = this.config.getInitParameter(CONFIG_EXTENDED_FRAMEWORK_EXPORTS);
        if (extendedExports != null && extendedExports.trim().length() != 0) {
            packageExports = String.valueOf(packageExports) + ", " + extendedExports;
        }
        attribs.putValue(EXPORT_PACKAGE, packageExports);
        this.writeJarFile(new File(plugins, String.valueOf(extensionBundleBSN) + "_" + extensionBundleVersion + DOT_JAR), mf);
    }

    private void processExtensionBundle(File extensionBundleFile) {
        String fileName = extensionBundleFile.getName();
        if (fileName.endsWith(DOT_JAR)) {
            Manifest mf = this.readJarFile(extensionBundleFile);
            if (mf == null) {
                return;
            }
            Attributes attributes = mf.getMainAttributes();
            String exportPackage = (String)attributes.remove(new Attributes.Name("X-Deploy-Export-Package"));
            if (exportPackage != null) {
                attributes.putValue(EXPORT_PACKAGE, exportPackage);
                this.writeJarFile(extensionBundleFile, mf);
            }
        }
    }

    private void writeJarFile(File jarFile, Manifest mf) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), mf);){
                jos.finish();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.context.log("Error writing extension bundle", (Throwable)e);
        }
    }

    private Manifest readJarFile(File jarFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JarInputStream jis = new JarInputStream(new FileInputStream(jarFile));){
                return jis.getManifest();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.context.log("Error reading extension bundle", (Throwable)e);
            return null;
        }
    }

    public synchronized void undeploy() {
        if (this.platformDirectory == null) {
            this.context.log("Undeploy unnecessary. - (not deployed)");
            return;
        }
        if (this.frameworkClassLoader != null) {
            throw new IllegalStateException("Could not undeploy Framework - (not stopped)");
        }
        FrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "configuration"));
        FrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "features"));
        FrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "plugins"));
        FrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "workspace"));
        FrameworkLauncher.deleteDirectory(new File(this.platformDirectory, "p2"));
        new File(this.platformDirectory, ".eclipseproduct").delete();
        this.platformDirectory = null;
    }

    public synchronized void start() {
        String[] args;
        if (this.platformDirectory == null) {
            throw new IllegalStateException("Could not start the Framework - (not deployed)");
        }
        if (this.frameworkClassLoader != null) {
            this.context.log("Framework is already started");
            return;
        }
        Map<String, String> initialPropertyMap = this.buildInitialPropertyMap();
        String[] stringArray = args = this.buildCommandLineArguments();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-D")) {
                int equalsIndex = arg.indexOf(61);
                if (equalsIndex == -1) {
                    initialPropertyMap.put(arg.substring(2), "");
                } else {
                    String key = arg.substring(2, equalsIndex);
                    String value = arg.substring(equalsIndex + 1);
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    this.setInitialProperty(initialPropertyMap, key, value);
                }
            }
            ++n2;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                System.setProperty("osgi.framework.useSystemProperties", "false");
                URL[] frameworkURLs = this.findFrameworkURLs(initialPropertyMap);
                this.frameworkClassLoader = new ChildFirstURLClassLoader(frameworkURLs, this.getClass().getClassLoader());
                Class<?> clazz = this.frameworkClassLoader.loadClass(STARTER);
                Method setInitialProperties = clazz.getMethod("setInitialProperties", Map.class);
                setInitialProperties.invoke(null, initialPropertyMap);
                this.registerRestartHandler(clazz);
                Method runMethod = clazz.getMethod("startup", String[].class, Runnable.class);
                runMethod.invoke(null, new Object[]{args, null});
                this.frameworkContextClassLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t == null) {
                    t = ite;
                }
                this.context.log("Error while starting Framework", t);
                throw new RuntimeException(t.getMessage());
            }
            catch (Exception e) {
                this.context.log("Error while starting Framework", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private URL[] findFrameworkURLs(Map<String, String> initialPropertyMap) {
        ArrayList<URL> frameworkURLs = new ArrayList<URL>();
        String installArea = initialPropertyMap.get(OSGI_INSTALL_AREA);
        if (installArea.startsWith(FILE_SCHEME)) {
            installArea = installArea.substring(FILE_SCHEME.length());
        }
        File installBase = new File(installArea);
        String osgiFramework = initialPropertyMap.get(OSGI_FRAMEWORK);
        File osgiFrameworkFile = null;
        if (osgiFramework == null) {
            String path = new File(installBase, "plugins").toString();
            if ((path = this.searchFor(FRAMEWORK_BUNDLE_NAME, path)) == null) {
                throw new RuntimeException("Could not find framework");
            }
            osgiFrameworkFile = new File(path);
        } else {
            if (osgiFramework.startsWith(FILE_SCHEME)) {
                osgiFramework = osgiFramework.substring(FILE_SCHEME.length());
            }
            if (!(osgiFrameworkFile = new File(osgiFramework)).isAbsolute()) {
                osgiFrameworkFile = new File(installBase, osgiFramework);
            }
        }
        try {
            URL frameworkURL = osgiFrameworkFile.toURL();
            frameworkURLs.add(frameworkURL);
            initialPropertyMap.put(OSGI_FRAMEWORK, frameworkURL.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not find framework -- " + e.getMessage());
        }
        String osgiFrameworkExtensions = initialPropertyMap.get(OSGI_FRAMEWORK_EXTENSIONS);
        if (osgiFrameworkExtensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(osgiFrameworkExtensions, ",");
            while (tokenizer.hasMoreTokens()) {
                URL extensionURL;
                String extension = tokenizer.nextToken().trim();
                if (extension.length() == 0 || (extensionURL = this.findExtensionURL(extension, osgiFrameworkFile)) == null) continue;
                frameworkURLs.add(extensionURL);
            }
        }
        return frameworkURLs.toArray(new URL[frameworkURLs.size()]);
    }

    private URL findExtensionURL(String extension, File osgiFrameworkFile) {
        File extensionFile = null;
        if (extension.startsWith(REFERENCE_SCHEME)) {
            if (!(extension = extension.substring(REFERENCE_SCHEME.length())).startsWith(FILE_SCHEME)) {
                throw new RuntimeException("Non-file scheme for framework extension URL -- " + extension);
            }
            extensionFile = new File(extension = extension.substring(FILE_SCHEME.length()));
            if (!extensionFile.isAbsolute()) {
                extensionFile = new File(osgiFrameworkFile.getParentFile(), extension);
            }
        } else {
            String fullExtensionPath = this.searchFor(extension, osgiFrameworkFile.getParent());
            if (fullExtensionPath == null) {
                return null;
            }
            extensionFile = new File(fullExtensionPath);
        }
        try {
            return extensionFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not find framework extension -- " + extensionFile.getAbsolutePath() + " : " + e.getMessage());
        }
    }

    private void registerRestartHandler(Class<?> starterClazz) throws IllegalAccessException, InvocationTargetException {
        Method registerFrameworkShutdownHandler = null;
        try {
            registerFrameworkShutdownHandler = starterClazz.getDeclaredMethod("internalAddFrameworkShutdownHandler", Runnable.class);
            registerFrameworkShutdownHandler.trySetAccessible();
            Runnable restartHandler = this.createRestartHandler(starterClazz);
            registerFrameworkShutdownHandler.invoke(null, restartHandler);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.context.log(String.valueOf(starterClazz.getName()) + " does not support setting a shutdown handler. Restart handling is disabled.");
            return;
        }
    }

    private Runnable createRestartHandler(Class<?> starterClazz) throws NoSuchMethodException {
        final Method getProperty = starterClazz.getDeclaredMethod("getProperty", String.class);
        getProperty.trySetAccessible();
        Runnable restartHandler = new Runnable(){

            @Override
            public void run() {
                try {
                    String forcedRestart = (String)getProperty.invoke(null, FrameworkLauncher.OSGI_FORCED_RESTART);
                    if (Boolean.valueOf(forcedRestart).booleanValue()) {
                        FrameworkLauncher.this.stop();
                        FrameworkLauncher.this.start();
                    }
                }
                catch (InvocationTargetException ite) {
                    Throwable t = ite.getTargetException();
                    if (t == null) {
                        t = ite;
                    }
                    throw new RuntimeException(t.getMessage());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
        return restartHandler;
    }

    protected Map<String, String> buildInitialPropertyMap() {
        HashMap<String, String> initialPropertyMap = new HashMap<String, String>();
        Properties launchProperties = this.loadProperties(String.valueOf(this.resourceBase) + LAUNCH_INI);
        for (Map.Entry<Object, Object> entry : launchProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setInitialProperty(initialPropertyMap, key, value);
        }
        try {
            String osgiFrameworkExtensions;
            String osgiFramework;
            if (initialPropertyMap.get(OSGI_INSTALL_AREA) == null) {
                initialPropertyMap.put(OSGI_INSTALL_AREA, this.platformDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_CONFIGURATION_AREA) == null) {
                File configurationDirectory = new File(this.platformDirectory, "configuration");
                if (!configurationDirectory.exists()) {
                    configurationDirectory.mkdirs();
                }
                initialPropertyMap.put(OSGI_CONFIGURATION_AREA, configurationDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_INSTANCE_AREA) == null) {
                File workspaceDirectory = new File(this.platformDirectory, "workspace");
                if (!workspaceDirectory.exists()) {
                    workspaceDirectory.mkdirs();
                }
                initialPropertyMap.put(OSGI_INSTANCE_AREA, workspaceDirectory.toURL().toExternalForm());
            }
            Properties configurationProperties = this.loadConfigurationFile(initialPropertyMap);
            if (initialPropertyMap.get(OSGI_FRAMEWORK) == null && (osgiFramework = configurationProperties.getProperty(OSGI_FRAMEWORK)) != null) {
                initialPropertyMap.put(OSGI_FRAMEWORK, osgiFramework);
            }
            if (initialPropertyMap.get(OSGI_FRAMEWORK_EXTENSIONS) == null && (osgiFrameworkExtensions = configurationProperties.getProperty(OSGI_FRAMEWORK_EXTENSIONS)) != null) {
                initialPropertyMap.put(OSGI_FRAMEWORK_EXTENSIONS, osgiFrameworkExtensions);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Error establishing location");
        }
        return initialPropertyMap;
    }

    private void setInitialProperty(Map<String, String> initialPropertyMap, String key, String value) {
        if (key.endsWith("*")) {
            if (value.equals(NULL_IDENTIFIER)) {
                FrameworkLauncher.clearPrefixedSystemProperties(key.substring(0, key.length() - 1), initialPropertyMap);
            }
        } else if (value.equals(NULL_IDENTIFIER)) {
            initialPropertyMap.put(key, null);
        } else {
            initialPropertyMap.put(key, value);
        }
    }

    private Properties loadConfigurationFile(Map<String, String> initialPropertyMap) {
        InputStream is = null;
        try {
            File configurationFile;
            File configurationBase;
            String installArea = initialPropertyMap.get(OSGI_INSTALL_AREA);
            if (installArea.startsWith(FILE_SCHEME)) {
                installArea = installArea.substring(FILE_SCHEME.length());
            }
            File installBase = new File(installArea);
            String configurationArea = initialPropertyMap.get(OSGI_CONFIGURATION_AREA);
            if (configurationArea.startsWith(FILE_SCHEME)) {
                configurationArea = configurationArea.substring(FILE_SCHEME.length());
            }
            if (!(configurationBase = new File(configurationArea)).isAbsolute()) {
                configurationBase = new File(installBase, configurationArea);
            }
            if (!(configurationFile = new File(configurationBase, CONFIG_INI)).exists()) {
                return null;
            }
            Properties configProperties = new Properties();
            is = new BufferedInputStream(new FileInputStream(configurationFile));
            configProperties.load(is);
            Properties properties = configProperties;
            return properties;
        }
        catch (Throwable t) {
            this.context.log("Error reading configuration file -- " + t.toString());
            return null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void clearPrefixedSystemProperties(String prefix, Map<String, String> targetPropertyMap) {
        for (Object key : System.getProperties().keySet()) {
            String propertyName = (String)key;
            if (!propertyName.startsWith(prefix) || targetPropertyMap.containsKey(propertyName)) continue;
            targetPropertyMap.put(propertyName, null);
        }
    }

    protected String[] buildCommandLineArguments() {
        ArrayList<String> args = new ArrayList<String>();
        String commandLine = this.config.getInitParameter(CONFIG_COMMANDLINE);
        if (commandLine != null) {
            StringTokenizer tokenizer = new StringTokenizer(commandLine, WS_DELIM);
            while (tokenizer.hasMoreTokens()) {
                int matchIndex;
                String arg = tokenizer.nextToken();
                if (arg.startsWith("\"")) {
                    if (arg.endsWith("\"")) {
                        if (arg.length() >= 2) {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                    } else {
                        String remainingArg = tokenizer.nextToken("\"");
                        arg = String.valueOf(arg.substring(1)) + remainingArg;
                        tokenizer.nextToken(WS_DELIM);
                    }
                } else if (arg.startsWith("'")) {
                    if (arg.endsWith("'")) {
                        if (arg.length() >= 2) {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                    } else {
                        String remainingArg = tokenizer.nextToken("'");
                        arg = String.valueOf(arg.substring(1)) + remainingArg;
                        tokenizer.nextToken(WS_DELIM);
                    }
                } else if (arg.startsWith("-D") && (matchIndex = arg.indexOf("=\"")) != -1 && !arg.substring(matchIndex + 2).endsWith("\"") && tokenizer.hasMoreTokens()) {
                    arg = String.valueOf(arg) + tokenizer.nextToken("\"") + "\"";
                    tokenizer.nextToken(WS_DELIM);
                }
                args.add(arg);
            }
        }
        return args.toArray(new String[0]);
    }

    public synchronized void stop() {
        if (this.platformDirectory == null) {
            this.context.log("Shutdown unnecessary. (not deployed)");
            return;
        }
        if (this.frameworkClassLoader == null) {
            this.context.log("Framework is already shutdown");
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> clazz = this.frameworkClassLoader.loadClass(STARTER);
                Method method = clazz.getDeclaredMethod("shutdown", new Class[0]);
                Thread.currentThread().setContextClassLoader(this.frameworkContextClassLoader);
                method.invoke(clazz, new Object[0]);
                try {
                    clazz = this.getClass().getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
                    method = clazz.getDeclaredMethod("release", ClassLoader.class);
                    method.invoke(clazz, this.frameworkContextClassLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            catch (Exception e) {
                this.context.log("Error while stopping Framework", (Throwable)e);
                this.frameworkClassLoader.close();
                this.frameworkClassLoader = null;
                this.frameworkContextClassLoader = null;
                Thread.currentThread().setContextClassLoader(original);
                return;
            }
        }
        finally {
            this.frameworkClassLoader.close();
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected void copyResource(String resourcePath, File target) {
        block17: {
            if (resourcePath.endsWith("/")) {
                target.mkdir();
                Set paths = this.context.getResourcePaths(resourcePath);
                if (paths == null) {
                    return;
                }
                for (String path : paths) {
                    File newFile = new File(target, path.substring(resourcePath.length()));
                    this.copyResource(path, newFile);
                }
            } else {
                try {
                    if (!target.createNewFile()) break block17;
                    Throwable paths = null;
                    Object var4_10 = null;
                    try (InputStream is = this.context.getResourceAsStream(resourcePath);){
                        if (is == null) {
                            return;
                        }
                        Files.copy(is, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable) {
                        if (paths == null) {
                            paths = throwable;
                        } else if (paths != throwable) {
                            paths.addSuppressed(throwable);
                        }
                        throw paths;
                    }
                }
                catch (IOException e) {
                    this.context.log("Error copying resources", (Throwable)e);
                }
            }
        }
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    FrameworkLauncher.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }

    public synchronized ClassLoader getFrameworkContextClassLoader() {
        return this.frameworkContextClassLoader;
    }

    protected synchronized File getPlatformDirectory() {
        return this.platformDirectory;
    }

    protected Properties loadProperties(String resource) {
        Properties result;
        block15: {
            result = new Properties();
            InputStream in = null;
            try {
                try {
                    URL location = this.context.getResource(resource);
                    if (location != null) {
                        in = location.openStream();
                        result.load(in);
                    }
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    protected String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        int i = 0;
        while (i < arrays.length) {
            arrays[i] = candidates[i].getName();
            ++i;
        }
        int result = this.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return String.valueOf(candidates[result].getAbsolutePath().replace(File.separatorChar, '/')) + (candidates[result].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
            } else if (this.compareVersion(maxVersion, currentVersion) < 0) {
                result = i;
                maxVersion = currentVersion;
            }
            ++i;
        }
        return result;
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        if (version.endsWith(DOT_JAR)) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{0, 0, 0, ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = Integer.valueOf(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    protected static class ChildFirstURLClassLoader
    extends CloseableURLClassLoader {
        private static final boolean CHILDFIRST_REGISTERED_AS_PARALLEL;

        static {
            boolean registeredAsParallel;
            try {
                Method parallelCapableMetod = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", null);
                parallelCapableMetod.setAccessible(true);
                registeredAsParallel = (Boolean)parallelCapableMetod.invoke(null, null);
            }
            catch (Throwable throwable) {
                registeredAsParallel = false;
            }
            CHILDFIRST_REGISTERED_AS_PARALLEL = registeredAsParallel;
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent, false);
        }

        @Override
        public URL getResource(String name) {
            ClassLoader parent;
            URL resource = this.findResource(name);
            if (resource == null && (parent = this.getParent()) != null) {
                resource = parent.getResource(name);
            }
            return resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.isRegisteredAsParallel()) {
                return this.loadClass0(name, resolve);
            }
            ChildFirstURLClassLoader childFirstURLClassLoader = this;
            synchronized (childFirstURLClassLoader) {
                return this.loadClass0(name, resolve);
            }
        }

        private Class<?> loadClass0(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassLoader parent = this.getParent();
                    clazz = parent != null ? parent.loadClass(name) : ChildFirstURLClassLoader.getSystemClassLoader().loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            return allPermissions;
        }

        @Override
        protected boolean isRegisteredAsParallel() {
            return CHILDFIRST_REGISTERED_AS_PARALLEL;
        }
    }
}

