/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.equinox.http.servlet.internal.HttpSessionAdaptor;
import org.eclipse.equinox.http.servlet.internal.RequestDispatcherAdaptor;

public class HttpServletRequestAdaptor
extends HttpServletRequestWrapper {
    private String alias;
    private Servlet servlet;
    private boolean isRequestDispatcherInclude;
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";

    public HttpServletRequestAdaptor(HttpServletRequest req, String alias, Servlet servlet) {
        super(req);
        this.alias = alias;
        this.servlet = servlet;
        this.isRequestDispatcherInclude = req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null;
    }

    public String getAuthType() {
        String authType = (String)super.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return super.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)super.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public String getPathInfo() {
        if (this.isRequestDispatcherInclude) {
            return super.getPathInfo();
        }
        if (this.alias.equals("/")) {
            return super.getPathInfo();
        }
        String pathInfo = super.getPathInfo().substring(this.alias.length());
        if (pathInfo.length() == 0) {
            return null;
        }
        return pathInfo;
    }

    public String getServletPath() {
        if (this.isRequestDispatcherInclude) {
            return super.getServletPath();
        }
        if (this.alias.equals("/")) {
            return "";
        }
        return this.alias;
    }

    public String getContextPath() {
        if (this.isRequestDispatcherInclude) {
            return super.getContextPath();
        }
        return String.valueOf(super.getContextPath()) + super.getServletPath();
    }

    public Object getAttribute(String attributeName) {
        if (this.isRequestDispatcherInclude) {
            if (attributeName.equals(INCLUDE_CONTEXT_PATH_ATTRIBUTE)) {
                String servletPath;
                String contextPath = (String)super.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
                if (contextPath == null || contextPath.equals("/")) {
                    contextPath = "";
                }
                if ((servletPath = (String)super.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE)) == null || servletPath.equals("/")) {
                    servletPath = "";
                }
                return String.valueOf(contextPath) + servletPath;
            }
            if (attributeName.equals(INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                if (this.alias.equals("/")) {
                    return "";
                }
                return this.alias;
            }
            if (attributeName.equals(INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String pathInfo = (String)super.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
                if (this.alias.equals("/")) {
                    return pathInfo;
                }
                if ((pathInfo = pathInfo.substring(this.alias.length())).length() == 0) {
                    return null;
                }
                return pathInfo;
            }
        }
        return super.getAttribute(attributeName);
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(super.getRequestDispatcher(String.valueOf(super.getServletPath()) + arg0));
    }

    public static String getDispatchPathInfo(HttpServletRequest req) {
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            return (String)req.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
        }
        return req.getPathInfo();
    }

    public static String getDispatchServletPath(HttpServletRequest req) {
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            String servletPath = (String)req.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE);
            return servletPath == null ? "" : servletPath;
        }
        return req.getServletPath();
    }

    public HttpSession getSession() {
        HttpSession session = super.getSession();
        if (session != null) {
            return new HttpSessionAdaptor(session, this.servlet);
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session != null) {
            return new HttpSessionAdaptor(session, this.servlet);
        }
        return null;
    }
}

