/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.protocol.ClientObject;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.protocol.IClientObjectAdapter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.IServiceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientObjectFactory {
    private static final String CLIENT_OBJECT_MAP_KEY = "synchronizerMapKey";

    public static IClientObject getClientObject(Adaptable object) {
        ParamCheck.notNull(object, "object");
        IClientObjectAdapter adapter = ClientObjectFactory.getAdapter(object);
        return ClientObjectFactory.getForId(adapter.getId());
    }

    private static IClientObjectAdapter getAdapter(Adaptable object) {
        IClientObjectAdapter result = object.getAdapter(IClientObjectAdapter.class);
        if (result == null) {
            String message = "Could not retrieve an instance of IClientObjectAdapter.";
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    private static IClientObject getForId(String id) {
        IClientObject result;
        Map<String, IClientObject> map = ClientObjectFactory.getClientObjectMap();
        if (map.containsKey(id)) {
            result = map.get(id);
        } else {
            result = new ClientObject(id);
            map.put(id, result);
        }
        return result;
    }

    private static Map<String, IClientObject> getClientObjectMap() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        HashMap result = (HashMap)serviceStore.getAttribute(CLIENT_OBJECT_MAP_KEY);
        if (result == null) {
            result = new HashMap();
            serviceStore.setAttribute(CLIENT_OBJECT_MAP_KEY, result);
        }
        return result;
    }

    private ClientObjectFactory() {
    }
}

