/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.service;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.FileSettingStore;
import org.eclipse.rwt.service.ISettingStore;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.rwt.service.SettingStoreException;

public final class RWTFileSettingStoreFactory
implements ISettingStoreFactory {
    public ISettingStore createSettingStore(String storeId) {
        ParamCheck.notNullOrEmpty(storeId, "storeId");
        FileSettingStore result = new FileSettingStore(RWTFileSettingStoreFactory.getWorkDir());
        try {
            result.loadById(storeId);
        }
        catch (SettingStoreException sse) {
            ServletLog.log(sse.getMessage(), sse);
        }
        return result;
    }

    private static ServletContext getServletContext() {
        HttpSession session = ContextProvider.getRequest().getSession();
        return session.getServletContext();
    }

    private static File getWorkDir() {
        File result = RWTFileSettingStoreFactory.getWorkDirFromWebXml();
        if (result == null && (result = RWTFileSettingStoreFactory.getWorkDirFromServletContext()) == null) {
            String parent = System.getProperty("java.io.tmpdir");
            result = new File(parent, FileSettingStore.class.getName());
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private static File getWorkDirFromWebXml() {
        String path = RWTFileSettingStoreFactory.getServletContext().getInitParameter("org.eclipse.rwt.service.FileSettingStore.dir");
        return path != null ? new File(path) : null;
    }

    private static File getWorkDirFromServletContext() {
        File parent = (File)RWTFileSettingStoreFactory.getServletContext().getAttribute("javax.servlet.context.tempdir");
        return parent != null ? new File(parent, FileSettingStore.class.getName()) : null;
    }
}

