/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.progress;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.rap.ui.internal.progress.IJobMarker;
import org.eclipse.rap.ui.internal.progress.JobCanceler;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.progress.UIJob;

public class JobManagerAdapter
extends ProgressProvider
implements IJobChangeListener {
    private static JobManagerAdapter _instance;
    private final Map jobs;
    private final ProgressManager defaultProgressManager;
    final Object lock;

    public static synchronized JobManagerAdapter getInstance() {
        if (_instance == null) {
            _instance = new JobManagerAdapter();
        }
        return _instance;
    }

    private JobManagerAdapter() {
        IJobManager jobManager = Job.getJobManager();
        Class<?> clazz = jobManager.getClass();
        try {
            Field jobManagerLock = clazz.getDeclaredField("lock");
            jobManagerLock.setAccessible(true);
            this.lock = jobManagerLock.get(jobManager);
        }
        catch (Throwable throwable) {
            String msg = "Could not initialize synchronization lock.";
            throw new IllegalStateException(msg);
        }
        this.jobs = new HashMap();
        this.defaultProgressManager = new ProgressManager();
        Job.getJobManager().setProgressProvider((ProgressProvider)this);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
    }

    public IProgressMonitor createMonitor(Job job) {
        IProgressMonitor result = null;
        ProgressManager manager = this.findSessionProgressManager(job);
        if (manager != null) {
            result = manager.createMonitor(job);
        }
        return result;
    }

    public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
        IProgressMonitor result = null;
        ProgressManager manager = this.findSessionProgressManager(job);
        if (manager != null) {
            result = manager.createMonitor(job, group, ticks);
        }
        return result;
    }

    public IProgressMonitor createProgressGroup() {
        return this.defaultProgressManager.createProgressGroup();
    }

    public void aboutToRun(IJobChangeEvent event) {
        ProgressManager manager = this.findProgressManager(event.getJob());
        manager.changeListener.aboutToRun(event);
    }

    public void awake(IJobChangeEvent event) {
        ProgressManager manager = this.findProgressManager(event.getJob());
        manager.changeListener.awake(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(final IJobChangeEvent event) {
        final ProgressManager[] manager = new ProgressManager[1];
        Display display = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                manager[0] = this.findProgressManager(event.getJob());
                display = (Display)this.jobs.get(event.getJob());
            }
            finally {
                this.jobs.remove(event.getJob());
            }
        }
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    String id = String.valueOf(event.getJob().hashCode());
                    UICallBackManager.getInstance().deactivateUICallBacksFor(id);
                    manager[0].changeListener.done(event);
                }
            });
        } else {
            event.getJob().cancel();
            manager[0].changeListener.done(event);
        }
    }

    public void running(IJobChangeEvent event) {
        ProgressManager manager = this.findProgressManager(event.getJob());
        manager.changeListener.running(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduled(final IJobChangeEvent event) {
        ProgressManager manager;
        Display display = JobManagerAdapter.findDisplay(event.getJob());
        Object object = this.lock;
        synchronized (object) {
            if (display != null) {
                this.jobs.put(event.getJob(), display);
                Runnable runnable = new Runnable(){

                    public void run() {
                        JobManagerAdapter.this.bindToSession(event.getJob());
                        String id = String.valueOf(event.getJob().hashCode());
                        UICallBackManager.getInstance().activateUICallBacksFor(id);
                    }
                };
                UICallBack.runNonUIThreadWithFakeContext((Display)display, (Runnable)runnable);
            }
            manager = this.findProgressManager(event.getJob());
        }
        manager.changeListener.scheduled(event);
    }

    public void sleeping(IJobChangeEvent event) {
        ProgressManager manager = this.findProgressManager(event.getJob());
        manager.changeListener.sleeping(event);
    }

    private ProgressManager findProgressManager(Job job) {
        ProgressManager result = this.findSessionProgressManager(job);
        if (result == null) {
            result = this.defaultProgressManager;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressManager findSessionProgressManager(Job job) {
        Object object = this.lock;
        synchronized (object) {
            final ProgressManager[] result = new ProgressManager[1];
            Display display = (Display)this.jobs.get(job);
            if (display != null) {
                UICallBack.runNonUIThreadWithFakeContext((Display)display, (Runnable)new Runnable(){

                    public void run() {
                        result[0] = ProgressManager.getInstance();
                    }
                });
                if (result[0] == null) {
                    String msg = "ProgressManager must not be null.";
                    throw new IllegalStateException(msg);
                }
            } else {
                result[0] = null;
            }
            return result[0];
        }
    }

    private static Display findDisplay(Job job) {
        UIJob uiJob;
        Display result = null;
        if (ContextProvider.hasContext()) {
            result = LifeCycleUtil.getSessionDisplay();
        } else if (job instanceof UIJob && (result = (uiJob = (UIJob)job).getDisplay()) == null) {
            String msg = "UIJob " + uiJob.getName() + " cannot be scheduled without an associated display.";
            throw new IllegalStateException(msg);
        }
        return result;
    }

    private void bindToSession(final Job job) {
        final boolean[] jobDone = new boolean[1];
        final ISessionStore session = RWT.getSessionStore();
        HttpSessionBindingListener watchDog = new HttpSessionBindingListener(){

            public void valueBound(HttpSessionBindingEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueUnbound(HttpSessionBindingEvent event) {
                if (!jobDone[0]) {
                    try {
                        this.handleWatchDog(job);
                    }
                    catch (Throwable throwable) {
                        Object object = JobManagerAdapter.this.lock;
                        synchronized (object) {
                            JobManagerAdapter.this.jobs.remove(job);
                        }
                        throw throwable;
                    }
                    Object object = JobManagerAdapter.this.lock;
                    synchronized (object) {
                        JobManagerAdapter.this.jobs.remove(job);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleWatchDog(final Job jobToRemove) {
                Display display = (Display)JobManagerAdapter.this.jobs.get(jobToRemove);
                if (display != null) {
                    UICallBack.runNonUIThreadWithFakeContext((Display)display, (Runnable)new Runnable(){

                        public void run() {
                            jobToRemove.cancel();
                            jobToRemove.addJobChangeListener((IJobChangeListener)new JobCanceler());
                        }
                    });
                }
                try {
                    IJobManager jobManager = Job.getJobManager();
                    Class<?> clazz = jobManager.getClass();
                    Field running = clazz.getDeclaredField("running");
                    running.setAccessible(true);
                    Set set = (Set)running.get(jobManager);
                    Object object = JobManagerAdapter.this.lock;
                    synchronized (object) {
                        set.remove(job);
                        Object[] runningJobs = set.toArray();
                        int i = 0;
                        while (i < runningJobs.length) {
                            Job toCheck = (Job)runningJobs[i];
                            IJobMarker marker = (IJobMarker)toCheck.getAdapter(IJobMarker.class);
                            if (marker != null && marker.canBeRemoved()) {
                                set.remove(toCheck);
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
        };
        final String watchDogHashCode = String.valueOf(watchDog.hashCode());
        session.setAttribute(watchDogHashCode, (Object)watchDog);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                jobDone[0] = true;
                session.removeAttribute(watchDogHashCode);
            }
        });
    }
}

