/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.httpdeployer.repository;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.eclipse.rtp.httpdeployer.internal.AbstractHttpDeployerServlet;
import org.eclipse.rtp.httpdeployer.internal.CommonConstants;
import org.eclipse.rtp.httpdeployer.internal.HttpDeployerUtils;
import org.eclipse.rtp.httpdeployer.internal.RequestResults;
import org.eclipse.rtp.httpdeployer.repository.InvalidRepositoryException;
import org.eclipse.rtp.httpdeployer.repository.RepositoryManager;
import org.eclipse.rtp.httpdeployer.repository.RepositoryModificationResult;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class RepositoryServlet
extends AbstractHttpDeployerServlet {
    private static final long serialVersionUID = -4190823339335383710L;
    private final RepositoryManager repositoryManager;

    public RepositoryServlet(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        URI[] repositories = this.repositoryManager.getRepositories();
        Element root = new Element("repositories");
        URI[] uRIArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI repository = uRIArray[n2];
            Element bundleXml = new Element("repository");
            bundleXml.addContent((Content)new Element("uri").addContent(repository.toString()));
            root.addContent((Content)bundleXml);
            ++n2;
        }
        HttpDeployerUtils.outputDocument(resp, new Document(root));
    }

    @Override
    public Document parseMultipartPostRequest(HttpServletRequest req) throws FileUploadException, IOException {
        RequestResults result = new RequestResults();
        List<FileItem> files = HttpDeployerUtils.parseMultipartRequest(req);
        if (files.size() != 1) {
            throw new FileUploadException("File not found");
        }
        try {
            InputStream repository = files.get(0).getInputStream();
            result.addResult(new RepositoryModificationResult(this.repositoryManager.addRepository(repository).toString(), null, CommonConstants.Action.ADD));
        }
        catch (InvalidRepositoryException e) {
            result.addResult(new RepositoryModificationResult("local", e.getMessage(), CommonConstants.Action.ADD));
        }
        for (FileItem item : files) {
            item.delete();
        }
        return result.getDocument();
    }

    @Override
    public Document parseDeleteRequest(Document request) {
        return this.parseRequest(request, "repository", CommonConstants.Action.REMOVE);
    }

    @Override
    public Document parsePostRequest(Document request) {
        return this.parseRequest(request, "repository", CommonConstants.Action.ADD);
    }

    @Override
    public void handleOperation(RequestResults result, Element currentElement, CommonConstants.Action action) {
        String repositoryPath = currentElement.getChildText("uri");
        try {
            URI repository = new URI(repositoryPath);
            this.performRepositoryAction(repository, action);
            result.addResult(new RepositoryModificationResult(repositoryPath, null, action));
        }
        catch (URISyntaxException e) {
            result.addResult(new RepositoryModificationResult(repositoryPath, e.getMessage(), action));
        }
    }

    private void performRepositoryAction(URI repository, CommonConstants.Action action) {
        if (action.equals((Object)CommonConstants.Action.ADD)) {
            this.repositoryManager.addRepository(repository);
        } else {
            this.repositoryManager.removeRepository(repository);
        }
    }
}

