/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.service.provider.internal.deploy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.InvalidRepositoryException;

public class RepositoryManager {
    private static final String LOCAL_REPOSITORY_PREFIX = "repo_";
    private static final String FILENAME_CONTENT = "content.jar";
    private static final String FILENAME_ARTIFACTS = "artifacts.jar";
    private static final int FILE_BUFFER = 8192;
    private final IProvisioningAgent provisioningAgent;

    public RepositoryManager(IProvisioningAgent provisioningAgent) {
        this.provisioningAgent = provisioningAgent;
    }

    public URI[] getRepositories() {
        IMetadataRepositoryManager metaRepoManager = this.getMetadataRepositoryManager();
        return metaRepoManager.getKnownRepositories(0);
    }

    public List<IMetadataRepository> getMetadataRepositories() throws ProvisionException, OperationCanceledException {
        URI[] knownRepositories;
        ArrayList<IMetadataRepository> result = new ArrayList<IMetadataRepository>();
        IMetadataRepositoryManager metaRepoManager = this.getMetadataRepositoryManager();
        URI[] uRIArray = knownRepositories = metaRepoManager.getKnownRepositories(0);
        int n = knownRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            IMetadataRepository repository = metaRepoManager.loadRepository(uri, null);
            result.add(repository);
            ++n2;
        }
        return result;
    }

    public void addRepository(URI repository) {
        IMetadataRepositoryManager metaRepoManager = this.getMetadataRepositoryManager();
        IArtifactRepositoryManager artiRepoManager = this.getArtifactRepositoryManager();
        metaRepoManager.addRepository(repository);
        artiRepoManager.addRepository(repository);
    }

    public URI addRepository(InputStream inputStream) throws InvalidRepositoryException, FileNotFoundException, IOException {
        ZipInputStream zis = new ZipInputStream(inputStream);
        File repository = this.createLocalRepository(zis);
        URI repositoryURI = repository.toURI();
        this.addRepository(repositoryURI);
        return repositoryURI;
    }

    private File createLocalRepository(ZipInputStream zis) throws InvalidRepositoryException, IOException, FileNotFoundException {
        File repository = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + LOCAL_REPOSITORY_PREFIX + Long.toString(System.nanoTime()));
        repository.mkdirs();
        this.createLocalRepositoryStructure(zis, repository);
        try {
            this.validateLocalRepository(repository);
        }
        catch (InvalidRepositoryException e) {
            FileUtils.deleteDirectory((File)repository);
            throw e;
        }
        return repository;
    }

    public void removeRepository(URI repository) {
        IMetadataRepositoryManager metaRepoManager = this.getMetadataRepositoryManager();
        IArtifactRepositoryManager artiRepoManager = this.getArtifactRepositoryManager();
        metaRepoManager.removeRepository(repository);
        artiRepoManager.removeRepository(repository);
    }

    private void createLocalRepositoryStructure(ZipInputStream zis, File repository) throws IOException, FileNotFoundException {
        ZipEntry currentFile;
        while ((currentFile = zis.getNextEntry()) != null) {
            if (currentFile.isDirectory()) {
                this.createLocalDirectory(repository, currentFile);
                continue;
            }
            this.createLocalFile(zis, repository, currentFile);
        }
    }

    private void createLocalDirectory(File repository, ZipEntry currentFile) {
        File file = new File(String.valueOf(repository.getAbsolutePath()) + File.separator + currentFile.getName());
        file.mkdirs();
    }

    private void createLocalFile(ZipInputStream zis, File repository, ZipEntry currentFile) throws IOException, FileNotFoundException {
        File file = new File(String.valueOf(repository.getAbsolutePath()) + File.separator + currentFile.getName());
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bfos = new BufferedOutputStream(fos, 8192);
        this.saveFileData(zis, bfos);
    }

    private void saveFileData(ZipInputStream zis, BufferedOutputStream bfos) throws IOException {
        int resultLength;
        byte[] data = new byte[8192];
        while ((resultLength = zis.read(data, 0, 8192)) != -1) {
            bfos.write(data, 0, resultLength);
        }
        bfos.flush();
        bfos.close();
    }

    public void validateLocalRepository(File repository) throws InvalidRepositoryException {
        File[] files = repository.listFiles();
        boolean artifactsFound = false;
        boolean contentFound = false;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(FILENAME_ARTIFACTS)) {
                artifactsFound = true;
            } else if (file.getName().equals(FILENAME_CONTENT)) {
                contentFound = true;
            }
            ++n2;
        }
        if (!artifactsFound || !contentFound) {
            throw new InvalidRepositoryException("invalid repository: required files not found");
        }
    }

    public IMetadataRepositoryManager getMetadataRepositoryManager() {
        IMetadataRepositoryManager service = (IMetadataRepositoryManager)this.provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        return service;
    }

    public IArtifactRepositoryManager getArtifactRepositoryManager() {
        IArtifactRepositoryManager service = (IArtifactRepositoryManager)this.provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        return service;
    }

    public void removeLocalRepository(URI repository) throws IOException {
        FileUtils.deleteDirectory((File)new File(repository));
        this.removeRepository(repository);
    }
}

