/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Display;

public class LifeCycleUtil {
    private static final String ATTR_SESSION_DISPLAY = String.valueOf(LifeCycleUtil.class.getName()) + "#sessionDisplay";
    private static final String ATTR_UI_THREAD = String.valueOf(LifeCycleUtil.class.getName()) + "#uiThread";

    public static void setSessionDisplay(Display display) {
        ContextProvider.getSessionStore().setAttribute(ATTR_SESSION_DISPLAY, display);
    }

    public static Display getSessionDisplay() {
        Display result = null;
        if (ContextProvider.hasContext()) {
            ISessionStore sessionStore = ContextProvider.getSessionStore();
            result = LifeCycleUtil.getSessionDisplay(sessionStore);
        }
        return result;
    }

    public static Display getSessionDisplay(ISessionStore sessionStore) {
        return (Display)sessionStore.getAttribute(ATTR_SESSION_DISPLAY);
    }

    public static void setUIThread(ISessionStore sessionStore, IUIThreadHolder threadHolder) {
        sessionStore.setAttribute(ATTR_UI_THREAD, threadHolder);
    }

    public static IUIThreadHolder getUIThread(ISessionStore sessionStore) {
        return (IUIThreadHolder)sessionStore.getAttribute(ATTR_UI_THREAD);
    }

    static boolean isStartup() {
        return LifeCycleUtil.getSessionDisplay() == null;
    }

    private LifeCycleUtil() {
    }
}

