/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class RequestId
implements SerializableCompatibility {
    private static final String ATTR_INSTANCE = String.valueOf(RequestId.class.getName()) + "#instance";
    private static final Integer INITIAL_REQUEST_ID = new Integer(-1);
    static final String REQUEST_COUNTER = "requestCounter";
    private Integer requestId = INITIAL_REQUEST_ID;

    public static RequestId getInstance() {
        HttpSession session = ContextProvider.getSessionStore().getHttpSession();
        RequestId result = (RequestId)session.getAttribute(ATTR_INSTANCE);
        if (result == null) {
            result = new RequestId();
            session.setAttribute(ATTR_INSTANCE, (Object)result);
        }
        return result;
    }

    private RequestId() {
    }

    public boolean isValid() {
        String sentRequestId = ProtocolUtil.readHeadPropertyValue(REQUEST_COUNTER);
        boolean initialRequest = sentRequestId == null;
        boolean invalidVersionState = INITIAL_REQUEST_ID.equals(this.requestId) && sentRequestId != null;
        boolean requestIdEquals = this.requestId.toString().equals(sentRequestId);
        return !invalidVersionState && (initialRequest || requestIdEquals);
    }

    public Integer nextRequestId() {
        this.requestId = new Integer(this.requestId + 1);
        return this.requestId;
    }

    public Integer getCurrentRequestId() {
        return this.requestId;
    }
}

