/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.widgets;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.IServiceHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Synchronizer;

public class ClusteredSynchronizer
extends Synchronizer {
    private final String requestUrl = AsyncExecServiceHandler.createRequestUrl(RWT.getRequest());
    private final String cookies = ClusteredSynchronizer.extractRequestCookies(RWT.getRequest());

    public ClusteredSynchronizer(Display display) {
        super(display);
        AsyncExecServiceHandler.register();
    }

    protected void runnableAdded(Runnable runnable) {
        this.notifyAsyncExecServiceHandler();
    }

    static String extractRequestCookies(HttpServletRequest request) {
        String result = "";
        Cookie[] requestCookies = request.getCookies();
        if (requestCookies != null) {
            Cookie[] cookieArray = requestCookies;
            int n = requestCookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie requestCookie = cookieArray[n2];
                if (result.length() > 0) {
                    result = String.valueOf(result) + "; ";
                }
                result = String.valueOf(result) + requestCookie.getName() + "=" + requestCookie.getValue();
                ++n2;
            }
        }
        return result;
    }

    private void notifyAsyncExecServiceHandler() {
        try {
            this.sendAsyncExecServiceHandlerRequest();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void sendAsyncExecServiceHandlerRequest() throws IOException {
        HttpURLConnection connection = this.createConnection();
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String msg = "AsyncExec service request returned response code " + responseCode;
            throw new IOException(msg);
        }
    }

    private HttpURLConnection createConnection() throws IOException {
        URL url = new URL(this.requestUrl);
        HttpURLConnection result = (HttpURLConnection)url.openConnection();
        if (this.cookies.length() > 0) {
            result.setRequestProperty("Cookie", this.cookies);
        }
        return result;
    }

    static class AsyncExecServiceHandler
    implements IServiceHandler {
        static final String ID = "asyncExecServiceHandler";

        AsyncExecServiceHandler() {
        }

        static void register() {
            AsyncExecServiceHandler serviceHandler = new AsyncExecServiceHandler();
            RWT.getServiceManager().registerServiceHandler(ID, serviceHandler);
        }

        static String createRequestUrl(HttpServletRequest request) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("http://127.0.0.1:");
            buffer.append(request.getServerPort());
            buffer.append(request.getRequestURI());
            buffer.append("?");
            buffer.append("custom_service_handler");
            buffer.append("=");
            buffer.append(ID);
            return buffer.toString();
        }

        public void service() {
        }
    }
}

