/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TypedCTabFolderListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.custom.ctabfolderkit.CTabFolderThemeAdapter;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.WidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTabFolder
extends Composite {
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_SIZE = 18;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int BORDER1_COLOR = 18;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 25;
    public int marginWidth = 0;
    public int marginHeight = 0;
    private transient ICTabFolderAdapter tabFolderAdapter;
    private final IWidgetGraphicsAdapter selectionGraphicsAdapter;
    private final ItemHolder<CTabItem> itemHolder = new ItemHolder<CTabItem>(CTabItem.class);
    private final ControlListener resizeListener;
    private FocusListener focusListener;
    private Menu showMenu;
    int selectedIndex = -1;
    private int firstIndex = -1;
    private boolean mru;
    private int[] priority = new int[0];
    final boolean showClose;
    boolean showUnselectedClose = true;
    boolean showUnselectedImage = true;
    boolean showMax;
    boolean showMin;
    private boolean inDispose;
    boolean minimized;
    boolean maximized;
    boolean onBottom;
    final boolean simple = true;
    boolean single;
    private final Rectangle maxRect = new Rectangle(0, 0, 0, 0);
    private final Rectangle minRect = new Rectangle(0, 0, 0, 0);
    private final Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    private boolean showChevron;
    private int fixedTabHeight = -1;
    int tabHeight = 0;
    int minChars = 20;
    Control topRight;
    private int topRightAlignment = 131072;
    private final Rectangle topRightRect = new Rectangle(0, 0, 0, 0);
    private int xClient;
    private int yClient;
    private final int highlight_margin;
    private int highlight_header;
    private int borderRight;
    private int borderLeft;
    private int borderBottom;
    private int borderTop;
    private Color selectionBackground = null;
    private Color selectionForeground = null;
    private Image selectionBgImage = null;

    public CTabFolder(Composite parent, int style) {
        super(parent, CTabFolder.checkStyle(style));
        super.setLayout(new CTabFolderLayout());
        this.onBottom = (super.getStyle() & 0x400) != 0;
        this.single = (super.getStyle() & 4) != 0;
        this.showClose = (super.getStyle() & 0x40) != 0;
        this.borderLeft = this.borderRight = (style & 0x800) != 0 ? 1 : 0;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        this.highlight_header = (style & 0x800000) != 0 ? 1 : 3;
        this.highlight_margin = (style & 0x800000) != 0 ? 0 : 2;
        this.updateTabHeight(false);
        this.resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                CTabFolder.this.onResize();
            }
        };
        this.addControlListener(this.resizeListener);
        this.registerDisposeListener();
        this.selectionGraphicsAdapter = new WidgetGraphicsAdapter();
    }

    public CTabItem[] getItems() {
        this.checkWidget();
        return (CTabItem[])this.itemHolder.getItems();
    }

    public CTabItem getItem(int index) {
        this.checkWidget();
        return this.itemHolder.getItem(index);
    }

    public CTabItem getItem(Point pt) {
        CTabItem result = null;
        Point size = this.getSize();
        boolean onChevron = this.showChevron && this.chevronRect.contains(pt);
        int itemCount = this.itemHolder.size();
        if (itemCount > 0 && size.x > this.borderLeft + this.borderRight && !onChevron) {
            CTabItem[] items = (CTabItem[])this.itemHolder.getItems();
            int i = 0;
            while (result == null && i < this.priority.length) {
                CTabItem item = items[this.priority[i]];
                Rectangle rect = item.getBounds();
                if (rect.contains(pt)) {
                    result = item;
                }
                ++i;
            }
        }
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public int indexOf(CTabItem item) {
        this.checkWidget();
        return this.itemHolder.indexOf(item);
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index >= 0 && index <= this.itemHolder.size() - 1) {
            if (this.selectedIndex != index) {
                Control oldControl;
                int oldSelectionIndex = this.selectedIndex;
                this.selectedIndex = index;
                this.getItem((int)this.selectedIndex).showing = false;
                Control control = this.getItem(this.selectedIndex).getControl();
                if (control != null && !control.isDisposed()) {
                    control.setBounds(this.getClientArea());
                    control.setVisible(true);
                }
                if (oldSelectionIndex >= 0 && oldSelectionIndex < this.getItemCount() && (oldControl = this.getItem(oldSelectionIndex).getControl()) != null && !oldControl.isDisposed()) {
                    oldControl.setVisible(false);
                }
            }
            this.showItem(this.getSelection());
        }
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.selectedIndex;
    }

    public void setSelection(CTabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        int index = this.itemHolder.indexOf(item);
        this.setSelection(index);
    }

    public CTabItem getSelection() {
        this.checkWidget();
        CTabItem result = null;
        if (this.selectedIndex != -1) {
            result = this.itemHolder.getItem(this.selectedIndex);
        }
        return result;
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    public void showItem(CTabItem item) {
        int index;
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if ((index = this.indexOf(item)) == -1) {
            SWT.error(5);
        }
        int idx = -1;
        int i = 0;
        while (idx == -1 && i < this.priority.length) {
            if (this.priority[i] == index) {
                idx = i;
            }
            ++i;
        }
        if (this.mru) {
            int[] newPriority = new int[this.priority.length];
            System.arraycopy(this.priority, 0, newPriority, 1, idx);
            System.arraycopy(this.priority, idx + 1, newPriority, idx + 1, this.priority.length - idx - 1);
            newPriority[0] = index;
            this.priority = newPriority;
        }
        if (!item.isShowing()) {
            this.updateItems(index);
        }
    }

    public void setMRUVisible(boolean show) {
        this.checkWidget();
        if (this.mru != show) {
            this.mru = show;
            if (!this.mru) {
                int idx = this.firstIndex;
                int next = 0;
                int i = this.firstIndex;
                while (i < this.priority.length) {
                    this.priority[next++] = i++;
                }
                i = 0;
                while (i < idx) {
                    this.priority[next++] = i++;
                }
                this.updateItems();
            }
        }
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    public void setMaximizeVisible(boolean maximizeVisible) {
        this.checkWidget();
        if (this.showMax != maximizeVisible) {
            this.showMax = maximizeVisible;
            this.updateItems();
        }
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public void setMinimizeVisible(boolean minimizeVisible) {
        this.checkWidget();
        if (this.showMin != minimizeVisible) {
            this.showMin = minimizeVisible;
            this.updateItems();
        }
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized != minimized) {
            if (minimized && this.maximized) {
                this.setMaximized(false);
            }
            this.minimized = minimized;
        }
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        if (this.maximized != maximized) {
            if (maximized && this.minimized) {
                this.setMinimized(false);
            }
            this.maximized = maximized;
        }
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    @Override
    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setTabHeight(int height) {
        this.checkWidget();
        if (height < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = height;
        this.updateTabHeight(false);
    }

    public int getTabHeight() {
        this.checkWidget();
        int result = this.fixedTabHeight != -1 ? this.fixedTabHeight : this.tabHeight - 1;
        return result;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public void setMinimumCharacters(int minimumCharacters) {
        this.checkWidget();
        if (minimumCharacters < 0) {
            SWT.error(6);
        }
        if (this.minChars != minimumCharacters) {
            this.minChars = minimumCharacters;
            this.updateItems();
        }
    }

    @Override
    public int getStyle() {
        this.checkWidget();
        int result = super.getStyle();
        result &= 0xFFFFFB7F;
        result |= this.onBottom ? 1024 : 128;
        result &= 0xFFFFFFF9;
        result |= this.single ? 4 : 2;
        if (this.borderLeft != 0) {
            result |= 0x800;
        }
        return result;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public void setSingle(boolean single) {
        this.checkWidget();
        if (this.single != single) {
            this.single = single;
            this.updateItemsWithResizeEvent();
        }
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public void setTabPosition(int position) {
        this.checkWidget();
        if (position != 128 && position != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (position == 1024)) {
            this.onBottom = position == 1024;
            this.borderTop = this.onBottom ? this.borderLeft : 0;
            this.borderBottom = this.onBottom ? 0 : this.borderRight;
            this.updateTabHeight(true);
            this.updateItemsWithResizeEvent();
        }
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderLeft == 1;
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.borderLeft != 1 != !show) {
            this.borderRight = show ? 1 : 0;
            this.borderLeft = this.borderRight;
            this.borderTop = this.onBottom ? this.borderLeft : 0;
            this.borderBottom = this.onBottom ? 0 : this.borderLeft;
            this.updateItemsWithResizeEvent();
        }
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public void setUnselectedImageVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedImage != visible) {
            this.showUnselectedImage = visible;
            this.updateItems();
        }
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public void setUnselectedCloseVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedClose != visible) {
            this.showUnselectedClose = visible;
            this.updateItems();
        }
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        int trimHeight;
        int trimY;
        this.checkWidget();
        int trimX = x - this.marginWidth - this.highlight_margin - this.borderLeft;
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.marginWidth + 2 * this.highlight_margin;
        if (this.minimized) {
            trimY = this.onBottom ? y - this.borderTop : y - this.highlight_header - this.tabHeight - this.borderTop;
            trimHeight = this.borderTop + this.borderBottom + this.tabHeight + this.highlight_header;
        } else {
            trimY = this.onBottom ? y - this.marginHeight - this.highlight_margin - this.borderTop : y - this.marginHeight - this.highlight_header - this.tabHeight - this.borderTop;
            trimHeight = height + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + this.highlight_header + this.highlight_margin;
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionBackground = color;
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        Color result = this.selectionBackground;
        if (result == null) {
            CTabFolderThemeAdapter themeAdapter = (CTabFolderThemeAdapter)this.getAdapter(IThemeAdapter.class);
            result = themeAdapter.getSelectedBackground(this);
        }
        if (result == null) {
            throw new IllegalStateException("Transparent selection background color");
        }
        return result;
    }

    public void setSelectionBackground(Color[] colors, int[] percents) {
        this.setSelectionBackground(colors, percents, false);
    }

    public void setSelectionBackground(Color[] colors, int[] percents, boolean vertical) {
        this.checkWidget();
        if (colors != null) {
            int i = 0;
            while (i < colors.length) {
                if (colors[i] != null && colors[i].isDisposed()) {
                    SWT.error(5);
                }
                ++i;
            }
            if (percents == null || percents.length != colors.length - 1 && percents.length != colors.length - 2) {
                SWT.error(5);
            }
            i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error(5);
                }
                ++i;
            }
        }
        if (colors == null) {
            this.selectionGraphicsAdapter.setBackgroundGradient(null, null, vertical);
            this.setSelectionBackground((Color)null);
        } else {
            int colorsLength = colors.length;
            if (percents.length == colors.length - 2) {
                colorsLength = colors.length - 1;
            }
            Color[] gradientColors = new Color[colorsLength];
            System.arraycopy(colors, 0, gradientColors, 0, colorsLength);
            int[] gradientPercents = new int[gradientColors.length];
            if (gradientColors.length > 0) {
                gradientPercents[0] = 0;
                int i = 1;
                while (i < gradientPercents.length) {
                    gradientPercents[i] = percents[i - 1];
                    ++i;
                }
                this.selectionGraphicsAdapter.setBackgroundGradient(gradientColors, gradientPercents, vertical);
                this.setSelectionBackground(gradientColors[gradientColors.length - 1]);
            }
        }
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        this.selectionBgImage = image;
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        this.selectionForeground = color;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        Color result = this.selectionForeground;
        if (result == null) {
            CTabFolderThemeAdapter themeAdapter = (CTabFolderThemeAdapter)this.getAdapter(IThemeAdapter.class);
            result = themeAdapter.getSelectedForeground(this);
        }
        if (result == null) {
            throw new IllegalStateException("Transparent selection foreground color");
        }
        return result;
    }

    public void setTopRight(Control control) {
        this.checkWidget();
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int alignment) {
        this.checkWidget();
        if (alignment != 131072 && alignment != 4) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(32);
        }
        if (this.topRight != control || this.topRightAlignment != alignment) {
            this.topRight = control;
            this.topRightAlignment = alignment;
            if (this.updateItems()) {
                this.redraw();
            }
        }
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public int getTopRightAlignment() {
        this.checkWidget();
        return this.topRightAlignment;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IItemHolderAdapter.class) {
            result = this.itemHolder;
        } else if (adapter == ICTabFolderAdapter.class) {
            if (this.tabFolderAdapter == null) {
                this.tabFolderAdapter = new CTabFolderAdapter();
            }
            result = this.tabFolderAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return (T)result;
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (font != this.getFont()) {
            super.setFont(font);
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
        }
    }

    @Override
    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    @Override
    public Rectangle getClientArea() {
        Rectangle result;
        this.checkWidget();
        if (this.minimized) {
            result = new Rectangle(this.xClient, this.yClient, 0, 0);
        } else {
            Point size = this.getSize();
            int width = size.x - this.borderLeft - this.borderRight - 2 * this.marginWidth - 2 * this.highlight_margin;
            int height = size.y - this.borderTop - this.borderBottom - 2 * this.marginHeight - this.highlight_margin - this.highlight_header;
            result = new Rectangle(this.xClient, this.yClient, width, height -= this.tabHeight);
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void addCTabFolder2Listener(CTabFolder2Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedCTabFolderListener typedListener = new TypedCTabFolderListener(listener);
        this.addListener(5032, typedListener);
        this.addListener(5033, typedListener);
        this.addListener(5034, typedListener);
        this.addListener(5031, typedListener);
        this.addListener(5035, typedListener);
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(5032, listener);
        this.removeListener(5033, listener);
        this.removeListener(5034, listener);
        this.removeListener(5031, listener);
        this.removeListener(5035, listener);
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int showIndex) {
        CTabItem[] items = (CTabItem[])this.itemHolder.getItems();
        if (!this.single && !this.mru && showIndex != -1) {
            int firstIndex = showIndex;
            if (this.priority[0] < showIndex) {
                int maxWidth = this.getRightItemEdge() - this.borderLeft;
                int width = 0;
                int[] widths = new int[items.length];
                int i = this.priority[0];
                while (i <= showIndex) {
                    widths[i] = items[i].preferredWidth(i == this.selectedIndex, true);
                    if ((width += widths[i]) > maxWidth) break;
                    ++i;
                }
                if (width > maxWidth) {
                    width = 0;
                    i = showIndex;
                    while (i >= 0) {
                        if (widths[i] == 0) {
                            widths[i] = items[i].preferredWidth(i == this.selectedIndex, true);
                        }
                        if ((width += widths[i]) <= maxWidth) {
                            firstIndex = i--;
                            continue;
                        }
                        break;
                    }
                } else {
                    firstIndex = this.priority[0];
                    i = showIndex + 1;
                    while (i < items.length) {
                        widths[i] = items[i].preferredWidth(i == this.selectedIndex, true);
                        if ((width += widths[i]) >= maxWidth) break;
                        ++i;
                    }
                    if (width < maxWidth) {
                        i = this.priority[0] - 1;
                        while (i >= 0) {
                            if (widths[i] == 0) {
                                widths[i] = items[i].preferredWidth(i == this.selectedIndex, true);
                            }
                            if ((width += widths[i]) <= maxWidth) {
                                firstIndex = i--;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (firstIndex != this.priority[0]) {
                int index = 0;
                int i = firstIndex;
                while (i < items.length) {
                    this.priority[index++] = i++;
                }
                i = 0;
                while (i < firstIndex) {
                    this.priority[index++] = i++;
                }
            }
        }
        boolean oldShowChevron = this.showChevron;
        boolean changed = this.setItemSize();
        changed |= this.setItemLocation();
        this.setButtonBounds();
        return changed |= this.showChevron ^ oldShowChevron;
    }

    boolean setItemLocation() {
        int y;
        CTabItem[] items = (CTabItem[])this.itemHolder.getItems();
        boolean changed = false;
        if (items.length == 0) {
            return false;
        }
        Point size = this.getSize();
        int n = y = this.onBottom ? Math.max(this.borderBottom, size.y - this.borderBottom - this.tabHeight) : this.borderTop;
        if (this.single) {
            int defaultX = this.getDisplay().getBounds().width + 10;
            int i = 0;
            while (i < items.length) {
                CTabItem item = items[i];
                if (i == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int oldX = item.x;
                    int oldY = item.y;
                    item.x = this.borderLeft;
                    item.y = y;
                    item.showing = true;
                    if (this.showClose || item.showClose) {
                        item.closeRect.x = this.borderLeft + this.getItemPaddingLeft(true);
                        int n2 = item.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    }
                    if (item.x != oldX || item.y != oldY) {
                        changed = true;
                    }
                } else {
                    item.x = defaultX;
                    item.showing = false;
                }
                ++i;
            }
        } else {
            int rightItemEdge = this.getRightItemEdge();
            int maxWidth = rightItemEdge - this.borderLeft;
            int width = 0;
            int i = 0;
            while (i < this.priority.length) {
                CTabItem item = items[this.priority[i]];
                item.showing = i == 0 ? true : item.width > 0 && (width += item.width) <= maxWidth;
                ++i;
            }
            int x = 0;
            int defaultX = this.getDisplay().getBounds().width + 10;
            this.firstIndex = items.length - 1;
            int i2 = 0;
            while (i2 < items.length) {
                CTabItem item = items[i2];
                if (!item.showing) {
                    if (item.x != defaultX) {
                        changed = true;
                    }
                    item.x = defaultX;
                } else {
                    this.firstIndex = Math.min(this.firstIndex, i2);
                    if (item.x != x || item.y != y) {
                        changed = true;
                    }
                    item.x = x;
                    item.y = y;
                    if (i2 == this.selectedIndex) {
                        int edge = Math.min(item.x + item.width, rightItemEdge);
                        item.closeRect.x = edge - this.getItemPaddingRight(true) - 18;
                    } else {
                        int rightPadding = this.getItemPaddingRight(false);
                        item.closeRect.x = item.x + item.width - rightPadding - 18;
                    }
                    item.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    x += item.width;
                }
                ++i2;
            }
        }
        return changed;
    }

    boolean setItemSize() {
        int[] widths;
        CTabItem[] items = (CTabItem[])this.itemHolder.getItems();
        boolean changed = false;
        if (this.isDisposed()) {
            return changed;
        }
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return changed;
        }
        this.xClient = this.borderLeft + this.marginWidth + this.highlight_margin;
        this.yClient = this.onBottom ? this.borderTop + this.highlight_margin + this.marginHeight : this.borderTop + this.tabHeight + this.highlight_header + this.marginHeight;
        this.showChevron = false;
        if (this.single) {
            this.showChevron = true;
            if (this.selectedIndex != -1) {
                CTabItem tab = items[this.selectedIndex];
                int width = tab.preferredWidth(true, false);
                width = Math.min(width, this.getRightItemEdge() - this.borderLeft);
                if (tab.height != this.tabHeight || tab.width != width) {
                    changed = true;
                    tab.shortenedText = null;
                    tab.shortenedTextWidth = 0;
                    tab.height = this.tabHeight;
                    tab.width = width;
                    tab.closeRect.height = 0;
                    tab.closeRect.width = 0;
                    if (this.showClose || tab.showClose) {
                        tab.closeRect.width = 18;
                        tab.closeRect.height = 18;
                    }
                }
            }
            return changed;
        }
        if (items.length == 0) {
            return changed;
        }
        int tabAreaWidth = size.x - this.borderLeft - this.borderRight - 3;
        if (this.showMin) {
            tabAreaWidth -= 18;
        }
        if (this.showMax) {
            tabAreaWidth -= 18;
        }
        if (this.topRightAlignment == 131072 && this.topRight != null) {
            Point rightSize = this.topRight.computeSize(-1, -1, false);
            tabAreaWidth -= rightSize.x + 3;
        }
        tabAreaWidth = Math.max(0, tabAreaWidth);
        int minWidth = 0;
        int[] minWidths = new int[items.length];
        int i = 0;
        while (i < this.priority.length) {
            int index = this.priority[i];
            minWidths[index] = items[index].preferredWidth(index == this.selectedIndex, true);
            if ((minWidth += minWidths[index]) > tabAreaWidth) break;
            ++i;
        }
        if (minWidth > tabAreaWidth) {
            int index;
            boolean bl = this.showChevron = items.length > 1;
            if (this.showChevron) {
                tabAreaWidth -= 27;
            }
            widths = minWidths;
            int n = index = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (tabAreaWidth < widths[index]) {
                widths[index] = Math.max(0, tabAreaWidth);
            }
        } else {
            int maxWidth = 0;
            int[] maxWidths = new int[items.length];
            int i2 = 0;
            while (i2 < items.length) {
                maxWidths[i2] = items[i2].preferredWidth(i2 == this.selectedIndex, false);
                maxWidth += maxWidths[i2];
                ++i2;
            }
            if (maxWidth <= tabAreaWidth) {
                widths = maxWidths;
            } else {
                int extra = (tabAreaWidth - minWidth) / items.length;
                while (true) {
                    int large = 0;
                    int totalWidth = 0;
                    int i3 = 0;
                    while (i3 < items.length) {
                        if (maxWidths[i3] > minWidths[i3] + extra) {
                            totalWidth += minWidths[i3] + extra;
                            ++large;
                        } else {
                            totalWidth += maxWidths[i3];
                        }
                        ++i3;
                    }
                    if (totalWidth >= tabAreaWidth) {
                        --extra;
                        break;
                    }
                    if (large == 0 || tabAreaWidth - totalWidth < large) break;
                    ++extra;
                }
                widths = new int[items.length];
                int i4 = 0;
                while (i4 < items.length) {
                    widths[i4] = Math.min(maxWidths[i4], minWidths[i4] + extra);
                    ++i4;
                }
            }
        }
        i = 0;
        while (i < items.length) {
            CTabItem tab = items[i];
            int width = widths[i];
            if (tab.height != this.tabHeight || tab.width != width) {
                changed = true;
                tab.shortenedText = null;
                tab.shortenedTextWidth = 0;
                tab.height = this.tabHeight;
                tab.width = width;
                tab.closeRect.height = 0;
                tab.closeRect.width = 0;
                if ((this.showClose || tab.showClose) && (i == this.selectedIndex || this.showUnselectedClose)) {
                    tab.closeRect.width = 18;
                    tab.closeRect.height = 18;
                }
            }
            ++i;
        }
        return changed;
    }

    void setButtonBounds() {
        CTabItem[] items = (CTabItem[])this.itemHolder.getItems();
        Point size = this.getSize();
        this.maxRect.height = 0;
        this.maxRect.width = 0;
        this.maxRect.y = 0;
        this.maxRect.x = 0;
        if (this.showMax) {
            this.maxRect.x = size.x - this.borderRight - 18 - 3;
            if (this.borderRight > 0) {
                ++this.maxRect.x;
            }
            this.maxRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.maxRect.width = 18;
            this.maxRect.height = 18;
        }
        this.minRect.height = 0;
        this.minRect.width = 0;
        this.minRect.y = 0;
        this.minRect.x = 0;
        if (this.showMin) {
            this.minRect.x = size.x - this.borderRight - this.maxRect.width - 18 - 3;
            if (this.borderRight > 0) {
                ++this.minRect.x;
            }
            this.minRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.minRect.width = 18;
            this.minRect.height = 18;
        }
        this.topRightRect.height = 0;
        this.topRightRect.width = 0;
        this.topRightRect.y = 0;
        this.topRightRect.x = 0;
        if (this.topRight != null) {
            switch (this.topRightAlignment) {
                case 4: {
                    CTabItem item;
                    int rightEdge = size.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (this.single) {
                        if (items.length == 0 || this.selectedIndex == -1) {
                            this.topRightRect.x = this.borderLeft + 3;
                            this.topRightRect.width = rightEdge - this.topRightRect.x;
                        } else {
                            item = items[this.selectedIndex];
                            if (item.x + item.width + 7 + 27 >= rightEdge) break;
                            this.topRightRect.x = item.x + item.width + 7 + 27;
                            this.topRightRect.width = rightEdge - this.topRightRect.x;
                        }
                    } else {
                        if (this.showChevron) break;
                        if (items.length == 0) {
                            this.topRightRect.x = this.borderLeft + 3;
                        } else {
                            item = items[items.length - 1];
                            this.topRightRect.x = item.x + item.width;
                        }
                        this.topRightRect.width = Math.max(0, rightEdge - this.topRightRect.x);
                    }
                    this.topRightRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                    break;
                }
                case 131072: {
                    Point topRightSize = this.topRight.computeSize(-1, this.tabHeight, false);
                    int rightEdge = size.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    this.topRightRect.x = rightEdge - topRightSize.x;
                    this.topRightRect.width = topRightSize.x;
                    this.topRightRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                }
            }
            this.topRight.setBounds(this.topRightRect);
        }
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        if (this.single) {
            if (this.selectedIndex == -1 || items.length > 1) {
                this.chevronRect.width = 27;
                this.chevronRect.height = 18;
                int n = this.chevronRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
                if (this.selectedIndex == -1) {
                    this.chevronRect.x = size.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.topRightRect.width - this.chevronRect.width;
                } else {
                    CTabItem item = items[this.selectedIndex];
                    int w = size.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.chevronRect.width;
                    if (this.topRightRect.width > 0) {
                        w -= this.topRightRect.width + 3;
                    }
                    this.chevronRect.x = Math.min(item.x + item.width + 3, w);
                }
                if (this.borderRight > 0) {
                    ++this.chevronRect.x;
                }
            }
        } else if (this.showChevron) {
            this.chevronRect.width = 27;
            this.chevronRect.height = 18;
            int i = 0;
            int lastIndex = -1;
            while (i < this.priority.length && items[this.priority[i]].showing) {
                lastIndex = Math.max(lastIndex, this.priority[i++]);
            }
            if (lastIndex == -1) {
                lastIndex = this.firstIndex;
            }
            CTabItem lastItem = items[lastIndex];
            int w = lastItem.x + lastItem.width + 3;
            this.chevronRect.x = Math.min(w, this.getRightItemEdge());
            this.chevronRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
        }
    }

    boolean updateTabHeight(boolean force) {
        CTabItem[] items = (CTabItem[])this.itemHolder.getItems();
        int style = this.getStyle();
        if (this.fixedTabHeight == 0 && (style & 0x800000) != 0 && (style & 0x800) == 0) {
            this.highlight_header = 0;
        }
        int oldHeight = this.tabHeight;
        if (this.fixedTabHeight != -1) {
            this.tabHeight = this.fixedTabHeight == 0 ? 0 : this.fixedTabHeight + 1;
        } else {
            int tempHeight = 0;
            if (items.length == 0) {
                tempHeight = Graphics.getCharHeight(this.getFont()) + this.getItemPadding((boolean)false).height;
            } else {
                int i = 0;
                while (i < items.length) {
                    tempHeight = Math.max(tempHeight, items[i].preferredHeight(i == this.selectedIndex));
                    ++i;
                }
            }
            this.tabHeight = tempHeight;
        }
        if (!force && this.tabHeight == oldHeight) {
            return false;
        }
        this.notifyListeners(11, new Event());
        return true;
    }

    int getRightItemEdge() {
        int x = this.getSize().x - this.borderRight - 3;
        if (this.showMin) {
            x -= 18;
        }
        if (this.showMax) {
            x -= 18;
        }
        if (this.showChevron) {
            x -= 27;
        }
        if (this.topRight != null && this.topRightAlignment != 4) {
            Point rightSize = this.topRight.computeSize(-1, -1);
            x -= rightSize.x + 3;
        }
        return Math.max(0, x);
    }

    private void updateItemsWithResizeEvent() {
        Rectangle rectBefore = this.getClientArea();
        this.updateItems();
        Rectangle rectAfter = this.getClientArea();
        if (!rectBefore.equals(rectAfter)) {
            this.notifyListeners(11, new Event());
        }
    }

    void onResize() {
        CTabItem item;
        Control control;
        this.updateItems();
        if (this.selectedIndex != -1 && (control = (item = this.itemHolder.getItem(this.selectedIndex)).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
        }
    }

    void onDispose() {
        this.inDispose = true;
        this.removeControlListener(this.resizeListener);
        this.unregisterFocusListener();
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        while (this.itemHolder.size() > 0) {
            CTabItem item = this.itemHolder.getItem(0);
            item.dispose();
            this.itemHolder.remove(item);
        }
    }

    private static int checkStyle(int style) {
        int mask = 41944262;
        int result = style & mask;
        if ((result & 0x80) != 0) {
            result &= 0xFFFFFBFF;
        }
        if ((result & 2) != 0) {
            result &= 0xFFFFFFFB;
        }
        return result;
    }

    private void registerDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CTabFolder.this.onDispose();
                CTabFolder.this.removeDisposeListener(this);
            }
        });
    }

    private void registerFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent event) {
                    CTabFolder.this.onFocus();
                }

                public void focusLost(FocusEvent event) {
                    CTabFolder.this.onFocus();
                }
            };
            this.addFocusListener(this.focusListener);
        }
    }

    private void onFocus() {
        if (this.selectedIndex < 0) {
            this.setSelection(0, true);
        }
        this.unregisterFocusListener();
    }

    private void unregisterFocusListener() {
        if (this.focusListener != null) {
            this.addFocusListener(this.focusListener);
            this.focusListener = null;
        }
    }

    private void showListMenu() {
        CTabItem[] items = this.getItems();
        if (items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this);
        } else {
            MenuItem[] menuItems = this.showMenu.getItems();
            int i = 0;
            while (i < menuItems.length) {
                menuItems[i].dispose();
                ++i;
            }
        }
        int i = 0;
        while (i < items.length) {
            CTabItem tab = items[i];
            if (!tab.showing) {
                MenuItem item = new MenuItem(this.showMenu, 0);
                item.setText(tab.getText());
                item.setImage(tab.getImage());
                item.setData("CTabFolder_showList_Index", tab);
                item.addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        MenuItem menuItem = (MenuItem)event.getSource();
                        int index = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                        CTabFolder.this.setSelection(index, true);
                    }
                });
            }
            ++i;
        }
        if (this.showMenu.getItemCount() > 0) {
            int x = this.chevronRect.x;
            int y = this.chevronRect.y + this.chevronRect.height + 1;
            Point location = this.getDisplay().map(this, null, x, y);
            this.showMenu.setLocation(location.x, location.y);
            this.showMenu.setVisible(true);
        }
    }

    private void setSelection(int index, boolean notify) {
        int oldSelectedIndex = this.selectedIndex;
        this.setSelection(index);
        if (notify && this.selectedIndex != oldSelectedIndex && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getSelection();
            this.notifyListeners(13, event);
        }
    }

    void createItem(CTabItem item, int index) {
        this.itemHolder.insert(item, index);
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        int[] newPriority = new int[this.priority.length + 1];
        int next = 0;
        int priorityIndex = this.priority.length;
        int i = 0;
        while (i < this.priority.length) {
            if (!this.mru && this.priority[i] == index) {
                priorityIndex = next++;
            }
            newPriority[next++] = this.priority[i] >= index ? this.priority[i] + 1 : this.priority[i];
            ++i;
        }
        newPriority[priorityIndex] = index;
        this.priority = newPriority;
        this.updateItems();
        if (this.getItemCount() == 1) {
            this.registerFocusListener();
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            this.redraw();
        }
    }

    void destroyItem(CTabItem item) {
        int index = this.indexOf(item);
        if (!this.inDispose && index != -1) {
            CTabItem[] items = this.getItems();
            if (items.length == 1) {
                this.itemHolder.remove(item);
                this.priority = new int[0];
                this.firstIndex = -1;
                this.selectedIndex = -1;
                Control control = item.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setVisible(false);
                }
                this.setToolTipText(null);
                this.setButtonBounds();
            } else {
                this.itemHolder.remove(item);
                int[] newPriority = new int[this.priority.length - 1];
                int next = 0;
                int i = 0;
                while (i < this.priority.length) {
                    if (this.priority[i] != index) {
                        newPriority[next++] = this.priority[i] > index ? this.priority[i] - 1 : this.priority[i];
                    }
                    ++i;
                }
                this.priority = newPriority;
                if (this.selectedIndex == index) {
                    Control control = item.getControl();
                    this.selectedIndex = -1;
                    int nextSelection = this.mru ? this.priority[0] : Math.max(0, index - 1);
                    this.setSelection(nextSelection, true);
                    if (control != null && !control.isDisposed()) {
                        control.setVisible(false);
                    }
                } else if (this.selectedIndex > index) {
                    --this.selectedIndex;
                }
            }
            this.updateItems();
            if (this.getItemCount() == 0) {
                this.unregisterFocusListener();
            }
        }
    }

    int getItemPaddingLeft(boolean selected) {
        return this.getItemPadding((boolean)selected).x;
    }

    int getItemPaddingRight(boolean selected) {
        Rectangle padding = this.getItemPadding(selected);
        return padding.width - padding.x;
    }

    Rectangle getItemPadding(boolean selected) {
        CTabFolderThemeAdapter themeAdapter = (CTabFolderThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getItemPadding(selected);
    }

    int getItemSpacing(boolean selected) {
        CTabFolderThemeAdapter themeAdapter = (CTabFolderThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getItemSpacing(selected);
    }

    Font getItemFont(boolean selected) {
        CTabFolderThemeAdapter themeAdapter = (CTabFolderThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getItemFont(selected);
    }

    @Override
    public void reskin(int flags) {
        super.reskin(flags);
        CTabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].reskin(flags);
            ++i;
        }
    }

    private final class CTabFolderAdapter
    implements ICTabFolderAdapter {
        private CTabFolderAdapter() {
        }

        public Rectangle getChevronRect() {
            Rectangle rect = CTabFolder.this.chevronRect;
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }

        public boolean getChevronVisible() {
            return CTabFolder.this.showChevron;
        }

        public Rectangle getMinimizeRect() {
            Rectangle rect = CTabFolder.this.minRect;
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }

        public Rectangle getMaximizeRect() {
            Rectangle rect = CTabFolder.this.maxRect;
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }

        public void showListMenu() {
            CTabFolder.this.showListMenu();
        }

        public boolean showItemImage(CTabItem item) {
            return item.showImage();
        }

        public boolean showItemClose(CTabItem item) {
            return item.parent.showClose || item.showClose;
        }

        public String getShortenedItemText(CTabItem item) {
            return item.getShortenedText(item.getParent().getSelection() == item);
        }

        public Color getUserSelectionForeground() {
            return CTabFolder.this.selectionForeground;
        }

        public Color getUserSelectionBackground() {
            return CTabFolder.this.selectionBackground;
        }

        public Image getUserSelectionBackgroundImage() {
            return CTabFolder.this.selectionBgImage;
        }

        public IWidgetGraphicsAdapter getUserSelectionBackgroundGradient() {
            return CTabFolder.this.selectionGraphicsAdapter;
        }
    }
}

