/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] types = this.getTypeIds();
        TransferData[] data = new TransferData[types.length];
        int i = 0;
        while (i < types.length) {
            data[i] = new TransferData();
            data[i].type = types[i];
            ++i;
        }
        return data;
    }

    public boolean isSupportedType(TransferData transferData) {
        boolean result = false;
        if (transferData != null) {
            int[] types = this.getTypeIds();
            int i = 0;
            while (!result && i < types.length) {
                if (transferData.type == types[i]) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!ByteArrayTransfer.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] data = (byte[])object;
        transferData.data = new byte[data.length];
        System.arraycopy(data, 0, transferData.data, 0, data.length);
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] result = null;
        if (this.isSupportedType(transferData) && transferData.data instanceof byte[]) {
            byte[] data = (byte[])transferData.data;
            result = new byte[data.length];
            System.arraycopy(data, 0, result, 0, data.length);
        }
        return result;
    }

    private static boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

