/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.spinnerkit;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public final class SpinnerLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Spinner";
    private static final String[] ALLOWED_STYLES = new String[]{"READ_ONLY", "WRAP", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_DIGITS = "digits";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_DECIMAL_SEPARATOR = "decimalSeparator";
    static final String PROP_SELECTION_LISTENER = "Selection";
    static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final int DEFAULT_DIGITS = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final int DEFAULT_PAGE_INCREMENT = 10;
    private static final String DEFAULT_DECIMAL_SEPARATOR = ".";

    public void preserveValues(Widget widget) {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.preserveValues(spinner);
        WidgetLCAUtil.preserveCustomVariant(spinner);
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_MINIMUM, spinner.getMinimum());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_MAXIMUM, spinner.getMaximum());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_SELECTION, spinner.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_DIGITS, spinner.getDigits());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_INCREMENT, spinner.getIncrement());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_PAGE_INCREMENT, spinner.getPageIncrement());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_TEXT_LIMIT, SpinnerLCA.getTextLimit(spinner));
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_DECIMAL_SEPARATOR, SpinnerLCA.getDecimalSeparator());
        WidgetLCAUtil.preserveListener(spinner, PROP_SELECTION_LISTENER, SpinnerLCA.hasSelectionListener(spinner));
        WidgetLCAUtil.preserveListener(spinner, PROP_DEFAULT_SELECTION_LISTENER, spinner.isListening(14));
    }

    public void readData(Widget widget) {
        Spinner spinner = (Spinner)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PROP_SELECTION);
        if (value != null) {
            spinner.setSelection(NumberFormatUtil.parseInt(value));
        }
        ControlLCAUtil.processSelection(widget, null, false);
        ControlLCAUtil.processDefaultSelection(widget, null);
        ControlLCAUtil.processEvents(spinner);
        ControlLCAUtil.processKeyEvents(spinner);
        ControlLCAUtil.processMenuDetect(spinner);
        WidgetLCAUtil.processHelp(spinner);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(spinner);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(spinner.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(spinner, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.renderChanges(spinner);
        WidgetLCAUtil.renderCustomVariant(spinner);
        SpinnerLCA.renderMinimum(spinner);
        SpinnerLCA.renderMaximum(spinner);
        SpinnerLCA.renderSelection(spinner);
        SpinnerLCA.renderDigits(spinner);
        SpinnerLCA.renderIncrement(spinner);
        SpinnerLCA.renderPageIncrement(spinner);
        SpinnerLCA.renderTextLimit(spinner);
        SpinnerLCA.renderDecimalSeparator(spinner);
        SpinnerLCA.renderListenSelection(spinner);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void renderMinimum(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_MINIMUM, spinner.getMinimum(), 0);
    }

    private static void renderMaximum(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_MAXIMUM, spinner.getMaximum(), 100);
    }

    private static void renderSelection(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_SELECTION, spinner.getSelection(), 0);
    }

    private static void renderDigits(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_DIGITS, spinner.getDigits(), 0);
    }

    private static void renderIncrement(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_INCREMENT, spinner.getIncrement(), 1);
    }

    private static void renderPageIncrement(Spinner spinner) {
        int defValue = 10;
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_PAGE_INCREMENT, spinner.getPageIncrement(), defValue);
    }

    private static void renderTextLimit(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_TEXT_LIMIT, SpinnerLCA.getTextLimit(spinner), null);
    }

    private static void renderDecimalSeparator(Spinner spinner) {
        String defValue = DEFAULT_DECIMAL_SEPARATOR;
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_DECIMAL_SEPARATOR, SpinnerLCA.getDecimalSeparator(), defValue);
    }

    private static void renderListenSelection(Spinner spinner) {
        WidgetLCAUtil.renderListener(spinner, PROP_SELECTION_LISTENER, SpinnerLCA.hasSelectionListener(spinner), false);
        WidgetLCAUtil.renderListener(spinner, PROP_DEFAULT_SELECTION_LISTENER, spinner.isListening(14), false);
    }

    private static Integer getTextLimit(Spinner spinner) {
        Integer result = null;
        int textLimit = spinner.getTextLimit();
        if (textLimit > 0 && textLimit != Integer.MAX_VALUE) {
            result = new Integer(textLimit);
        }
        return result;
    }

    private static String getDecimalSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(RWT.getLocale());
        return String.valueOf(symbols.getDecimalSeparator());
    }

    private static boolean hasSelectionListener(Spinner spinner) {
        return spinner.isListening(13) || spinner.isListening(24);
    }
}

