/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treecolumnkit;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class TreeColumnLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.GridColumn";
    static final String PROP_INDEX = "index";
    static final String PROP_LEFT = "left";
    static final String PROP_WIDTH = "width";
    static final String PROP_RESIZABLE = "resizable";
    static final String PROP_MOVEABLE = "moveable";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_FIXED = "fixed";
    static final String PROP_SELECTION_LISTENER = "Selection";
    private static final int ZERO = 0;
    private static final String DEFAULT_ALIGNMENT = "left";

    public void preserveValues(Widget widget) {
        TreeColumn column = (TreeColumn)widget;
        WidgetLCAUtil.preserveToolTipText(column, column.getToolTipText());
        WidgetLCAUtil.preserveCustomVariant(column);
        ItemLCAUtil.preserve(column);
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_INDEX, TreeColumnLCA.getIndex(column));
        WidgetLCAUtil.preserveProperty((Widget)column, "left", TreeColumnLCA.getLeft(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_WIDTH, column.getWidth());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_RESIZABLE, column.getResizable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_MOVEABLE, column.getMoveable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_ALIGNMENT, TreeColumnLCA.getAlignment(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_FIXED, TreeColumnLCA.isFixed(column));
        WidgetLCAUtil.preserveListener(column, PROP_SELECTION_LISTENER, column.isListening(13));
    }

    public void readData(Widget widget) {
        final TreeColumn column = (TreeColumn)widget;
        String methodName = "resize";
        if (ProtocolUtil.wasCallSend(WidgetUtil.getId(column), methodName)) {
            String width = ProtocolUtil.readCallPropertyValueAsString(WidgetUtil.getId(column), methodName, PROP_WIDTH);
            final int newWidth = NumberFormatUtil.parseInt(width);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    column.setWidth(newWidth);
                }
            });
        }
        methodName = "move";
        if (ProtocolUtil.wasCallSend(WidgetUtil.getId(column), methodName)) {
            String left = ProtocolUtil.readCallPropertyValueAsString(WidgetUtil.getId(column), methodName, "left");
            final int newLeft = NumberFormatUtil.parseInt(left);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    TreeColumnLCA.moveColumn(column, newLeft);
                }
            });
        }
        ControlLCAUtil.processSelection(column, null, false);
        ControlLCAUtil.processDefaultSelection(column, null);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TreeColumn column = (TreeColumn)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(column);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(column.getParent()));
    }

    public void renderChanges(Widget widget) throws IOException {
        TreeColumn column = (TreeColumn)widget;
        WidgetLCAUtil.renderToolTip(column, column.getToolTipText());
        WidgetLCAUtil.renderCustomVariant(column);
        ItemLCAUtil.renderChanges(column);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_INDEX, TreeColumnLCA.getIndex(column), 0);
        WidgetLCAUtil.renderProperty((Widget)column, "left", TreeColumnLCA.getLeft(column), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_WIDTH, column.getWidth(), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_RESIZABLE, column.getResizable(), true);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_MOVEABLE, column.getMoveable(), false);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_ALIGNMENT, TreeColumnLCA.getAlignment(column), "left");
        WidgetLCAUtil.renderProperty((Widget)column, PROP_FIXED, TreeColumnLCA.isFixed(column), false);
        WidgetLCAUtil.renderListener(column, PROP_SELECTION_LISTENER, column.isListening(13), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static int getIndex(TreeColumn column) {
        return column.getParent().indexOf(column);
    }

    static int getLeft(TreeColumn column) {
        ITreeAdapter adapter = column.getParent().getAdapter(ITreeAdapter.class);
        return adapter.getColumnLeft(column);
    }

    private static String getAlignment(TreeColumn column) {
        int alignment = column.getAlignment();
        String result = "left";
        if ((alignment & 0x1000000) != 0) {
            result = "center";
        } else if ((alignment & 0x20000) != 0) {
            result = "right";
        }
        return result;
    }

    private static boolean isFixed(TreeColumn column) {
        ITreeAdapter adapter = column.getParent().getAdapter(ITreeAdapter.class);
        return adapter.isFixedColumn(column);
    }

    static void moveColumn(TreeColumn column, int newLeft) {
        Tree tree = column.getParent();
        int targetColumn = TreeColumnLCA.findMoveTarget(tree, newLeft);
        int[] columnOrder = tree.getColumnOrder();
        int index = tree.indexOf(column);
        int orderIndex = TreeColumnLCA.arrayIndexOf(columnOrder, index);
        columnOrder = TreeColumnLCA.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (TreeColumnLCA.isFixed(column) || TreeColumnLCA.isFixed(tree.getColumn(targetColumn))) {
            targetColumn = tree.indexOf(column);
        }
        if (Arrays.equals(columnOrder = TreeColumnLCA.arrayInsert(columnOrder, targetColumn, index), tree.getColumnOrder())) {
            TreeColumn[] columns = tree.getColumns();
            int i = 0;
            while (i < columns.length) {
                IWidgetAdapter adapter = WidgetUtil.getAdapter(columns[i]);
                adapter.preserve("left", null);
                ++i;
            }
        } else {
            tree.setColumnOrder(columnOrder);
            IWidgetAdapter adapter = WidgetUtil.getAdapter(column);
            adapter.preserve("left", null);
        }
    }

    private static int findMoveTarget(Tree tree, int newLeft) {
        int result = -1;
        TreeColumn[] columns = tree.getColumns();
        int[] columnOrder = tree.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                TreeColumn column = columns[columnOrder[i]];
                int left = TreeColumnLCA.getLeft(column);
                int width = column.getWidth();
                if (TreeColumnLCA.isFixed(column)) {
                    left += TreeColumnLCA.getLeftOffset(column);
                }
                if (newLeft >= left && newLeft <= left + width) {
                    result = i;
                    if (newLeft >= left + width / 2 && result < columns.length && !TreeColumnLCA.isFixed(column)) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static int getLeftOffset(TreeColumn column) {
        ITreeAdapter adapter = column.getParent().getAdapter(ITreeAdapter.class);
        return adapter.getScrollLeft();
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

