/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.groupkit.GroupThemeAdapter;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    private String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        this.text = text;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        GroupThemeAdapter themeAdapter = (GroupThemeAdapter)this.getAdapter(IThemeAdapter.class);
        Rectangle trimmings = themeAdapter.getTrimmingSize(this);
        int border = this.getBorderWidth();
        int width = Math.max(0, bounds.width - trimmings.width - 2 * border);
        int height = Math.max(0, bounds.height - trimmings.height - 2 * border);
        return new Rectangle(trimmings.x, trimmings.y, width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        GroupThemeAdapter themeAdapter = (GroupThemeAdapter)this.getAdapter(IThemeAdapter.class);
        Rectangle trimmings = themeAdapter.getTrimmingSize(this);
        int border = this.getBorderWidth();
        return super.computeTrim(x - trimmings.x - border, y - trimmings.y - border, width + trimmings.width + 2 * border, height + trimmings.height + 2 * border);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point result = super.computeSize(wHint, hHint, changed);
        int length = this.text.length();
        if (length != 0) {
            Font font = this.getFont();
            Point stringExtent = Graphics.stringExtent(font, this.text);
            GroupThemeAdapter themeAdapter = (GroupThemeAdapter)this.getAdapter(IThemeAdapter.class);
            Rectangle headTrimmings = themeAdapter.getHeaderTrimmingSize(this);
            int headerWidth = stringExtent.x + headTrimmings.width;
            result.x = Math.max(result.x, headerWidth);
        }
        return result;
    }

    String getNameText() {
        return this.getText();
    }

    private static int checkStyle(int style) {
        int result = style | 0x80000;
        return result & 0xFFFFFCFF;
    }
}

