/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.rtp.configurator.console.CommandDelegate;
import org.eclipse.rtp.configurator.console.CommandDelegateImpl;

public class RTCommandProvider
implements CommandProvider {
    public static final String FAIL = "fail";
    private static final String INSTALL = "install";
    private static final String UPDATE = "update";
    private static final String REMOVE = "remove";
    private static final String SEARCH = "search";
    private static final String SHOW = "show";
    private static final String LIST = "list";
    private static final String UPDATE_WORLD = "update-world";
    private final CommandDelegate delegate;

    public RTCommandProvider(CommandDelegate delegate) {
        this.delegate = delegate;
    }

    public RTCommandProvider() {
        this.delegate = new CommandDelegateImpl();
    }

    public Object _rt(CommandInterpreter interpreter) {
        String operation = interpreter.nextArgument();
        String result = null;
        if (operation != null) {
            this.distributeOperations(operation, interpreter);
        } else {
            result = FAIL;
        }
        return result;
    }

    private void distributeOperations(String operation, CommandInterpreter interpreter) {
        List<String> parameter = this.extractParameter(interpreter);
        if (operation.equals(INSTALL)) {
            this.delegate.install(parameter);
        } else if (operation.equals(UPDATE)) {
            this.delegate.update(parameter);
        } else if (operation.equals(SEARCH)) {
            this.delegate.search(parameter);
        } else if (operation.equals(SHOW)) {
            this.delegate.show(parameter);
        } else if (operation.equals(LIST)) {
            this.delegate.list();
        } else if (operation.equals(UPDATE_WORLD)) {
            this.delegate.updateWorld();
        } else if (operation.equals(REMOVE)) {
            this.delegate.remove(parameter);
        } else {
            this.delegate.unsupportedOperation(operation);
        }
    }

    private List<String> extractParameter(CommandInterpreter interpreter) {
        String argument;
        ArrayList<String> parameter = new ArrayList<String>();
        while ((argument = interpreter.nextArgument()) != null) {
            parameter.add(argument);
        }
        return parameter;
    }

    public String getHelp() {
        return this.delegate.getHelp();
    }
}

