/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.engine;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.engine.PostDeserialization;
import org.eclipse.rap.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rap.rwt.service.ISessionStore;

public class RWTClusterSupport
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RWTClusterSupport.beforeService(request);
        chain.doFilter(request, response);
        RWTClusterSupport.afterService(request);
    }

    public void destroy() {
    }

    private static HttpSession getHttpSession(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return httpRequest.getSession(false);
    }

    private static void beforeService(ServletRequest request) {
        HttpSession httpSession = RWTClusterSupport.getHttpSession(request);
        if (httpSession != null) {
            RWTClusterSupport.beforeService(httpSession);
        }
    }

    private static void beforeService(HttpSession httpSession) {
        SessionStoreImpl sessionStore = SessionStoreImpl.getInstanceFromSession(httpSession);
        if (sessionStore != null) {
            sessionStore.attachHttpSession(httpSession);
            RWTClusterSupport.attachApplicationContext(sessionStore);
            PostDeserialization.runProcessors(sessionStore);
        }
    }

    private static void attachApplicationContext(ISessionStore sessionStore) {
        ServletContext servletContext = sessionStore.getHttpSession().getServletContext();
        ApplicationContext applicationContext = ApplicationContextUtil.get(servletContext);
        ApplicationContextUtil.set(sessionStore, applicationContext);
    }

    private static void afterService(ServletRequest request) {
        HttpSession httpSession = RWTClusterSupport.getHttpSession(request);
        if (httpSession != null) {
            RWTClusterSupport.afterService(httpSession);
        }
    }

    private static void afterService(HttpSession httpSession) {
        RWTClusterSupport.markSessionChanged(httpSession);
    }

    private static void markSessionChanged(HttpSession httpSession) {
        SessionStoreImpl sessionStore = SessionStoreImpl.getInstanceFromSession(httpSession);
        SessionStoreImpl.attachInstanceToSession(httpSession, sessionStore);
    }
}

