/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.FakeContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.IPhase;
import org.eclipse.rap.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseExecutor;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseListenerManager;
import org.eclipse.rap.rwt.internal.lifecycle.PrepareUIRoot;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rap.rwt.internal.lifecycle.ReadData;
import org.eclipse.rap.rwt.internal.lifecycle.Render;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public class SimpleLifeCycle
extends LifeCycle {
    private final ApplicationContext applicationContext;
    private final PhaseListenerManager phaseListenerManager;
    private final IPhase[] phases;

    public SimpleLifeCycle(ApplicationContext applicationContext) {
        super(applicationContext);
        this.applicationContext = applicationContext;
        this.phaseListenerManager = new PhaseListenerManager(this);
        this.phases = new IPhase[]{new PrepareUIRoot(applicationContext), new ReadData(), new ProcessAction(), new Render()};
    }

    public void execute() throws IOException {
        this.installSessionShutdownAdapter();
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        SimpleLifeCycle.attachThread(LifeCycleUtil.getSessionDisplay(), sessionStore);
        try {
            SessionDisplayPhaseExecutor phaseExecutor = new SessionDisplayPhaseExecutor(this.phaseListenerManager, this.phases);
            phaseExecutor.execute(PhaseId.PREPARE_UI_ROOT);
        }
        finally {
            SimpleLifeCycle.detachThread(LifeCycleUtil.getSessionDisplay(), sessionStore);
        }
    }

    public void requestThreadExec(Runnable runnable) {
        runnable.run();
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        this.phaseListenerManager.addPhaseListener(phaseListener);
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        this.phaseListenerManager.removePhaseListener(phaseListener);
    }

    public void sleep() {
        String msg = "Display#sleep() not supported in current operation mode.";
        throw new UnsupportedOperationException(msg);
    }

    private void installSessionShutdownAdapter() {
        SessionStoreImpl sessionStore = (SessionStoreImpl)ContextProvider.getSessionStore();
        if (sessionStore.getShutdownAdapter() == null) {
            sessionStore.setShutdownAdapter(new SimpleSessionShutdownAdapter(this.applicationContext));
        }
    }

    private static void attachThread(Display display, ISessionStore sessionStore) {
        if (display != null) {
            IDisplayAdapter displayAdapter = display.getAdapter(IDisplayAdapter.class);
            displayAdapter.attachThread();
        }
        SimpleUIThreadHolder uiThreadHolder = new SimpleUIThreadHolder(Thread.currentThread());
        LifeCycleUtil.setUIThread(sessionStore, uiThreadHolder);
    }

    private static void detachThread(Display display, ISessionStore sessionStore) {
        if (display != null) {
            IDisplayAdapter displayAdapter = display.getAdapter(IDisplayAdapter.class);
            displayAdapter.detachThread();
        }
        LifeCycleUtil.setUIThread(sessionStore, null);
    }

    private static class SessionDisplayPhaseExecutor
    extends PhaseExecutor {
        SessionDisplayPhaseExecutor(PhaseListenerManager phaseListenerManager, IPhase[] phases) {
            super(phaseListenerManager, phases);
        }

        Display getDisplay() {
            return LifeCycleUtil.getSessionDisplay();
        }
    }

    private static class SimpleSessionShutdownAdapter
    implements ISessionShutdownAdapter {
        private final ApplicationContext applicationContext;
        private Runnable shutdownCallback;
        private ISessionStore sessionStore;

        SimpleSessionShutdownAdapter(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public void setShutdownCallback(Runnable shutdownCallback) {
            this.shutdownCallback = shutdownCallback;
        }

        public void setSessionStore(ISessionStore sessionStore) {
            this.sessionStore = sessionStore;
        }

        public void interceptShutdown() {
            final Display display = LifeCycleUtil.getSessionDisplay(this.sessionStore);
            FakeContextUtil.runNonUIThreadWithFakeContext(display, new Runnable(){

                public void run() {
                    if (SimpleSessionShutdownAdapter.isDisplayActive(display) && SimpleSessionShutdownAdapter.this.isApplicationContextActive()) {
                        SimpleLifeCycle.attachThread(display, SimpleSessionShutdownAdapter.this.sessionStore);
                        CurrentPhase.set(PhaseId.PROCESS_ACTION);
                        display.dispose();
                    }
                    SimpleSessionShutdownAdapter.this.shutdownCallback.run();
                }
            });
        }

        public void processShutdown() {
            throw new UnsupportedOperationException();
        }

        private static boolean isDisplayActive(Display display) {
            return display != null && !display.isDisposed();
        }

        private boolean isApplicationContextActive() {
            return this.applicationContext != null && this.applicationContext.isActive();
        }
    }

    private static class SimpleUIThreadHolder
    implements IUIThreadHolder {
        private final Thread thread;

        public SimpleUIThreadHolder(Thread thread) {
            this.thread = thread;
        }

        public void updateServiceContext() {
            throw new UnsupportedOperationException();
        }

        public void terminateThread() {
            throw new UnsupportedOperationException();
        }

        public void switchThread() {
            throw new UnsupportedOperationException();
        }

        public void setServiceContext(ServiceContext serviceContext) {
            throw new UnsupportedOperationException();
        }

        public Thread getThread() {
            return this.thread;
        }

        public Object getLock() {
            throw new UnsupportedOperationException();
        }
    }
}

