/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.rap.rwt.service.ISessionStore;

public class UICallBackRenderer {
    public static final String UI_CALLBACK_ID = "rwt.client.UICallBack";
    private static final String PROP_ACTIVE = "active";
    private static final String ATTR_PRESERVED_ACTIVATION = String.valueOf(UICallBackRenderer.class.getName()) + ".preservedActivation";
    private final ISessionStore sessionStore = ContextProvider.getSessionStore();
    private final UICallBackManager callbackManager = UICallBackManager.getInstance();

    UICallBackRenderer() {
    }

    void render() {
        boolean activation = this.callbackManager.needsActivation();
        if (this.mustRender(activation)) {
            UICallBackRenderer.renderActivation(activation);
            this.preserveActivation(activation);
        }
    }

    private boolean mustRender(boolean activation) {
        boolean result = this.hasChanged(activation);
        if (result && !activation && this.callbackManager.hasRunnables()) {
            result = false;
        }
        return result;
    }

    private boolean hasChanged(boolean activation) {
        return activation ^ this.getPreservedActivation();
    }

    private void preserveActivation(boolean activation) {
        this.sessionStore.setAttribute(ATTR_PRESERVED_ACTIVATION, activation);
    }

    private boolean getPreservedActivation() {
        Boolean preserved = (Boolean)this.sessionStore.getAttribute(ATTR_PRESERVED_ACTIVATION);
        return preserved != null ? preserved : false;
    }

    private static void renderActivation(boolean activation) {
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        writer.appendSet(UI_CALLBACK_ID, PROP_ACTIVE, activation);
    }
}

