/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.application;

import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.application.ApplicationImpl;
import org.eclipse.rap.rwt.internal.service.ApplicationStoreImpl;
import org.eclipse.rap.rwt.internal.service.ServiceManager;
import org.eclipse.rap.rwt.internal.textsize.MeasurementListener;
import org.eclipse.rap.rwt.internal.uicallback.UICallBackServiceHandler;
import org.eclipse.rap.rwt.service.IApplicationStore;
import org.eclipse.rap.rwt.service.RWTFileSettingStoreFactory;

class ApplicationContextConfigurator {
    private final ApplicationConfiguration configuration;
    private final ServletContext servletContext;

    ApplicationContextConfigurator(ApplicationConfiguration configuration, ServletContext servletContext) {
        this.configuration = configuration;
        this.servletContext = servletContext;
    }

    void configure(ApplicationContext applicationContext) {
        this.createDefaultTheme(applicationContext);
        this.configureCustomSettings(applicationContext);
        this.configureInternalSettings(applicationContext);
    }

    void reset(ApplicationContext applicationContext) {
        this.resetSubSystems(applicationContext);
        this.resetApplicationStore(applicationContext);
    }

    private void configureCustomSettings(ApplicationContext applicationContext) {
        ApplicationImpl application = new ApplicationImpl(applicationContext, this.configuration);
        this.configuration.configure(application);
    }

    private void configureInternalSettings(ApplicationContext applicationContext) {
        this.setContextDirectory(applicationContext);
        this.addInternalPhaseListeners(applicationContext);
        this.addInternalServiceHandlers(applicationContext);
        this.setInternalSettingStoreFactory(applicationContext);
    }

    private void setContextDirectory(ApplicationContext applicationContext) {
        String location = (String)this.servletContext.getAttribute("resource_root_location");
        if (location == null) {
            location = this.servletContext.getRealPath("/");
        }
        applicationContext.getResourceDirectory().configure(location);
    }

    private void resetApplicationStore(ApplicationContext applicationContext) {
        IApplicationStore storeInstance = applicationContext.getApplicationStore();
        ApplicationStoreImpl applicationStore = (ApplicationStoreImpl)storeInstance;
        applicationStore.reset();
    }

    private void resetSubSystems(ApplicationContext applicationContext) {
        applicationContext.getEntryPointManager().deregisterAll();
        applicationContext.getPhaseListenerRegistry().removeAll();
        applicationContext.getResourceRegistry().clear();
        applicationContext.getSettingStoreManager().deregisterFactory();
        this.resetContextDirectory(applicationContext);
    }

    private void resetContextDirectory(ApplicationContext applicationContext) {
        applicationContext.getResourceDirectory().reset();
    }

    private void addInternalPhaseListeners(ApplicationContext applicationContext) {
        applicationContext.getPhaseListenerRegistry().add(new MeasurementListener());
    }

    private void addInternalServiceHandlers(ApplicationContext applicationContext) {
        ServiceManager serviceManager = applicationContext.getServiceManager();
        String uiCallBackId = "org.eclipse.rap.uicallback";
        serviceManager.registerServiceHandler(uiCallBackId, new UICallBackServiceHandler());
    }

    private void setInternalSettingStoreFactory(ApplicationContext applicationContext) {
        if (!applicationContext.getSettingStoreManager().hasFactory()) {
            applicationContext.getSettingStoreManager().register(new RWTFileSettingStoreFactory());
        }
    }

    private void createDefaultTheme(ApplicationContext applicationContext) {
        applicationContext.getThemeManager().initialize();
    }
}

