/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.widgets;

import java.util.HashMap;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.internal.application.RWTFactory;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.PhaseEvent;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.service.SessionStoreEvent;
import org.eclipse.rap.rwt.service.SessionStoreListener;
import org.eclipse.swt.widgets.Display;

public final class JavaScriptExecutorImpl
implements JavaScriptExecutor,
PhaseListener,
SessionStoreListener {
    private static final String JSEXECUTOR_TYPE = "rwt.client.JavaScriptExecutor";
    private static final String PARAM_CONTENT = "content";
    private static final String METHOD_EXECUTE = "execute";
    private final Display display = Display.getCurrent();
    private final StringBuilder codeBuilder = new StringBuilder();

    public JavaScriptExecutorImpl() {
        RWTFactory.getLifeCycleFactory().getLifeCycle().addPhaseListener(this);
        RWT.getSessionStore().addSessionStoreListener(this);
    }

    public void execute(String code) {
        this.codeBuilder.append(code);
    }

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        String content = this.codeBuilder.toString().trim();
        if (this.display == LifeCycleUtil.getSessionDisplay() && content.length() > 0) {
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PARAM_CONTENT, content);
            protocolWriter.appendCall(JSEXECUTOR_TYPE, METHOD_EXECUTE, properties);
            this.codeBuilder.setLength(0);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER;
    }

    public void beforeDestroy(SessionStoreEvent event) {
        RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener(this);
    }
}

