/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.events;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.IServiceStore;
import org.eclipse.swt.internal.events.EventTypes;
import org.eclipse.swt.widgets.Event;

public class EventList {
    private static final String ATTR_EVENT_LIST = String.valueOf(EventList.class.getName()) + "#instance";
    private final List<Event> events = new LinkedList<Event>();
    private final EventComparator eventComparator;

    public static EventList getInstance() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        EventList result = (EventList)serviceStore.getAttribute(ATTR_EVENT_LIST);
        if (result == null) {
            result = new EventList();
            serviceStore.setAttribute(ATTR_EVENT_LIST, result);
        }
        return result;
    }

    EventList() {
        this(EventTypes.EVENT_ORDER);
    }

    EventList(int[] eventOrder) {
        this.eventComparator = new EventComparator(eventOrder);
    }

    public void add(Event event) {
        this.events.add(event);
    }

    public void remove(Event event) {
        ParamCheck.notNull(event, "event");
        this.events.remove(event);
    }

    public Event[] getAll() {
        Event[] result = this.events.toArray(new Event[this.events.size()]);
        Arrays.sort(result, this.eventComparator);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventComparator
    implements Comparator<Event> {
        private final int[] eventOrder;

        public EventComparator(int[] eventOrder) {
            this.eventOrder = eventOrder;
        }

        @Override
        public int compare(Event event1, Event event2) {
            int index2;
            int index1 = this.getIndex(event1);
            int result = index1 - (index2 = this.getIndex(event2));
            if (result == 0) {
                result = event1.time - event2.time;
            }
            return result;
        }

        private int getIndex(Event event) {
            int result = Integer.MAX_VALUE;
            int i = 0;
            while (result == Integer.MAX_VALUE && i < this.eventOrder.length) {
                if (this.eventOrder[i] == event.type) {
                    result = i;
                }
                ++i;
            }
            return result;
        }
    }
}

