/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.canvaskit;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class GCOperationWriter {
    private final Control control;
    private boolean initialized;
    private ArrayList<Object[]> operations;
    private int lineWidth;
    private RGB foreground;
    private RGB background;

    GCOperationWriter(Control control) {
        this.control = control;
    }

    void initialize() {
        if (!this.initialized) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(GCOperationWriter.getGC(this.control));
            Point size = this.control.getSize();
            this.lineWidth = 1;
            this.foreground = this.control.getForeground().getRGB();
            this.background = this.control.getBackground().getRGB();
            HashMap<String, Object> arg = new HashMap<String, Object>();
            arg.put("width", new Integer(size.x));
            arg.put("height", new Integer(size.y));
            arg.put("font", ProtocolUtil.getFontAsArray(this.control.getFont()));
            arg.put("fillStyle", ProtocolUtil.getColorAsArray(this.background, false));
            arg.put("strokeStyle", ProtocolUtil.getColorAsArray(this.foreground, false));
            clientObject.call("init", arg);
            this.operations = new ArrayList();
            this.initialized = true;
        }
    }

    void write(GCOperation operation) {
        this.initialize();
        if (operation instanceof GCOperation.DrawLine) {
            this.drawLine((GCOperation.DrawLine)operation);
        } else if (operation instanceof GCOperation.DrawPoint) {
            this.drawPoint((GCOperation.DrawPoint)operation);
        } else if (operation instanceof GCOperation.DrawRoundRectangle) {
            this.drawRoundRectangle((GCOperation.DrawRoundRectangle)operation);
        } else if (operation instanceof GCOperation.FillGradientRectangle) {
            this.fillGradientRectangle((GCOperation.FillGradientRectangle)operation);
        } else if (operation instanceof GCOperation.DrawRectangle) {
            this.drawRectangle((GCOperation.DrawRectangle)operation);
        } else if (operation instanceof GCOperation.DrawArc) {
            this.drawArc((GCOperation.DrawArc)operation);
        } else if (operation instanceof GCOperation.DrawPolyline) {
            this.drawPolyline((GCOperation.DrawPolyline)operation);
        } else if (operation instanceof GCOperation.DrawImage) {
            this.drawImage((GCOperation.DrawImage)operation);
        } else if (operation instanceof GCOperation.DrawText) {
            this.drawText((GCOperation.DrawText)operation);
        } else if (operation instanceof GCOperation.SetProperty) {
            this.setProperty((GCOperation.SetProperty)operation);
        } else {
            String name = operation.getClass().getName();
            throw new IllegalArgumentException("Unsupported GCOperation: " + name);
        }
    }

    void render() {
        if (this.operations != null) {
            Object[] array = this.operations.toArray();
            if (array.length > 0) {
                IClientObject clientObject = ClientObjectFactory.getClientObject(GCOperationWriter.getGC(this.control));
                HashMap<String, Object> arg = new HashMap<String, Object>();
                arg.put("operations", array);
                clientObject.call("draw", arg);
            }
            this.operations = null;
        }
    }

    private void drawLine(GCOperation.DrawLine operation) {
        float offset = this.getOffset(false);
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("moveTo", (float)operation.x1 + offset, (float)operation.y1 + offset);
        this.addClientOperation("lineTo", (float)operation.x2 + offset, (float)operation.y2 + offset);
        this.addClientOperation("stroke", new float[0]);
    }

    private void drawPoint(GCOperation.DrawPoint operation) {
        float x = operation.x;
        float y = operation.y;
        this.addClientOperation("save", new float[0]);
        this.addToOperations("fillStyle", ProtocolUtil.getColorAsArray(this.foreground, false));
        this.addClientOperation("lineWidth", 1.0f);
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("rect", x, y, 1.0f, 1.0f);
        this.addClientOperation("fill", new float[0]);
        this.addClientOperation("restore", new float[0]);
    }

    private void drawRectangle(GCOperation.DrawRectangle operation) {
        float offset = this.getOffset(operation.fill);
        float x = (float)operation.x + offset;
        float y = (float)operation.y + offset;
        float width = operation.width;
        float height = operation.height;
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("rect", x, y, width, height);
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void fillGradientRectangle(GCOperation.FillGradientRectangle operation) {
        boolean vertical = operation.vertical;
        float width = operation.width;
        float height = operation.height;
        float x1 = operation.x;
        float y1 = operation.y;
        boolean swapColors = false;
        if (width < 0.0f) {
            x1 += width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0.0f) {
            y1 += height;
            if (vertical) {
                swapColors = true;
            }
        }
        RGB startColor = swapColors ? this.background : this.foreground;
        RGB endColor = swapColors ? this.foreground : this.background;
        float x2 = vertical ? x1 : x1 + Math.abs(width);
        float y2 = vertical ? y1 + Math.abs(height) : y1;
        this.addClientOperation("save", new float[0]);
        this.addClientOperation("createLinearGradient", x1, y1, x2, y2);
        this.addToOperations("addColorStop", 0, ProtocolUtil.getColorAsArray(startColor, false));
        this.addToOperations("addColorStop", 1, ProtocolUtil.getColorAsArray(endColor, false));
        this.addClientOperation("fillStyle", "linearGradient", new float[0]);
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("rect", x1, y1, width, height);
        this.addClientOperation("fill", new float[0]);
        this.addClientOperation("restore", new float[0]);
    }

    private void drawRoundRectangle(GCOperation.DrawRoundRectangle operation) {
        float offset = this.getOffset(operation.fill);
        float x = (float)operation.x + offset;
        float y = (float)operation.y + offset;
        float w = operation.width;
        float h = operation.height;
        float rx = (float)operation.arcWidth / 2.0f + 1.0f;
        float ry = (float)operation.arcHeight / 2.0f + 1.0f;
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("moveTo", x, y + ry);
        this.addClientOperation("lineTo", x, y + h - ry);
        this.addClientOperation("quadraticCurveTo", x, y + h, x + rx, y + h);
        this.addClientOperation("lineTo", x + w - rx, y + h);
        this.addClientOperation("quadraticCurveTo", x + w, y + h, x + w, y + h - ry);
        this.addClientOperation("lineTo", x + w, y + ry);
        this.addClientOperation("quadraticCurveTo", x + w, y, x + w - rx, y);
        this.addClientOperation("lineTo", x + rx, y);
        this.addClientOperation("quadraticCurveTo", x, y, x, y + ry);
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void drawArc(GCOperation.DrawArc operation) {
        double factor = Math.PI / 180;
        float offset = this.getOffset(operation.fill);
        float rx = operation.width / 2;
        float ry = operation.height / 2;
        float cx = (float)operation.x + rx + offset;
        float cy = (float)operation.y + ry + offset;
        float startAngle = this.round((double)operation.startAngle * factor * -1.0, 4);
        float arcAngle = this.round((double)operation.arcAngle * factor * -1.0, 4);
        this.addClientOperation("beginPath", new float[0]);
        this.addToOperations("ellipse", new Float(cx), new Float(cy), new Float(rx), new Float(ry), new Float(0.0f), new Float(startAngle), new Float(startAngle + arcAngle), arcAngle < 0.0f ? Boolean.TRUE : Boolean.FALSE);
        if (operation.fill) {
            this.addClientOperation("lineTo", cx, cy);
        }
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void drawPolyline(GCOperation.DrawPolyline operation) {
        int[] points = operation.points;
        float offset = this.getOffset(operation.fill);
        this.addClientOperation("beginPath", new float[0]);
        int i = 0;
        while (i < points.length) {
            if (i == 0) {
                this.addClientOperation("moveTo", (float)points[i] + offset, (float)points[i + 1] + offset);
            } else {
                this.addClientOperation("lineTo", (float)points[i] + offset, (float)points[i + 1] + offset);
            }
            i += 2;
        }
        if (operation.close && points.length > 1) {
            this.addClientOperation("lineTo", (float)points[0] + offset, (float)points[1] + offset);
        }
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void drawImage(GCOperation.DrawImage operation) {
        String path = ImageFactory.getImagePath(operation.image);
        if (operation.simple) {
            this.addClientOperation("drawImage", path, operation.destX, operation.destY);
        } else {
            this.addClientOperation("drawImage", path, operation.srcX, operation.srcY, operation.srcWidth, operation.srcHeight, operation.destX, operation.destY, operation.destWidth, operation.destHeight);
        }
    }

    private void drawText(GCOperation.DrawText operation) {
        boolean fill = (operation.flags & 1) == 0;
        boolean drawMnemonic = (operation.flags & 8) != 0;
        boolean drawDelemiter = (operation.flags & 2) != 0;
        boolean drawTab = (operation.flags & 4) != 0;
        Object[] objects = new Object[]{fill ? "fillText" : "strokeText", operation.text, drawMnemonic, drawDelemiter, drawTab};
        this.addClientOperation(objects, new float[]{operation.x, operation.y});
    }

    private void setProperty(GCOperation.SetProperty operation) {
        Object value;
        String name;
        block0 : switch (operation.id) {
            case 0: {
                name = "strokeStyle";
                this.foreground = (RGB)operation.value;
                value = ProtocolUtil.getColorAsArray(this.foreground, false);
                break;
            }
            case 1: {
                name = "fillStyle";
                this.background = (RGB)operation.value;
                value = ProtocolUtil.getColorAsArray(this.background, false);
                break;
            }
            case 2: {
                float alpha = ((Integer)operation.value).floatValue();
                float globalAlpha = this.round(alpha / 255.0f, 2);
                name = "globalAlpha";
                value = new Float(globalAlpha);
                break;
            }
            case 3: {
                name = "lineWidth";
                int width = (Integer)operation.value;
                width = width < 1 ? 1 : width;
                value = new Integer(width);
                this.lineWidth = width;
                break;
            }
            case 4: {
                name = "lineCap";
                switch ((Integer)operation.value) {
                    default: {
                        value = "butt";
                        break block0;
                    }
                    case 2: {
                        value = "round";
                        break block0;
                    }
                    case 3: 
                }
                value = "square";
                break;
            }
            case 5: {
                name = "lineJoin";
                switch ((Integer)operation.value) {
                    default: {
                        value = "bevel";
                        break block0;
                    }
                    case 1: {
                        value = "miter";
                        break block0;
                    }
                    case 2: 
                }
                value = "round";
                break;
            }
            case 6: {
                name = "font";
                value = ProtocolUtil.getFontAsArray((FontData)operation.value);
                break;
            }
            default: {
                String msg = "Unsupported operation id: " + operation.id;
                throw new RuntimeException(msg);
            }
        }
        this.addToOperations(name, value);
    }

    private void addToOperations(Object ... args) {
        this.operations.add(args);
    }

    private void addClientOperation(String name, float ... args) {
        this.addClientOperation(new Object[]{name}, args);
    }

    private void addClientOperation(String name, String argText, float ... args) {
        this.addClientOperation(new Object[]{name, argText}, args);
    }

    private void addClientOperation(Object[] objects, float[] numbers) {
        Object[] operation = new Object[objects.length + numbers.length];
        int i = 0;
        while (i < objects.length) {
            operation[i] = objects[i];
            ++i;
        }
        i = objects.length;
        while (i < operation.length) {
            operation[i] = new Float(numbers[i - objects.length]);
            ++i;
        }
        this.operations.add(operation);
    }

    private static Adaptable getGC(Widget widget) {
        WidgetAdapter adapter = (WidgetAdapter)widget.getAdapter(IWidgetAdapter.class);
        return adapter.getGCForClient();
    }

    private float getOffset(boolean fill) {
        float result = 0.0f;
        if (!fill && this.lineWidth % 2 != 0) {
            result = 0.5f;
        }
        return result;
    }

    float round(double value, int decimals) {
        int factor = (int)Math.pow(10.0, decimals);
        return (float)Math.round((double)factor * value) / (float)factor;
    }
}

