/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.util.ArrayList;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.dnd.DNDEvent;
import org.eclipse.swt.internal.dnd.IDNDAdapter;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DNDSupport {
    private static final String EVENT_DRAG_START = "dragStart";
    private static final String EVENT_DRAG_ENTER = "dragEnter";
    private static final String EVENT_DRAG_OPERATION_CHANGED = "dragOperationChanged";
    private static final String EVENT_DRAG_OVER = "dragOver";
    private static final String EVENT_DRAG_LEAVE = "dragLeave";
    private static final String EVENT_DROP_ACCEPT = "dropAccept";
    private static final String EVENT_DRAG_FINISHED = "dragFinished";
    private static final String EVENT_PARAM_OPERATION = "operation";
    private static final String EVENT_PARAM_ITEM = "item";
    private static final String EVENT_PARAM_TIME = "time";
    private static final String EVENT_PARAM_SOURCE = "source";
    private static final String EVENT_PARAM_FEEDBACK = "feedback";
    private static final String EVENT_PARAM_DATATYPE = "dataType";

    private DNDSupport() {
    }

    public static void processEvents() {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                DNDSupport.processDragStart();
                if (DNDSupport.isLeaveBeforeEnter()) {
                    DNDSupport.processDragLeave();
                    DNDSupport.processDragEnter();
                    DNDSupport.processDragOperationChanged();
                    DNDSupport.processDragOver();
                } else {
                    DNDSupport.processDragEnter();
                    DNDSupport.processDragOperationChanged();
                    DNDSupport.processDragOver();
                    DNDSupport.processDragLeave();
                }
                DNDSupport.processDragFinished();
            }
        });
    }

    private static void processDragStart() {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation notify = message.getLastNotifyOperationFor(null, EVENT_DRAG_START);
        if (notify != null) {
            Control control = (Control)DNDSupport.findWidgetById(notify.getTarget());
            DragSource dragSource = DNDSupport.getDragSource(control);
            Point point = DNDSupport.readXYParams(notify);
            Point mappedPoint = control.getDisplay().map(null, control, point);
            Event dragDetectEvent = DNDSupport.createDragDetectEvent(notify, control, mappedPoint);
            control.notifyListeners(29, dragDetectEvent);
            DNDEvent dragStartEvent = DNDSupport.createDragStartEvent(dragSource, mappedPoint, dragDetectEvent.time);
            dragSource.notifyListeners(2008, dragStartEvent);
            if (!dragStartEvent.doit) {
                DNDSupport.getDNDAdapter(dragSource).cancel();
            }
        }
    }

    private static void processDragEnter() {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation notify = message.getLastNotifyOperationFor(null, EVENT_DRAG_ENTER);
        if (notify != null) {
            Control control = (Control)DNDSupport.findWidgetById(notify.getTarget());
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Control sourceControl = DNDSupport.readControlParam(notify);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            Point point = DNDSupport.readXYParams(notify);
            DNDEvent event = new DNDEvent();
            int operation = DNDSupport.readOperationParam(notify);
            int feedback = DNDSupport.readIntParam(notify, EVENT_PARAM_FEEDBACK);
            Item item = DNDSupport.readItemParam(notify);
            TransferData[] validDataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            TransferData dataType = validDataTypes[0];
            event.detail = operation;
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            event.feedback = feedback;
            event.dataType = dataType;
            event.dataTypes = validDataTypes;
            event.item = item;
            event.x = point.x;
            event.y = point.y;
            event.time = DNDSupport.readIntParam(notify, EVENT_PARAM_TIME);
            dropTarget.notifyListeners(2002, event);
            if (event.detail != operation) {
                DNDSupport.changeOperation(dragSource, dropTarget, event.detail);
            }
            DNDSupport.changeDataType(dragSource, dropTarget, event.dataType);
            if (event.feedback != feedback) {
                DNDSupport.getDNDAdapter(dragSource).setFeedbackChanged(control, event.feedback);
            }
        }
    }

    private static void processDragOver() {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation notify = message.getLastNotifyOperationFor(null, EVENT_DRAG_OVER);
        if (notify != null) {
            Control control = (Control)DNDSupport.findWidgetById(notify.getTarget());
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Control sourceControl = DNDSupport.readControlParam(notify);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            int operation = DNDSupport.readOperationParam(dndAdapter, notify);
            int feedback = DNDSupport.readFeedbackParam(dndAdapter, notify);
            TransferData dataType = DNDSupport.readTransferDataParam(dndAdapter, notify);
            Point point = DNDSupport.readXYParams(notify);
            Item item = DNDSupport.readItemParam(notify);
            DNDEvent event = new DNDEvent();
            event.detail = operation;
            event.feedback = feedback;
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            event.dataType = dataType;
            event.dataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            event.item = item;
            event.x = point.x;
            event.y = point.y;
            event.time = DNDSupport.readIntParam(notify, EVENT_PARAM_TIME);
            dropTarget.notifyListeners(2004, event);
            if (event.detail != operation) {
                DNDSupport.changeOperation(dragSource, dropTarget, event.detail);
            }
            if (event.dataType != dataType) {
                DNDSupport.changeDataType(dragSource, dropTarget, event.dataType);
            }
            if (event.feedback != feedback) {
                DNDSupport.getDNDAdapter(dragSource).setFeedbackChanged(control, event.feedback);
            }
        }
    }

    private static void processDragOperationChanged() {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation notify = message.getLastNotifyOperationFor(null, EVENT_DRAG_OPERATION_CHANGED);
        if (notify != null) {
            Control control = (Control)DNDSupport.findWidgetById(notify.getTarget());
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Control sourceControl = DNDSupport.readControlParam(notify);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            int operation = DNDSupport.readOperationParam(dndAdapter, notify);
            int feedback = DNDSupport.readFeedbackParam(dndAdapter, notify);
            TransferData dataType = DNDSupport.readTransferDataParam(dndAdapter, notify);
            Point point = DNDSupport.readXYParams(notify);
            Item item = DNDSupport.readItemParam(notify);
            DNDEvent event = new DNDEvent();
            event.detail = operation;
            event.feedback = feedback;
            event.dataType = dataType;
            event.dataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            event.item = item;
            event.x = point.x;
            event.y = point.y;
            event.time = DNDSupport.readIntParam(notify, EVENT_PARAM_TIME);
            dropTarget.notifyListeners(2005, event);
            if (event.detail != operation) {
                DNDSupport.changeOperation(dragSource, dropTarget, event.detail);
            }
            if (event.dataType != dataType) {
                DNDSupport.changeDataType(dragSource, dropTarget, event.dataType);
            }
            if (event.feedback != feedback) {
                DNDSupport.getDNDAdapter(dragSource).setFeedbackChanged(control, event.feedback);
            }
        }
    }

    private static void processDragLeave() {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation notify = message.getLastNotifyOperationFor(null, EVENT_DRAG_LEAVE);
        if (notify != null) {
            Control control = (Control)DNDSupport.findWidgetById(notify.getTarget());
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Point point = DNDSupport.readXYParams(notify);
            int operation = DNDSupport.readOperationParam(notify);
            int time = DNDSupport.readIntParam(notify, EVENT_PARAM_TIME);
            DNDSupport.fireDragLeave(operation, dropTarget, point, time);
        }
    }

    private static void processDragFinished() {
        int operation = 0;
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation notify = message.getLastNotifyOperationFor(null, EVENT_DROP_ACCEPT);
        if (notify != null) {
            Control dropTargetControl = (Control)DNDSupport.findWidgetById(notify.getTarget());
            DropTarget dropTarget = DNDSupport.getDropTarget(dropTargetControl);
            Control sourceControl = DNDSupport.readControlParam(notify);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            operation = DNDSupport.readOperationParam(dndAdapter, notify);
            TransferData dataType = DNDSupport.readTransferDataParam(dndAdapter, notify);
            Point point = DNDSupport.readXYParams(notify);
            Item item = DNDSupport.readItemParam(notify);
            int time = DNDSupport.readIntParam(notify, EVENT_PARAM_TIME);
            DNDSupport.fireDragLeave(operation, dropTarget, point, time);
            DNDEvent event = DNDSupport.createDropAcceptEvent(dropTarget, operation, point, dataType, item);
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            dropTarget.notifyListeners(2007, event);
            operation = DNDSupport.checkOperation(dragSource, dropTarget, event.detail);
            TransferData[] validDataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            dataType = DNDSupport.checkDataType(event.dataType, validDataTypes);
            if (operation != 0 && dataType != null) {
                DNDEvent setDataEvent = DNDSupport.createDragSetDataEvent(dragSource, dataType, point);
                dragSource.notifyListeners(2001, setDataEvent);
                Object data = DNDSupport.transferData(dropTarget, dataType, setDataEvent);
                DNDEvent dropEvent = new DNDEvent();
                dropEvent.detail = operation;
                dropEvent.operations = DNDSupport.getOperations(dragSource, dropTarget);
                dropEvent.dataType = dataType;
                dropEvent.dataTypes = validDataTypes;
                dropEvent.item = item;
                dropEvent.x = point.x;
                dropEvent.y = point.y;
                dropEvent.data = data;
                dropTarget.notifyListeners(2006, dropEvent);
                operation = DNDSupport.checkOperation(dragSource, dropTarget, dropEvent.detail);
            }
        }
        DNDSupport.fireDragFinished(operation);
    }

    private static Event createDragDetectEvent(ClientMessage.NotifyOperation operation, Control control, Point point) {
        Event result = new Event();
        result.x = point.x;
        result.y = point.y;
        result.button = 1;
        result.time = DNDSupport.readIntParam(operation, EVENT_PARAM_TIME);
        return result;
    }

    private static DNDEvent createDragStartEvent(DragSource dragSource, Point point, int time) {
        DNDEvent result = new DNDEvent();
        result.detail = 0;
        result.x = point.x;
        result.y = point.y;
        result.doit = true;
        result.time = time;
        return result;
    }

    private static DNDEvent createDragSetDataEvent(DragSource dragSource, TransferData dataType, Point point) {
        DNDEvent result = new DNDEvent();
        result.detail = 0;
        result.dataType = dataType;
        result.x = point.x;
        result.y = point.y;
        result.data = null;
        result.doit = true;
        return result;
    }

    private static DNDEvent createDropAcceptEvent(DropTarget dropTarget, int operation, Point point, TransferData dataType, Item item) {
        DNDEvent result = new DNDEvent();
        result.detail = operation;
        result.x = point.x;
        result.y = point.y;
        result.item = item;
        result.dataType = dataType;
        return result;
    }

    private static void fireDragLeave(int operation, DropTarget dropTarget, Point point, int time) {
        DNDEvent event = new DNDEvent();
        event.detail = operation;
        event.x = point.x;
        event.y = point.y;
        event.time = time;
        dropTarget.notifyListeners(2003, event);
    }

    private static void fireDragFinished(int operation) {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation notify = message.getLastNotifyOperationFor(null, EVENT_DRAG_FINISHED);
        if (notify != null) {
            Control dragSourceControl = (Control)DNDSupport.findWidgetById(notify.getTarget());
            DragSource dragSource = DNDSupport.getDragSource(dragSourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            dndAdapter.cancelDetailChanged();
            dndAdapter.cancelFeedbackChanged();
            dndAdapter.cancelDataTypeChanged();
            Point point = DNDSupport.readXYParams(notify);
            DNDEvent event = new DNDEvent();
            event.x = point.x;
            event.y = point.y;
            event.detail = operation;
            event.doit = true;
            event.time = DNDSupport.readIntParam(notify, EVENT_PARAM_TIME);
            dragSource.notifyListeners(2000, event);
        }
    }

    private static IDNDAdapter getDNDAdapter(DragSource dragSource) {
        return dragSource.getAdapter(IDNDAdapter.class);
    }

    private static DropTarget getDropTarget(Control control) {
        return (DropTarget)control.getData("DropTarget");
    }

    private static DragSource getDragSource(Control control) {
        return (DragSource)control.getData("DragSource");
    }

    private static Object transferData(DropTarget dropTarget, TransferData dataType, DNDEvent setDataEvent) {
        Object data = null;
        if (setDataEvent.doit) {
            Transfer transfer = DNDSupport.findTransferByType(dataType, dropTarget);
            transfer.javaToNative(setDataEvent.data, dataType);
            data = transfer.nativeToJava(dataType);
        }
        return data;
    }

    static TransferData[] determineDataTypes(DragSource dragSource, DropTarget dropTarget) {
        ArrayList<TransferData> supportedTypes = new ArrayList<TransferData>();
        Transfer[] dragSourceTransfers = dragSource.getTransfer();
        Transfer[] dropTargetTransfers = dropTarget.getTransfer();
        int i = 0;
        while (i < dragSourceTransfers.length) {
            TransferData[] dataTypes = dragSourceTransfers[i].getSupportedTypes();
            int j = 0;
            while (j < dropTargetTransfers.length) {
                int k = 0;
                while (k < dataTypes.length) {
                    if (dropTargetTransfers[j].isSupportedType(dataTypes[k])) {
                        supportedTypes.add(dataTypes[k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        TransferData[] result = new TransferData[supportedTypes.size()];
        int i2 = 0;
        while (i2 < supportedTypes.size()) {
            result[i2] = (TransferData)supportedTypes.get(i2);
            ++i2;
        }
        return result;
    }

    private static Transfer findTransferByType(TransferData type, DropTarget dropTarget) {
        Transfer result = null;
        Transfer[] supported = dropTarget.getTransfer();
        int i = 0;
        while (result == null && i < supported.length) {
            if (supported[i].isSupportedType(type)) {
                result = supported[i];
            }
            ++i;
        }
        return result;
    }

    private static Widget findWidgetById(String id) {
        Widget result = null;
        Display display = LifeCycleUtil.getSessionDisplay();
        Shell[] shells = DNDSupport.getDisplayAdapter(display).getShells();
        int i = 0;
        while (result == null && i < shells.length) {
            Widget widget = WidgetUtil.find(shells[i], id);
            if (widget != null) {
                result = widget;
            }
            ++i;
        }
        return result;
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter;
    }

    private static String readStringParam(ClientMessage.NotifyOperation operation, String property) {
        String result = null;
        Object value = operation.getProperty(property);
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    private static int readIntParam(ClientMessage.NotifyOperation operation, String property) {
        String value = DNDSupport.readStringParam(operation, property);
        return NumberFormatUtil.parseInt(value);
    }

    private static Control readControlParam(ClientMessage.NotifyOperation operation) {
        Control result = null;
        String value = (String)operation.getProperty(EVENT_PARAM_SOURCE);
        if (value != null) {
            result = (Control)DNDSupport.findWidgetById(value);
        }
        return result;
    }

    private static Item readItemParam(ClientMessage.NotifyOperation operation) {
        Item result = null;
        String value = DNDSupport.readStringParam(operation, EVENT_PARAM_ITEM);
        if (value != null) {
            result = (Item)DNDSupport.findWidgetById(value);
        }
        return result;
    }

    private static TransferData readDataTypeParam(ClientMessage.NotifyOperation operation) {
        TransferData result = null;
        String value = DNDSupport.readStringParam(operation, EVENT_PARAM_DATATYPE);
        String string = value = "null".equals(value) ? null : value;
        if (value != null) {
            result = new TransferData();
            result.type = NumberFormatUtil.parseInt(value);
        }
        return result;
    }

    private static Point readXYParams(ClientMessage.NotifyOperation operation) {
        int x = DNDSupport.readIntParam(operation, "x");
        int y = DNDSupport.readIntParam(operation, "y");
        return new Point(x, y);
    }

    private static int readOperationParam(IDNDAdapter dndAdapter, ClientMessage.NotifyOperation operation) {
        int result = dndAdapter.hasDetailChanged() ? dndAdapter.getDetailChangedValue() : DNDSupport.readOperationParam(operation);
        return result;
    }

    private static int readFeedbackParam(IDNDAdapter dndAdapter, ClientMessage.NotifyOperation operation) {
        int result = dndAdapter.hasFeedbackChanged() ? dndAdapter.getFeedbackChangedValue() : DNDSupport.readIntParam(operation, EVENT_PARAM_FEEDBACK);
        return result;
    }

    private static TransferData readTransferDataParam(IDNDAdapter adapter, ClientMessage.NotifyOperation operation) {
        TransferData result = adapter.hasDataTypeChanged() ? adapter.getDataTypeChangedValue() : DNDSupport.readDataTypeParam(operation);
        return result;
    }

    private static int readOperationParam(ClientMessage.NotifyOperation operation) {
        int result = 0;
        String value = DNDSupport.readStringParam(operation, EVENT_PARAM_OPERATION);
        if ("copy".equals(value)) {
            result = 1;
        } else if ("move".equals(value)) {
            result = 2;
        } else if ("link".equals(value)) {
            result = 4;
        }
        return result;
    }

    private static boolean isLeaveBeforeEnter() {
        boolean result = false;
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation enter = message.getLastNotifyOperationFor(null, EVENT_DRAG_ENTER);
        ClientMessage.NotifyOperation leave = message.getLastNotifyOperationFor(null, EVENT_DRAG_LEAVE);
        if (enter != null && leave != null) {
            int enterTime = DNDSupport.readIntParam(enter, EVENT_PARAM_TIME);
            int leaveTime = DNDSupport.readIntParam(leave, EVENT_PARAM_TIME);
            result = leaveTime <= enterTime;
        }
        return result;
    }

    private static void changeOperation(DragSource dragSource, DropTarget dropTarget, int detail) {
        int checkedOperation = DNDSupport.checkOperation(dragSource, dropTarget, detail);
        IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
        dndAdapter.setDetailChanged(dropTarget.getControl(), checkedOperation);
    }

    private static void changeDataType(DragSource dragSource, DropTarget dropTarget, TransferData dataType) {
        TransferData[] validDataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
        TransferData value = DNDSupport.checkDataType(dataType, validDataTypes);
        if (value == null) {
            value = validDataTypes[0];
        }
        Control control = dropTarget.getControl();
        DNDSupport.getDNDAdapter(dragSource).setDataTypeChanged(control, value);
    }

    private static int getOperations(DragSource dragSource, DropTarget dropTarget) {
        return dragSource.getStyle() & dropTarget.getStyle();
    }

    private static int checkOperation(DragSource dragSource, DropTarget dropTarget, int operation) {
        int result = 0;
        int allowedOperations = DNDSupport.getOperations(dragSource, dropTarget);
        if ((allowedOperations & operation) != 0) {
            result = operation;
        }
        return result;
    }

    private static TransferData checkDataType(TransferData dataType, TransferData[] validTypes) {
        boolean isValidType = false;
        int i = 0;
        while (i < validTypes.length) {
            if (!isValidType) {
                isValidType = TransferData.sameType(dataType, validTypes[i]);
            }
            ++i;
        }
        return isValidType ? dataType : null;
    }
}

