/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.io.IOException;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rap.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.RequestId;
import org.eclipse.rap.rwt.internal.lifecycle.UITestUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.displaykit.DNDSupport;
import org.eclipse.swt.internal.widgets.displaykit.UICallBackRenderer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayLCA
implements IDisplayLifeCycleAdapter {
    private static final String PROP_REQUEST_COUNTER = "requestCounter";
    static final String PROP_FOCUS_CONTROL = "focusControl";
    static final String PROP_EXIT_CONFIRMATION = "exitConfirmation";
    private static final String METHOD_BEEP = "beep";

    public void readData(Display display) {
        DisplayLCA.readBounds(display);
        DisplayLCA.readCursorLocation(display);
        DisplayLCA.readFocusControl(display);
        WidgetTreeVisitor.AllWidgetTreeVisitor visitor = new WidgetTreeVisitor.AllWidgetTreeVisitor(){

            public boolean doVisit(Widget widget) {
                AbstractWidgetLCA adapter = WidgetUtil.getLCA(widget);
                adapter.readData(widget);
                return true;
            }
        };
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            WidgetTreeVisitor.accept(shell, visitor);
            ++i;
        }
        i = 0;
        while (i < shells.length) {
            if (shells[i].getMaximized() || shells[i].getFullScreen()) {
                IShellAdapter adapter;
                IShellAdapter shellAdapter = adapter = shells[i].getAdapter(IShellAdapter.class);
                shellAdapter.setBounds(display.getBounds());
            }
            ++i;
        }
        DNDSupport.processEvents();
    }

    public void preserveValues(Display display) {
        IWidgetAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_FOCUS_CONTROL, display.getFocusControl());
        adapter.preserve(PROP_EXIT_CONFIRMATION, DisplayLCA.getExitConfirmation());
        ActiveKeysUtil.preserveActiveKeys(display);
        ActiveKeysUtil.preserveCancelKeys(display);
        if (adapter.isInitialized()) {
            Shell[] shells = DisplayLCA.getShells(display);
            int i = 0;
            while (i < shells.length) {
                WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                    public boolean doVisit(Widget widget) {
                        AbstractWidgetLCA widgetLCA = WidgetUtil.getLCA(widget);
                        widgetLCA.preserveValues(widget);
                        return true;
                    }
                });
                ++i;
            }
        }
    }

    public void render(Display display) throws IOException {
        DisplayLCA.disposeWidgets();
        DisplayLCA.renderRequestCounter();
        DisplayLCA.renderExitConfirmation(display);
        DisplayLCA.renderEnableUiTests(display);
        DisplayLCA.renderShells(display);
        DisplayLCA.renderFocus(display);
        DisplayLCA.renderBeep(display);
        DisplayLCA.renderUICallBack(display);
        DisplayLCA.markInitialized(display);
        ActiveKeysUtil.renderActiveKeys(display);
        ActiveKeysUtil.renderCancelKeys(display);
    }

    public void clearPreserved(Display display) {
        WidgetAdapter widgetAdapter = (WidgetAdapter)DisplayUtil.getAdapter(display);
        widgetAdapter.clearPreserved();
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    WidgetAdapter widgetAdapter = (WidgetAdapter)WidgetUtil.getAdapter(widget);
                    widgetAdapter.clearPreserved();
                    return true;
                }
            });
            ++i;
        }
    }

    private static void renderShells(Display display) throws IOException {
        RenderVisitor visitor = new RenderVisitor();
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            WidgetTreeVisitor.accept(shells[i], visitor);
            visitor.reThrowProblem();
            ++i;
        }
    }

    private static void renderRequestCounter() {
        ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
        Integer requestId = RequestId.getInstance().nextRequestId();
        protocolWriter.appendHead(PROP_REQUEST_COUNTER, requestId);
    }

    private static void renderExitConfirmation(Display display) {
        boolean hasChanged;
        String exitConfirmation = DisplayLCA.getExitConfirmation();
        IWidgetAdapter adapter = DisplayUtil.getAdapter(display);
        Object oldExitConfirmation = adapter.getPreserved(PROP_EXIT_CONFIRMATION);
        boolean bl = exitConfirmation == null ? oldExitConfirmation != null : (hasChanged = !exitConfirmation.equals(oldExitConfirmation));
        if (hasChanged) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(display);
            clientObject.set(PROP_EXIT_CONFIRMATION, exitConfirmation);
        }
    }

    private static String getExitConfirmation() {
        ExitConfirmation exitConfirmation = RWT.getClient().getService(ExitConfirmation.class);
        return exitConfirmation == null ? null : exitConfirmation.getMessage();
    }

    private static void disposeWidgets() throws IOException {
        AbstractWidgetLCA lca;
        Widget toDispose;
        Widget[] disposedWidgets = DisposedWidgets.getAll();
        int i = disposedWidgets.length - 1;
        while (i >= 0) {
            toDispose = disposedWidgets[i];
            if (toDispose instanceof DragSource || toDispose instanceof DropTarget) {
                lca = WidgetUtil.getLCA(toDispose);
                lca.renderDispose(toDispose);
            }
            --i;
        }
        i = disposedWidgets.length - 1;
        while (i >= 0) {
            toDispose = disposedWidgets[i];
            if (!(toDispose instanceof DragSource) && !(toDispose instanceof DropTarget)) {
                lca = WidgetUtil.getLCA(toDispose);
                lca.renderDispose(toDispose);
            }
            --i;
        }
    }

    private static void renderFocus(Display display) {
        if (!display.isDisposed()) {
            Control focusControl;
            IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
            IWidgetAdapter widgetAdapter = DisplayUtil.getAdapter(display);
            Object oldValue = widgetAdapter.getPreserved(PROP_FOCUS_CONTROL);
            if ((!widgetAdapter.isInitialized() || oldValue != display.getFocusControl() || displayAdapter.isFocusInvalidated()) && (focusControl = display.getFocusControl()) != null) {
                IClientObject clientObject = ClientObjectFactory.getClientObject(display);
                clientObject.set(PROP_FOCUS_CONTROL, WidgetUtil.getId(display.getFocusControl()));
            }
        }
    }

    private static void renderBeep(Display display) {
        IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
        if (displayAdapter.isBeepCalled()) {
            displayAdapter.resetBeep();
            IClientObject clientObject = ClientObjectFactory.getClientObject(display);
            clientObject.call(METHOD_BEEP, null);
        }
    }

    private static void renderUICallBack(Display display) {
        new UICallBackRenderer().render();
    }

    private static void renderEnableUiTests(Display display) {
        WidgetAdapter adapter;
        if (UITestUtil.isEnabled() && !(adapter = (WidgetAdapter)DisplayUtil.getAdapter(display)).isInitialized()) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(display);
            clientObject.set("enableUiTests", true);
        }
    }

    private static void markInitialized(Display display) {
        WidgetAdapter adapter = (WidgetAdapter)DisplayUtil.getAdapter(display);
        adapter.setInitialized(true);
    }

    static void readBounds(Display display) {
        Rectangle oldBounds = display.getBounds();
        Rectangle bounds = ProtocolUtil.readPropertyValueAsRectangle("w1", "bounds");
        if (bounds == null) {
            bounds = new Rectangle(0, 0, oldBounds.width, oldBounds.height);
        }
        DisplayLCA.getDisplayAdapter(display).setBounds(bounds);
    }

    private static void readCursorLocation(Display display) {
        Point location = ProtocolUtil.readPropertyValueAsPoint(DisplayUtil.getId(display), "cursorLocation");
        if (location == null) {
            location = new Point(0, 0);
        }
        DisplayLCA.getDisplayAdapter(display).setCursorLocation(location.x, location.y);
    }

    static void readFocusControl(Display display) {
        String id = DisplayLCA.readPropertyValue(display, PROP_FOCUS_CONTROL);
        if (id != null) {
            Control focusControl = null;
            if (!"null".equals(id)) {
                Shell[] shells = DisplayLCA.getDisplayAdapter(display).getShells();
                int i = 0;
                while (focusControl == null && i < shells.length) {
                    Widget widget = WidgetUtil.find(shells[i], id);
                    if (widget instanceof Control) {
                        focusControl = (Control)widget;
                    }
                    ++i;
                }
            }
            if (focusControl != null && EventUtil.isAccessible(focusControl)) {
                DisplayLCA.getDisplayAdapter(display).setFocusControl(focusControl);
            }
        }
    }

    private static String readPropertyValue(Display display, String propertyName) {
        return ProtocolUtil.readPropertyValueAsString(DisplayUtil.getId(display), propertyName);
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter;
    }

    private static Shell[] getShells(Display display) {
        return DisplayLCA.getDisplayAdapter(display).getShells();
    }

    private static final class RenderVisitor
    extends WidgetTreeVisitor.AllWidgetTreeVisitor {
        private IOException ioProblem;

        private RenderVisitor() {
        }

        public boolean doVisit(Widget widget) {
            this.ioProblem = null;
            boolean result = true;
            try {
                RenderVisitor.render(widget);
                RenderVisitor.runRenderRunnable(widget);
            }
            catch (IOException ioe) {
                this.ioProblem = ioe;
                result = false;
            }
            return result;
        }

        private void reThrowProblem() throws IOException {
            if (this.ioProblem != null) {
                throw this.ioProblem;
            }
        }

        private static void render(Widget widget) throws IOException {
            WidgetUtil.getLCA(widget).render(widget);
        }

        private static void runRenderRunnable(Widget widget) throws IOException {
            WidgetAdapter adapter = (WidgetAdapter)WidgetUtil.getAdapter(widget);
            if (adapter.getRenderRunnable() != null) {
                adapter.getRenderRunnable().afterRender();
                adapter.clearRenderRunnable();
            }
        }
    }
}

